/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EjbJarProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private EjbJarProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public EjbJarProjectOperations(EjbJarProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        EjbJarProjectOperations.addFile(projectDirectory, "nbproject", files);
        EjbJarProjectOperations.addFile(projectDirectory, "build.xml", files);
        EjbJarProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        File f;
        AntProjectHelper helper;
        FileObject resourceFO;
        FileObject srcDir;
        FileObject projectDirectory;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        FileObject metaInf = this.project.getEjbModule().getMetaInf();
        if (metaInf != null) {
            files.add(metaInf);
        }
        SourceRoots src = this.project.getSourceRoots();
        FileObject[] srcRoots = src.getRoots();
        for (int cntr = 0; cntr < srcRoots.length; ++cntr) {
            files.add(srcRoots[cntr]);
        }
        PropertyEvaluator evaluator = this.project.evaluator();
        String prop = evaluator.getProperty("source.root");
        if (prop != null && (projectDirectory = this.project.getProjectDirectory()) != (srcDir = this.project.getAntProjectHelper().resolveFileObject(prop)) && !files.contains(srcDir)) {
            files.add(srcDir);
        }
        SourceRoots test = this.project.getTestSourceRoots();
        FileObject[] testRoots = test.getRoots();
        for (int cntr = 0; cntr < testRoots.length; ++cntr) {
            files.add(testRoots[cntr]);
        }
        File resourceDir = this.project.getEjbModule().getResourceDirectory();
        if (resourceDir != null && (resourceFO = FileUtil.toFileObject((File)resourceDir)) != null) {
            files.add(resourceFO);
        }
        if ((helper = this.project.getAntProjectHelper()).getLibrariesLocation() != null && (f = helper.resolveFile(helper.getLibrariesLocation())) != null && f.exists()) {
            FileObject libFolder = FileUtil.toFileObject((File)f).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)libFolder)) {
                files.add(libFolder);
            }
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        ActionUtils.runTarget((FileObject)buildXML, (String[])new String[]{"clean"}, (Properties)new Properties()).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(originalPath);
        EjbJarProjectOperations origOperations = (EjbJarProjectOperations)original.getLookup().lookup(EjbJarProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        this.fixOtherReferences(originalPath);
        this.project.setName(nueName);
    }

    public void notifyMoving() throws IOException {
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.setName(newName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        EjbJarProjectOperations origOperations = (EjbJarProjectOperations)original.getLookup().lookup(EjbJarProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        this.fixOtherReferences(originalPath);
        ProjectManager.mutex().writeAccess(new Runnable(){
            final /* synthetic */ EjbJarProjectOperations this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                AntProjectHelper helper = this.this$0.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                String jarName = projectProps.get((Object)"jar.name");
                String oldName = jarName.substring(0, jarName.length() - 4);
                if (jarName.endsWith(".jar") && oldName.equals(oldProjectName)) {
                    projectProps.put("jar.name", newName + ".jar");
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    private void fixOtherReferences(final File originalPath) {
        String property = "meta.inf";
        final File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        ProjectManager.mutex().writeAccess(new Runnable(){
            final /* synthetic */ EjbJarProjectOperations this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String relative;
                EditableProperties props = this.this$0.project.getAntProjectHelper().getProperties("nbproject/project.properties");
                String path = props.getProperty("meta.inf");
                if (path == null) {
                    return;
                }
                if (path.startsWith(originalPath.getAbsolutePath()) && (relative = PropertyUtils.relativizeFile((File)originalPath, (File)new File(path))) != null) {
                    String fixedPath = new File(projectDir, relative).getAbsolutePath();
                    props.setProperty("meta.inf", fixedPath);
                    this.this$0.project.getAntProjectHelper().putProperties("nbproject/project.properties", props);
                }
            }
        });
    }

    private static boolean isParent(File folder, File fo) {
        if (folder.equals(fo)) {
            return false;
        }
        while (fo != null) {
            if (fo.equals(folder)) {
                return true;
            }
            fo = fo.getParentFile();
        }
        return false;
    }

    private void fixLibraryLocation(EjbJarProjectOperations original) throws IllegalArgumentException {
        String libPath = original.libraryPath;
        if (libPath != null) {
            if (!new File(libPath).isAbsolute()) {
                if (!original.libraryWithinProject) {
                    File file = original.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String relativized = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (relativized != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(relativized);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (original.libraryWithinProject && original.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)original.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File prjRoot = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)prjRoot, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(prjRoot.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fo = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fo != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fo);
                }
            }
        }
    }
}

