/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.AsyncIteratorFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidAsyncIterator;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

public final class AsyncIteratorFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<AsyncIteratorFunction> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncIteratorFunctionBuiltins();

    protected AsyncIteratorFunctionBuiltins() {
        super(JSAsyncIterator.CLASS_NAME, AsyncIteratorFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, AsyncIteratorFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return AsyncIteratorFunctionBuiltinsFactory.JSAsyncIteratorFromNodeGen.create(context, builtin, AsyncIteratorFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum AsyncIteratorFunction implements BuiltinEnum<AsyncIteratorFunction>
    {
        from(1);

        private final int length;

        private AsyncIteratorFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSAsyncIteratorFromNode
    extends JSBuiltinNode {
        @Node.Child
        private GetIteratorFlattenableNode getIteratorFlattenableNode;
        @Node.Child
        private InstanceofNode.OrdinaryHasInstanceNode ordinaryHasInstanceNode;

        public JSAsyncIteratorFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(false, true, context);
            this.ordinaryHasInstanceNode = InstanceofNode.OrdinaryHasInstanceNode.create(context);
        }

        @Specialization
        protected Object asyncIteratorFrom(Object arg) {
            IteratorRecord iteratorRecord = this.getIteratorFlattenableNode.execute(arg);
            JSRealm realm = this.getRealm();
            boolean hasInstance = this.ordinaryHasInstanceNode.executeBoolean(iteratorRecord.getIterator(), (Object)realm.getAsyncIteratorConstructor());
            if (hasInstance) {
                return iteratorRecord.getIterator();
            }
            return JSWrapForValidAsyncIterator.create(this.getContext(), realm, iteratorRecord);
        }
    }
}

