/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.debugger.ContextProvider;

public class RunToCursorActionProvider
extends JPDADebuggerActionProvider
implements PropertyChangeListener,
ActionsManagerListener {
    private Session session;
    private LineBreakpoint breakpoint;
    private ActionsManager lastActionsManager;

    public RunToCursorActionProvider(ContextProvider lookupProvider) {
        super((JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private ActionsManager getActionsManager() {
        ActionsManager current = RunToCursorActionProvider.getCurrentActionsManager();
        if (current != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            current.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = current;
        }
        return current;
    }

    protected void checkEnabled(int debuggerState) {
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && debuggerState == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && (EditorContextBridge.getContext().getCurrentURL().endsWith(".java") || EditorContextBridge.getContext().getCurrentURL().endsWith(".scala")));
        if (debuggerState != 2 && this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
        if (debuggerState == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        this.runToCursor();
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(action, new Runnable(){
            final /* synthetic */ RunToCursorActionProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.runToCursor();
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    public void runToCursor() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
        this.breakpoint = LineBreakpoint.create((String)EditorContextBridge.getContext().getCurrentURL(), (int)EditorContextBridge.getContext().getCurrentLineNumber());
        this.breakpoint.setHidden(true);
        JPDAThread currentThread = this.debugger.getCurrentThread();
        if (currentThread != null) {
            this.breakpoint.setThreadFilters((JPDADebugger)this.debugger, new JPDAThread[]{currentThread});
        }
        this.breakpoint.setSession((JPDADebugger)this.debugger);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        if (currentThread != null) {
            currentThread.resume();
        } else {
            this.session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
        }
    }

    public void actionPerformed(Object action) {
    }

    public void actionStateChanged(Object action, boolean enabled) {
        if (ActionsManager.ACTION_CONTINUE == action) {
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, enabled && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && (EditorContextBridge.getContext().getCurrentURL().endsWith(".java") || EditorContextBridge.getContext().getCurrentURL().endsWith(".scala")));
        }
    }
}

