/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug.client.cmdline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;
import org.netbeans.lib.v8debug.V8Body;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Event;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.V8StepAction;
import org.netbeans.lib.v8debug.commands.Backtrace;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.lib.v8debug.commands.ClearBreakpoint;
import org.netbeans.lib.v8debug.commands.Continue;
import org.netbeans.lib.v8debug.commands.Evaluate;
import org.netbeans.lib.v8debug.commands.Frame;
import org.netbeans.lib.v8debug.commands.GC;
import org.netbeans.lib.v8debug.commands.ListBreakpoints;
import org.netbeans.lib.v8debug.commands.Lookup;
import org.netbeans.lib.v8debug.commands.References;
import org.netbeans.lib.v8debug.commands.Scope;
import org.netbeans.lib.v8debug.commands.Scopes;
import org.netbeans.lib.v8debug.commands.Scripts;
import org.netbeans.lib.v8debug.commands.SetBreakpoint;
import org.netbeans.lib.v8debug.commands.Source;
import org.netbeans.lib.v8debug.commands.Threads;
import org.netbeans.lib.v8debug.commands.V8Flags;
import org.netbeans.lib.v8debug.commands.Version;
import org.netbeans.lib.v8debug.connection.ClientConnection;
import org.netbeans.lib.v8debug.connection.IOListener;
import org.netbeans.lib.v8debug.events.AfterCompileEventBody;
import org.netbeans.lib.v8debug.events.BreakEventBody;
import org.netbeans.lib.v8debug.events.CompileErrorEventBody;
import org.netbeans.lib.v8debug.events.ExceptionEventBody;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Boolean;
import org.netbeans.lib.v8debug.vars.V8Function;
import org.netbeans.lib.v8debug.vars.V8Number;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8ScriptValue;
import org.netbeans.lib.v8debug.vars.V8String;
import org.netbeans.lib.v8debug.vars.V8Value;

public class V8Debug {
    private static final ResourceBundle resource = ResourceBundle.getBundle(V8Debug.class.getPackage().getName() + ".Bundle");
    private static boolean debug = false;
    private static boolean closing = false;
    private final ClientConnection cc;
    private long requestSequence = 1L;
    private final Map<Long, V8Script> scriptsById = new HashMap<Long, V8Script>();
    private final Map<Long, V8Command> internalCommands = Collections.synchronizedMap(new HashMap());
    private long numFrames = -1L;
    private V8Frame[] framesToPrint;
    private String toEvaluate;
    private Testeable testeable;

    private V8Debug(String serverName, int serverPort) throws IOException {
        this.cc = new ClientConnection(serverName, serverPort);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(resource.getString("MSG_Usage"));
            return;
        }
        int i = 0;
        if ("--debug".equals(args[0])) {
            debug = true;
            ++i;
        }
        int serverPort = Integer.parseInt(args[i + 1]);
        try {
            V8Debug dbg = new V8Debug(args[i], serverPort);
            dbg.startCommandLoop();
            dbg.responseLoop();
        }
        catch (IOException ex) {
            if (!closing) {
                V8Debug.printERR("ERR_IO", ex.getLocalizedMessage());
            }
        }
        catch (ParseException pex) {
            V8Debug.printERR("ERR_ProtocolParseError", pex.getLocalizedMessage());
        }
    }

    private static void printPrompt() {
        System.out.print("> ");
    }

    private static void printMSG(String key, Object ... args) {
        System.out.println(MessageFormat.format(resource.getString(key), args));
    }

    private static void printERR(String key, Object ... args) {
        System.err.println(MessageFormat.format(resource.getString(key), args));
        if (debug) {
            Thread.dumpStack();
        }
    }

    private void startCommandLoop() throws IOException {
        Thread cmdLoop = new Thread(){

            @Override
            public void run() {
                InputStreamReader r = new InputStreamReader(System.in);
                BufferedReader br = new BufferedReader(r);
                try {
                    boolean cont;
                    String line;
                    while ((line = br.readLine()) != null && (cont = V8Debug.this.doCommand(line = line.trim()))) {
                    }
                    System.out.println("");
                    closing = true;
                    V8Debug.this.cc.close();
                }
                catch (IOException ex) {
                    V8Debug.printERR("ERR_IO", new Object[]{ex.getLocalizedMessage()});
                }
            }
        };
        cmdLoop.setDaemon(true);
        cmdLoop.start();
        this.internalCommands.put(this.requestSequence, V8Command.Scripts);
        V8Request scriptsRequest = Scripts.createRequest(this.requestSequence++);
        this.cc.send(scriptsRequest);
    }

    private void responseLoop() throws IOException, ParseException {
        try {
            this.cc.runEventLoop(new ClientConnection.Listener(){

                @Override
                public void header(Map<String, String> properties) {
                    V8Debug.printMSG("MSG_HeaderProperties", new Object[0]);
                    for (Map.Entry<String, String> pe : properties.entrySet()) {
                        System.out.println("  " + pe.getKey() + " = " + pe.getValue());
                    }
                    V8Debug.printPrompt();
                }

                @Override
                public void response(V8Response response) {
                    if (debug) {
                        System.out.println("response: " + response + ", success = " + response.isSuccess() + ", running = " + response.isRunning() + ", body = " + response.getBody());
                    }
                    boolean doPrompt = false;
                    try {
                        doPrompt = V8Debug.this.handleResponse(response);
                    }
                    catch (IOException ex) {
                        V8Debug.printERR("ERR_IO", new Object[]{ex.getLocalizedMessage()});
                    }
                    if (doPrompt) {
                        V8Debug.printPrompt();
                    }
                }

                @Override
                public void event(V8Event event) {
                    boolean doPrompt;
                    if (debug) {
                        System.out.println("event: " + event + ", name = " + (Object)((Object)event.getKind()));
                    }
                    if (doPrompt = V8Debug.this.handleEvent(event)) {
                        V8Debug.printPrompt();
                    }
                }
            });
        }
        finally {
            this.cc.close();
            if (this.testeable != null) {
                this.testeable.notifyClosed();
            }
        }
    }

    private boolean doCommand(String command) throws IOException {
        String[] word = V8Debug.getWord(command);
        String cmd = word[0];
        String args = word[1];
        switch (cmd) {
            case "version": {
                this.cc.send(Version.createRequest(this.requestSequence++));
                return true;
            }
            case "step": 
            case "s": {
                int count = -1;
                try {
                    count = Integer.parseInt(args);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (count >= 0) {
                    this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.in, count));
                } else {
                    switch (args) {
                        case "up": 
                        case "out": {
                            this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.out));
                            break;
                        }
                        case "over": {
                            this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.next));
                            break;
                        }
                        case "in": 
                        case "into": 
                        case "": {
                            this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.in));
                            break;
                        }
                        default: {
                            V8Debug.printMSG("ERR_UnknownCommandStep", args);
                            V8Debug.printPrompt();
                        }
                    }
                }
                return true;
            }
            case "next": 
            case "n": {
                int count = -1;
                try {
                    count = Integer.parseInt(args);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (count >= 0) {
                    this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.next, count));
                } else {
                    this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.next));
                }
                return true;
            }
            case "out": {
                int count = -1;
                try {
                    count = Integer.parseInt(args);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (count >= 0) {
                    this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.out, count));
                } else {
                    this.cc.send(Continue.createRequest(this.requestSequence++, V8StepAction.out));
                }
                return true;
            }
            case "cont": 
            case "c": {
                this.cc.send(Continue.createRequest(this.requestSequence++));
                return true;
            }
            case "break": 
            case "stop": {
                word = V8Debug.getWord(args);
                String where = word[0];
                String what = word[1];
                if (!where.equals("at") && !where.equals("in")) {
                    try {
                        long bpNumber = Long.parseLong(where);
                        this.changeBreakpoint(bpNumber, what);
                    }
                    catch (NumberFormatException nfex) {
                        V8Debug.printMSG("ERR_UnknownCommandStop", where);
                        V8Debug.printPrompt();
                    }
                } else {
                    this.setBreakpoint(what);
                }
                return true;
            }
            case "breakpoints": 
            case "bps": {
                this.cc.send(ListBreakpoints.createRequest(this.requestSequence++));
                return true;
            }
            case "clear": 
            case "cb": {
                if (args.isEmpty()) {
                    V8Debug.printMSG("ERR_NoBrkpNumToDelete", new Object[0]);
                    this.cc.send(ListBreakpoints.createRequest(this.requestSequence++));
                } else if (!"all".equals(args)) {
                    try {
                        this.deleteBreakpoints(args);
                    }
                    catch (NumberFormatException nfex) {
                        V8Debug.printMSG("ERR_WrongBrkpNumToDelete", args);
                        V8Debug.printPrompt();
                    }
                }
                return true;
            }
            case "where": 
            case "backtrace": 
            case "bt": {
                this.numFrames = -1L;
                this.cc.send(Backtrace.createRequest(this.requestSequence++, 0L, 1L, false, true));
                return true;
            }
            case "frame": 
            case "f": {
                if (args.isEmpty()) {
                    this.cc.send(Frame.createRequest(this.requestSequence++, null));
                } else {
                    try {
                        long frameNum = Long.parseLong(args);
                        this.cc.send(Frame.createRequest(this.requestSequence++, frameNum));
                    }
                    catch (NumberFormatException nfe) {
                        V8Debug.printMSG("ERR_WrongFrameNumber", args);
                        V8Debug.printPrompt();
                    }
                }
                return true;
            }
            case "scripts": {
                this.cc.send(Scripts.createRequest(this.requestSequence++));
                return true;
            }
            case "source": {
                Long frameNum = null;
                Long fromLine = null;
                Long toLine = null;
                if (!args.isEmpty()) {
                    Scanner scan = new Scanner(args);
                    if (scan.hasNextLong()) {
                        frameNum = scan.nextLong();
                    }
                    if (scan.hasNextLong()) {
                        fromLine = scan.nextLong();
                    }
                    if (scan.hasNextLong()) {
                        toLine = scan.nextLong();
                    }
                }
                this.cc.send(Source.createRequest(this.requestSequence++, frameNum, fromLine, toLine));
                return true;
            }
            case "scope": {
                if (args.isEmpty()) {
                    this.cc.send(Scope.createRequest(this.requestSequence++));
                } else {
                    Scanner scan = new Scanner(args);
                    if (!scan.hasNextLong()) {
                        V8Debug.printMSG("ERR_WrongScopeNumber", args);
                        V8Debug.printPrompt();
                    } else {
                        long scopeNumber = scan.nextLong();
                        Long frameNumber = null;
                        if (scan.hasNextLong()) {
                            frameNumber = scan.nextLong();
                        }
                        this.cc.send(Scope.createRequest(this.requestSequence++, scopeNumber, frameNumber));
                    }
                }
                return true;
            }
            case "scopes": {
                if (args.isEmpty()) {
                    this.cc.send(Scopes.createRequest(this.requestSequence++));
                } else {
                    try {
                        long frameNumber = Long.parseLong(args);
                        this.cc.send(Scopes.createRequest(this.requestSequence++, frameNumber));
                    }
                    catch (NumberFormatException nfe) {
                        V8Debug.printMSG("ERR_WrongFrameNumber", args);
                        V8Debug.printPrompt();
                    }
                }
                return true;
            }
            case "eval": {
                if (args.isEmpty()) {
                    // empty if block
                }
            }
            case "print": {
                this.toEvaluate = args;
                this.cc.send(Evaluate.createRequest(this.requestSequence++, args));
                return true;
            }
            case "locals": {
                this.cc.send(Frame.createRequest(this.requestSequence++, null));
                return true;
            }
            case "references": 
            case "refs": {
                if (args.isEmpty()) {
                    V8Debug.printMSG("ERR_MissingObjectHandle", new Object[0]);
                    V8Debug.printPrompt();
                } else {
                    try {
                        long handle = Long.parseLong(args);
                        this.cc.send(References.createRequest(this.requestSequence++, References.Type.referencedBy, handle));
                    }
                    catch (NumberFormatException nfe) {
                        V8Debug.printMSG("ERR_WrongObjectHandle", args);
                        V8Debug.printPrompt();
                    }
                }
                return true;
            }
            case "instances": 
            case "insts": {
                if (args.isEmpty()) {
                    V8Debug.printMSG("ERR_MissingObjectHandle", new Object[0]);
                    V8Debug.printPrompt();
                } else {
                    try {
                        long handle = Long.parseLong(args);
                        this.cc.send(References.createRequest(this.requestSequence++, References.Type.constructedBy, handle));
                    }
                    catch (NumberFormatException nfe) {
                        V8Debug.printMSG("ERR_WrongObjectHandle", args);
                        V8Debug.printPrompt();
                    }
                }
                return true;
            }
            case "lookup": {
                if (!args.isEmpty()) {
                    Scanner scan = new Scanner(args = args.replace(',', ' '));
                    if (!scan.hasNextLong()) {
                        V8Debug.printMSG("ERR_WrongObjectHandle", args);
                        V8Debug.printPrompt();
                    } else {
                        ArrayList<Long> handlesL = new ArrayList<Long>();
                        while (scan.hasNextLong()) {
                            long handle = scan.nextLong();
                            handlesL.add(handle);
                        }
                        long[] handles = new long[handlesL.size()];
                        for (int i = 0; i < handlesL.size(); ++i) {
                            handles[i] = (Long)handlesL.get(i);
                        }
                        this.cc.send(Lookup.createRequest(this.requestSequence++, handles, false));
                    }
                } else {
                    V8Debug.printMSG("ERR_MissingObjectHandle", new Object[0]);
                    V8Debug.printPrompt();
                }
                return true;
            }
            case "gc": {
                if (args.isEmpty()) {
                    this.cc.send(GC.createRequest(this.requestSequence++));
                } else {
                    this.cc.send(GC.createRequest(this.requestSequence++, args));
                }
                return true;
            }
            case "flags": {
                this.cc.send(V8Flags.createRequest(this.requestSequence++, args));
                return true;
            }
            case "threads": {
                this.cc.send(new V8Request(this.requestSequence++, V8Command.Threads, null));
                return true;
            }
            case "exit": 
            case "quit": {
                this.cc.send(new V8Request(this.requestSequence++, V8Command.Disconnect, null));
                return true;
            }
            case "help": {
                V8Debug.printMSG("MSG_Help", new Object[0]);
                V8Debug.printPrompt();
                return true;
            }
        }
        if (!cmd.isEmpty()) {
            V8Debug.printMSG("ERR_UnknownCommand", cmd);
        }
        V8Debug.printPrompt();
        return true;
    }

    private static String[] getWord(String str) {
        int index;
        for (index = 0; index < str.length() && !Character.isWhitespace(str.charAt(index)); ++index) {
        }
        String word = str.substring(0, index);
        String rest = index >= str.length() ? "" : str.substring(index).trim();
        return new String[]{word, rest};
    }

    private void setBreakpoint(String fileLine) throws IOException {
        Long column;
        long line;
        int end;
        int sep = fileLine.indexOf(58);
        if (sep < 0) {
            V8Debug.printERR("ERR_NoLineNumber", new Object[0]);
            return;
        }
        String scriptName = fileLine.substring(0, sep).trim();
        while (++sep < fileLine.length() && Character.isWhitespace(fileLine.charAt(sep))) {
        }
        if (sep == fileLine.length()) {
            V8Debug.printERR("ERR_NoLineNumber", new Object[0]);
            return;
        }
        String lineStr = fileLine.substring(sep);
        if ((sep = lineStr.indexOf(58)) < 0) {
            end = lineStr.indexOf(32);
            if (end < 0) {
                end = lineStr.length();
            }
            try {
                line = Long.parseLong(lineStr.substring(0, end).trim());
            }
            catch (NumberFormatException nfex) {
                V8Debug.printERR("ERR_NotANumber", lineStr.substring(0, end).trim());
                return;
            }
            column = null;
        } else {
            try {
                line = Long.parseLong(lineStr.substring(0, sep).trim());
            }
            catch (NumberFormatException nfex) {
                V8Debug.printERR("ERR_NotANumber", lineStr.substring(0, sep).trim());
                return;
            }
            while (++sep < lineStr.length() && Character.isWhitespace(lineStr.charAt(sep))) {
            }
            end = lineStr.indexOf(32, sep);
            if (end < 0) {
                end = lineStr.length();
            }
            try {
                column = Long.parseLong(lineStr.substring(sep, end).trim());
            }
            catch (NumberFormatException nfex) {
                V8Debug.printERR("ERR_NotANumber", lineStr.substring(sep, end).trim());
                return;
            }
        }
        while (++end < lineStr.length() && Character.isWhitespace(lineStr.charAt(end))) {
        }
        if (end < lineStr.length()) {
            lineStr = lineStr.substring(end);
            int ci = lineStr.indexOf("if=");
            String condition = null;
            if (ci >= 0) {
                condition = lineStr.substring(ci += 3).trim();
            }
            this.cc.send(SetBreakpoint.createRequest(this.requestSequence++, V8Breakpoint.Type.scriptName, scriptName, line - 1L, column, true, condition, null, null));
        } else {
            this.cc.send(SetBreakpoint.createRequest(this.requestSequence++, V8Breakpoint.Type.scriptName, scriptName, line - 1L, column));
        }
    }

    private void changeBreakpoint(long bpNumber, String how) throws IOException {
        Boolean enabled = null;
        Long ic = null;
        String condition = null;
        if (how.startsWith("enable")) {
            enabled = true;
            how = how.substring("enable".length()).trim();
        }
        if (how.startsWith("disable")) {
            enabled = false;
            how = how.substring("disable".length()).trim();
        }
        if (how.startsWith("ignoreCount=")) {
            char c;
            how = how.substring("ignoreCount=".length());
            int i = 0;
            while (i < how.length() && Character.isDigit(c = how.charAt(i))) {
            }
            try {
                ic = Long.parseLong(how.substring(0, i));
            }
            catch (NumberFormatException nfex) {
                V8Debug.printERR("ERR_NotANumber", how.substring(0, i));
            }
            how = how.substring(i).trim();
        }
        if (how.startsWith("if=")) {
            condition = how.substring(3).trim();
        }
        this.cc.send(ChangeBreakpoint.createRequest(this.requestSequence++, bpNumber, enabled, condition, ic));
    }

    private void deleteBreakpoints(String args) throws NumberFormatException, IOException {
        Scanner scanner = new Scanner(args);
        scanner.useDelimiter("[,\\p{javaWhitespace}]+");
        while (scanner.hasNext()) {
            String brkp = scanner.next();
            int dash = brkp.indexOf(45);
            if (dash > 0) {
                String brkp1 = brkp.substring(0, dash).trim();
                String brkp2 = brkp.substring(dash + 1).trim();
                long b1 = Long.parseLong(brkp1);
                long b2 = Long.parseLong(brkp2);
                for (long b = b1; b <= b2; ++b) {
                    this.deleteBreakpoint(b);
                }
                continue;
            }
            long b = Long.parseLong(brkp);
            this.deleteBreakpoint(b);
        }
    }

    private void deleteBreakpoint(long b) throws IOException {
        this.cc.send(ClearBreakpoint.createRequest(this.requestSequence++, b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleResponse(V8Response response) throws IOException {
        if (this.testeable != null) {
            this.testeable.notifyResponse(response);
        }
        V8Command internalCommand = this.internalCommands.remove(response.getRequestSequence());
        String errorMessage = response.getErrorMessage();
        if (errorMessage != null) {
            System.err.println(errorMessage);
            this.toEvaluate = null;
            return true;
        }
        V8Body body = response.getBody();
        switch (response.getCommand()) {
            case Scripts: {
                Scripts.ResponseBody srb = (Scripts.ResponseBody)body;
                V8Script[] scripts = srb.getScripts();
                Map<Long, V8Script> map = this.scriptsById;
                synchronized (map) {
                    for (V8Script script : scripts) {
                        this.scriptsById.put(script.getId(), script);
                    }
                }
                if (internalCommand != V8Command.Scripts) {
                    this.print(scripts);
                    return true;
                }
                return false;
            }
            case Source: {
                Source.ResponseBody srcrb = (Source.ResponseBody)body;
                V8Debug.printMSG("MSG_SourceLines", srcrb.getFromLine(), srcrb.getToLine(), srcrb.getTotalLines());
                V8Debug.printMSG("MSG_SourcePositions", srcrb.getFromPosition(), srcrb.getToPosition());
                System.out.println(srcrb.getSource());
                return true;
            }
            case Continue: {
                V8Debug.printMSG("MSG_Continue", new Object[0]);
                return true;
            }
            case Setbreakpoint: {
                SetBreakpoint.ResponseBody sbb = (SetBreakpoint.ResponseBody)body;
                V8Breakpoint.ActualLocation[] locations = sbb.getActualLocations();
                if (locations.length == 0) {
                    V8Debug.printMSG("MSG_BreakAdded", sbb.getBreakpoint());
                } else {
                    String locationsStr = this.printStr(locations);
                    V8Debug.printMSG("MSG_BreakAddedLocations", sbb.getBreakpoint(), locationsStr);
                }
                return true;
            }
            case Clearbreakpoint: {
                ClearBreakpoint.ResponseBody cbb = (ClearBreakpoint.ResponseBody)body;
                V8Debug.printMSG("MSG_BreakDeleted", cbb.getBreakpoint());
                return true;
            }
            case Listbreakpoints: {
                ListBreakpoints.ResponseBody lbb = (ListBreakpoints.ResponseBody)body;
                V8Debug.printMSG("MSG_Breakpoints", new Object[0]);
                for (V8Breakpoint b : lbb.getBreakpoints()) {
                    System.out.print("  ");
                    this.print(b);
                    System.out.println("");
                }
                V8Debug.printMSG("MSG_BreakOnAllExc", lbb.isBreakOnExceptions());
                V8Debug.printMSG("MSG_BreakOnUncaughtExc", lbb.isBreakOnUncaughtExceptions());
                return true;
            }
            case Backtrace: {
                HashMap values;
                Backtrace.ResponseBody bb = (Backtrace.ResponseBody)body;
                if (this.numFrames < 0L) {
                    this.numFrames = bb.getTotalFrames();
                    this.cc.send(Backtrace.createRequest(this.requestSequence++, 0L, this.numFrames, false, true));
                    return false;
                }
                this.numFrames = -1L;
                V8Frame[] frames = bb.getFrames();
                ReferencedValue[] referencedValues = response.getReferencedValues();
                if (referencedValues.length > 0) {
                    values = new HashMap();
                    for (ReferencedValue rv : referencedValues) {
                        if (!rv.hasValue()) continue;
                        values.put(rv.getReference(), rv.getValue());
                    }
                } else {
                    values = null;
                }
                for (V8Frame f : frames) {
                    long scriptRef;
                    V8Value scriptValue;
                    V8Script script = null;
                    if (values != null && (scriptValue = (V8Value)values.get(scriptRef = f.getScriptRef())) instanceof V8ScriptValue) {
                        script = ((V8ScriptValue)scriptValue).getScript();
                    }
                    this.print(f, script);
                    System.out.println("");
                }
                return true;
            }
            case Lookup: {
                Lookup.ResponseBody lrb = (Lookup.ResponseBody)body;
                Map<Long, V8Value> values = lrb.getValuesByHandle();
                for (Map.Entry<Long, V8Value> ve : values.entrySet()) {
                    System.out.print(ve.getKey() + ": ");
                    this.print(ve.getValue());
                }
                return true;
            }
            case Evaluate: {
                Evaluate.ResponseBody erb = (Evaluate.ResponseBody)body;
                this.print(erb.getValue());
                return true;
            }
            case References: {
                References.ResponseBody rrb = (References.ResponseBody)body;
                V8Value[] refs = rrb.getReferences();
                if (refs.length == 0) {
                    V8Debug.printMSG("MSG_NoReferences", new Object[0]);
                } else {
                    V8Debug.printMSG("MSG_References", refs.length);
                    for (V8Value r : refs) {
                        this.print(r);
                    }
                }
                return true;
            }
            case Frame: {
                Frame.ResponseBody frb = (Frame.ResponseBody)body;
                V8Frame frame = frb.getFrame();
                long sid = frame.getScriptRef();
                V8Script script = this.getScript(sid);
                String scriptName = script != null ? script.getName() : "(id=" + sid + ")";
                System.out.println(scriptName + ":" + frame.getLine() + ":" + frame.getColumn());
                V8Debug.printMSG("MSG_SourceLine", frame.getSourceLineText());
                V8Debug.printMSG("MSG_Arguments", new Object[0]);
                this.printValues(frame.getArgumentRefs());
                V8Debug.printMSG("MSG_LocalVariables", new Object[0]);
                this.printValues(frame.getLocalRefs());
                return true;
            }
            case Gc: {
                GC.ResponseBody gcrb = (GC.ResponseBody)body;
                V8Debug.printMSG("MSG_GC", gcrb.getBefore(), gcrb.getAfter());
                return true;
            }
            case Threads: {
                Threads.ResponseBody trb = (Threads.ResponseBody)body;
                V8Debug.printMSG("MSG_Threads", trb.getNumThreads());
                Map<Long, Boolean> tids = trb.getIds();
                for (Map.Entry<Long, Boolean> tid : tids.entrySet()) {
                    V8Debug.printMSG("MSG_Thread", tid.getKey(), tid.getValue());
                }
                return true;
            }
            case Version: {
                V8Debug.printMSG("MSG_Version", ((Version.ResponseBody)body).getVersion());
                return true;
            }
            case Disconnect: {
                closing = true;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleEvent(V8Event event) {
        if (this.testeable != null) {
            this.testeable.notifyEvent(event);
        }
        switch (event.getKind()) {
            case AfterCompile: {
                AfterCompileEventBody aceb = (AfterCompileEventBody)event.getBody();
                V8Script script = aceb.getScript();
                Map<Long, V8Script> map = this.scriptsById;
                synchronized (map) {
                    this.scriptsById.put(script.getId(), script);
                }
                return false;
            }
            case CompileError: {
                CompileErrorEventBody ceeb = (CompileErrorEventBody)event.getBody();
                V8Script script = ceeb.getScript();
                Map<Long, V8Script> map = this.scriptsById;
                synchronized (map) {
                    this.scriptsById.put(script.getId(), script);
                }
                return false;
            }
            case Break: {
                System.out.println("");
                BreakEventBody beb = (BreakEventBody)event.getBody();
                System.out.println("stopped at " + beb.getScript().getName() + ", line = " + (beb.getSourceLine() + 1L) + " : " + beb.getSourceColumn() + "\ntext = " + beb.getSourceLineText());
                return true;
            }
            case Exception: {
                System.out.println("");
                ExceptionEventBody eeb = (ExceptionEventBody)event.getBody();
                System.out.println("exception '" + eeb.getException() + "' stopped in " + eeb.getScript().getName() + ", line = " + (eeb.getSourceLine() + 1L) + " : " + eeb.getSourceColumn() + "\ntext = " + eeb.getSourceLineText());
                return true;
            }
        }
        throw new IllegalStateException("Unknown event: " + (Object)((Object)event.getKind()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V8Script getScript(long id) {
        Map<Long, V8Script> map = this.scriptsById;
        synchronized (map) {
            return this.scriptsById.get(id);
        }
    }

    private void print(V8Breakpoint b) {
        System.out.print(b.getNumber() + ".: ");
        String scriptName = b.getScriptName();
        if (scriptName == null && b.getScriptId().hasValue()) {
            V8Script script = this.getScript(b.getScriptId().getValue());
            scriptName = script != null ? script.getName() : "(script id=" + b.getScriptId().getValue() + ")";
        }
        System.out.print(scriptName);
        if (b.getLine().hasValue()) {
            System.out.print(":" + (b.getLine().getValue() + 1L));
        }
        if (b.getColumn().hasValue()) {
            System.out.print(":" + b.getColumn().getValue());
        }
        System.out.print(" active=" + b.isActive());
    }

    private void print(V8Frame f, V8Script script) {
        String scriptName = script == null ? "(ref=" + f.getScriptRef() + ")" : script.getName();
        long line = f.getLine() + 1L;
        long column = f.getColumn();
        System.out.print(scriptName + ":" + line + ":" + column);
    }

    private void print(V8Script[] scripts) {
        if (scripts.length == 0) {
            V8Debug.printMSG("MSG_NoLoadedScripts", new Object[0]);
            return;
        }
        V8Debug.printMSG("MSG_LoadedScripts", new Object[0]);
        V8Script[] sortedScripts = new V8Script[scripts.length];
        System.arraycopy(scripts, 0, sortedScripts, 0, scripts.length);
        Arrays.sort(sortedScripts, new Comparator<V8Script>(){

            @Override
            public int compare(V8Script s1, V8Script s2) {
                long d = s1.getId() - s2.getId();
                return d == 0L ? 0 : (d > 0L ? 1 : -1);
            }
        });
        scripts = sortedScripts;
        long maxId = scripts[scripts.length - 1].getId();
        int numDigits = Long.toString(maxId).length();
        for (V8Script script : scripts) {
            StringBuilder out = new StringBuilder("#");
            String idStr = Long.toString(script.getId());
            for (int i = idStr.length(); i < numDigits; ++i) {
                out.append('0');
            }
            out.append(idStr);
            out.append(": ");
            out.append(script.getName());
            System.out.println(out);
        }
    }

    private String printStr(V8Breakpoint.ActualLocation[] locations) {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (V8Breakpoint.ActualLocation l : locations) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String scriptName = l.getScriptName();
            if (scriptName != null) {
                sb.append(scriptName);
            } else {
                V8Script script = this.getScript(l.getScriptId().getValue());
                if (script != null) {
                    sb.append(script.getName());
                } else {
                    sb.append("(script id=" + l.getScriptId() + ")");
                }
            }
            sb.append(":");
            sb.append(l.getLine() + 1L);
            long c = l.getColumn();
            if (c < 0L) continue;
            sb.append(":");
            sb.append(c);
        }
        sb.append("]");
        return sb.toString();
    }

    private void print(V8Value value) {
        System.out.print("  ");
        if (this.toEvaluate != null) {
            System.out.print(this.toEvaluate + " = ");
            this.toEvaluate = null;
        }
        System.out.println(this.printStr(value));
    }

    private String printStr(ReferencedValue refAndVal) {
        if (refAndVal.hasValue()) {
            Object value = refAndVal.getValue();
            return this.printStr((V8Value)value);
        }
        return "reference: " + refAndVal.getReference();
    }

    private String printStr(V8Value value) {
        switch (value.getType()) {
            case Boolean: {
                return Boolean.toString(((V8Boolean)value).getValue());
            }
            case Function: {
                String name = ((V8Function)value).getName();
                if (name == null || name.isEmpty()) {
                    name = ((V8Function)value).getInferredName();
                }
                return name + "()";
            }
            case Null: {
                return String.valueOf(null);
            }
            case Number: {
                V8Number n = (V8Number)value;
                switch (n.getKind()) {
                    case Double: {
                        return Double.toString(n.getDoubleValue());
                    }
                    case Long: {
                        return Long.toString(n.getLongValue());
                    }
                }
                throw new IllegalStateException("Unknown kind: " + (Object)((Object)n.getKind()));
            }
            case Object: {
                V8Object o = (V8Object)value;
                StringBuilder sb = new StringBuilder("(");
                sb.append(o.getClassName());
                sb.append(')');
                if (o.getText() != null) {
                    sb.append(' ');
                    sb.append(o.getText());
                }
                if (o.getProperties() != null) {
                    Map<String, V8Object.Property> properties = o.getProperties();
                    String newLine = System.getProperty("line.separator");
                    properties.forEach((propName, v8Prop) -> {
                        sb.append(newLine);
                        sb.append("  ");
                        sb.append((String)propName);
                        sb.append(" = ");
                        sb.append('(');
                        sb.append((Object)v8Prop.getType());
                        sb.append(") ref: ");
                        sb.append(v8Prop.getReference());
                    });
                }
                return sb.toString();
            }
            case String: {
                return "\"" + ((V8String)value).getValue() + "\"";
            }
            case Undefined: {
                return "undefined";
            }
        }
        if (value.getText() != null) {
            return value.getText();
        }
        throw new IllegalStateException("Unknown value type: " + (Object)((Object)value.getType()));
    }

    private void printValues(Map<String, ReferencedValue> argumentRefs) {
        for (Map.Entry<String, ReferencedValue> entry : argumentRefs.entrySet()) {
            System.out.println(entry.getKey() + " = " + this.printStr(entry.getValue()));
        }
    }

    static interface Testeable
    extends IOListener {
        public void notifyResponse(V8Response var1);

        public void notifyEvent(V8Event var1);

        public void notifyClosed();
    }

    static final class TestAccess {
        TestAccess() {
        }

        static V8Debug createV8Debug(String hostName, int port, Testeable testeable) throws IOException {
            final V8Debug v8dbg = new V8Debug(hostName, port);
            v8dbg.testeable = testeable;
            v8dbg.cc.addIOListener(testeable);
            v8dbg.startCommandLoop();
            Thread responseLoop = new Thread("Response loop"){

                @Override
                public void run() {
                    try {
                        v8dbg.responseLoop();
                    }
                    catch (IOException | ParseException ex) {
                        Logger.getLogger(V8Debug.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            responseLoop.setDaemon(true);
            responseLoop.start();
            return v8dbg;
        }

        static boolean doCommand(V8Debug v8dbg, String command) throws IOException {
            return v8dbg.doCommand(command);
        }

        static V8Script getScript(V8Debug v8dbg, long id) {
            return v8dbg.getScript(id);
        }

        static void send(V8Debug v8dbg, V8Request req) throws IOException {
            v8dbg.cc.send(req);
        }

        static boolean isClosed(V8Debug v8dbg) {
            return v8dbg.cc.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static V8Script getScriptByName(V8Debug v8dbg, String name) {
            Map map = v8dbg.scriptsById;
            synchronized (map) {
                for (V8Script s : v8dbg.scriptsById.values()) {
                    if (!name.equals(s.getName())) continue;
                    return s;
                }
            }
            return null;
        }
    }
}

