/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.netbeans.modules.cloud.oracle.assets.k8s.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.assets.k8s.PodItem;

public class KubernetesLoaders {
    public static List<PodItem> loadPods(ClusterItem cluster, List<String> deploymentNames) {
        ArrayList<PodItem> result = new ArrayList<PodItem>();
        KubernetesUtils.runWithClient(cluster, client -> {
            for (String name : deploymentNames) {
                Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(cluster.getNamespace())).withName(name)).get();
                if (deployment == null) continue;
                Map labelSelector = deployment.getSpec().getSelector().getMatchLabels();
                PodList podList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(cluster.getNamespace())).withLabels(labelSelector)).list();
                for (Pod pod : podList.getItems()) {
                    result.add(new PodItem(cluster, pod.getMetadata().getNamespace(), pod.getMetadata().getName()));
                }
            }
        });
        return result;
    }
}

