/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.KeyStep;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.SensitiveData;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItemClient;
import org.openide.util.Lookup;

public class AddSecretsToVault
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(AddSecretsToVault.class.getName());
    private final VaultItem context;

    public AddSecretsToVault(VaultItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Steps.getDefault().executeMultistep(new KeyStep(this.context), Lookup.EMPTY).thenAccept(vals -> {
            KeyItem key = (KeyItem)vals.getValueForStep(KeyStep.class);
            ProgressHandle h = ProgressHandle.createHandle((String)Bundle.UpdatingVault(this.context.getName()));
            h.start();
            h.progress(Bundle.ReadingSecrets());
            try {
                VaultItemClient vclient = new VaultItemClient(this.context);
                Map<String, String> existingSecrets = this.getExistingSecrets(vclient).stream().collect(Collectors.toMap(s -> s.getSecretName(), s -> s.getId()));
                Map<String, String> cloudAssetsSecrets = this.getCloudAssetsSecrets();
                for (Map.Entry<String, String> entry : cloudAssetsSecrets.entrySet()) {
                    String secretName = entry.getKey();
                    if (existingSecrets.containsKey(secretName)) {
                        h.progress(Bundle.UpdatingSecret(secretName));
                        vclient.updateExistingSecret(entry, existingSecrets.get(secretName));
                        continue;
                    }
                    h.progress(Bundle.CreatingSecret(secretName));
                    vclient.createNewSecret(entry, key);
                }
                NotificationUtils.showMessage(Bundle.SecretsCreated());
            }
            catch (Throwable ex) {
                h.finish();
                NotificationUtils.showWarningMessage(ex.getMessage());
            }
            finally {
                h.finish();
            }
        });
    }

    private List<SecretSummary> getExistingSecrets(VaultItemClient client) {
        ListSecretsRequest listSecretsRequest = ListSecretsRequest.builder().compartmentId(this.context.getCompartmentId()).vaultId(this.context.getKey().getValue()).limit(Integer.valueOf(88)).build();
        ListSecretsResponse secrets = client.listSecrets(listSecretsRequest);
        return secrets.getItems();
    }

    private Map<String, String> getCloudAssetsSecrets() {
        HashMap<String, String> secrets = new HashMap<String, String>();
        Collection<OCIItem> items = CloudAssets.getDefault().getItems();
        for (OCIItem item : items) {
            if (!(item instanceof SensitiveData)) continue;
            secrets.putAll(((SensitiveData)((Object)item)).getSecrets());
        }
        return secrets;
    }
}

