/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.checkout.RevertChanges;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class RevertChangesAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(RevertChangesAction.class.getName());
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/get_clean.png";

    public RevertChangesAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(final File repository, final File[] roots, VCSContext context) {
        final RevertChanges revert = new RevertChanges(roots);
        if (revert.show()) {
            GitProgressSupport supp = new GitProgressSupport(this){
                final /* synthetic */ RevertChangesAction this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    final HashSet notifiedFiles = new HashSet();
                    final File[] actionRoots = GitUtils.listFiles(roots, FileInformation.STATUS_LOCAL_CHANGES);
                    if (actionRoots.length == 0) {
                        return;
                    }
                    try {
                        GitUtils.runWithoutIndexing(new Callable<Void>(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public Void call() throws Exception {
                                GitClient client = this.this$1.getClient();
                                client.addNotificationListener((NotificationListener)new FileListener(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    public void notifyFile(File file, String relativePathToRoot) {
                                        notifiedFiles.add(file);
                                    }
                                });
                                client.addNotificationListener((NotificationListener)this.this$1.new GitProgressSupport.DefaultFileListener(actionRoots));
                                if (revert.isRevertAll()) {
                                    this.this$1.logRevert("revert all", actionRoots, repository);
                                    client.checkout(actionRoots, "HEAD", true, this.this$1.getProgressMonitor());
                                } else if (revert.isRevertIndex()) {
                                    this.this$1.logRevert("revert index", actionRoots, repository);
                                    client.reset(actionRoots, "HEAD", true, this.this$1.getProgressMonitor());
                                } else if (revert.isRevertWT()) {
                                    this.this$1.logRevert("revert wt", actionRoots, repository);
                                    client.checkout(actionRoots, null, true, this.this$1.getProgressMonitor());
                                }
                                if (revert.isRemove()) {
                                    this.this$1.logRevert("clean ", actionRoots, repository);
                                    client.clean(actionRoots, this.this$1.getProgressMonitor());
                                }
                                return null;
                            }
                        }, actionRoots);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    finally {
                        revert.storeSettings();
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), notifiedFiles));
                    }
                }

                private void logRevert(String msg, File[] roots2, File repository2) {
                    if (LOG.isLoggable(Level.FINE)) {
                        Object repopath = repository2.getAbsolutePath();
                        if (!((String)repopath).endsWith("/")) {
                            repopath = (String)repopath + "/";
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(msg);
                        sb.append(" [");
                        for (int i = 0; i < roots2.length; ++i) {
                            String path = roots2[i].getAbsolutePath();
                            if (path.startsWith((String)repopath)) {
                                path = path.substring(((String)repopath).length());
                            }
                            sb.append(path);
                            if (i >= roots2.length - 1) continue;
                            sb.append(",");
                        }
                        sb.append("]");
                        LOG.fine(sb.toString());
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(RevertChangesAction.class, (String)"LBL_CheckoutPaths.progressName"));
        }
    }

    public void revertFiles(File repository, final File[] files, final String revision, String progressName) {
        if (files.length == 0) {
            return;
        }
        new GitProgressSupport(this){
            final /* synthetic */ RevertChangesAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void perform() {
                final HashSet notifiedFiles = new HashSet();
                try {
                    GitUtils.runWithoutIndexing(new Callable<Void>(){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public Void call() throws Exception {
                            GitClient client = this.this$1.getClient();
                            client.addNotificationListener((NotificationListener)new FileListener(){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void notifyFile(File file, String relativePathToRoot) {
                                    notifiedFiles.add(file);
                                }
                            });
                            client.addNotificationListener((NotificationListener)this.this$1.new GitProgressSupport.DefaultFileListener(files));
                            client.checkout(files, revision, false, this.this$1.getProgressMonitor());
                            return null;
                        }
                    }, files);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), notifiedFiles));
                }
            }
        }.start(Git.getInstance().getRequestProcessor(repository), repository, progressName);
    }
}

