/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetApplicationVipRequest
extends BmcRequest<Void> {
    private String applicationVipId;
    private String opcRequestId;

    public String getApplicationVipId() {
        return this.applicationVipId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().applicationVipId(this.applicationVipId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",applicationVipId=").append(String.valueOf(this.applicationVipId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetApplicationVipRequest)) {
            return false;
        }
        GetApplicationVipRequest other = (GetApplicationVipRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.applicationVipId, other.applicationVipId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.applicationVipId == null ? 43 : this.applicationVipId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetApplicationVipRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String applicationVipId = null;
        private String opcRequestId = null;

        public Builder applicationVipId(String applicationVipId) {
            this.applicationVipId = applicationVipId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetApplicationVipRequest o) {
            this.applicationVipId(o.getApplicationVipId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetApplicationVipRequest build() {
            GetApplicationVipRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetApplicationVipRequest buildWithoutInvocationCallback() {
            GetApplicationVipRequest request = new GetApplicationVipRequest();
            request.applicationVipId = this.applicationVipId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

