/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.http.ConcurrentDateFormat;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.http.WebdavIfHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet
implements PeriodicEventListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    private static final int MAX_DEPTH = 3;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final String SUPPORTED_LOCKS = "\n  <D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>\n  <D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>\n";
    protected static final ConcurrentDateFormat creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
    protected static final String LOCK_SCHEME = "urn:uuid:";
    private final ConcurrentHashMap<String, LockInfo> resourceLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LockInfo> sharedLocks = new ConcurrentHashMap();
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;
    private boolean strictIfProcessing = true;
    private boolean serveSubpathOnly = false;
    private PropertyStore store = null;

    @Override
    public void init() throws ServletException {
        String propertyStore;
        super.init();
        String servletName = this.getServletConfig().getServletName();
        ServletRegistration servletRegistration = this.getServletConfig().getServletContext().getServletRegistration(servletName);
        Collection<String> servletMappings = servletRegistration.getMappings();
        for (String mapping : servletMappings) {
            if (mapping.endsWith("/*")) continue;
            this.log(sm.getString("webdavservlet.nonWildcardMapping", mapping));
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
        if (this.getServletConfig().getInitParameter("strictIfProcessing") != null) {
            this.strictIfProcessing = Boolean.parseBoolean(this.getServletConfig().getInitParameter("strictIfProcessing"));
        }
        if (this.getServletConfig().getInitParameter("serveSubpathOnly") != null) {
            this.serveSubpathOnly = Boolean.parseBoolean(this.getServletConfig().getInitParameter("serveSubpathOnly"));
        }
        if ((propertyStore = this.getServletConfig().getInitParameter("propertyStore")) != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(propertyStore);
                this.store = (PropertyStore)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Enumeration<String> parameterNames = this.getServletConfig().getInitParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String parameterName = parameterNames.nextElement();
                    if (!parameterName.startsWith("store.")) continue;
                    StringBuilder actualMethod = new StringBuilder();
                    String parameterValue = this.getServletConfig().getInitParameter(parameterName);
                    if (IntrospectionUtils.setProperty(this.store, parameterName = parameterName.substring("store.".length()), parameterValue, true, actualMethod)) continue;
                    this.log(sm.getString("webdavservlet.noStoreParameter", parameterName, parameterValue));
                }
            }
            catch (Exception e) {
                this.log(sm.getString("webdavservlet.storeError"), e);
            }
        }
        if (this.store == null) {
            this.log(sm.getString("webdavservlet.memorystore"));
            this.store = new MemoryPropertyStore();
        }
        this.store.init();
    }

    @Override
    public void destroy() {
        this.store.destroy();
    }

    @Override
    public void periodicEvent() {
        for (LockInfo currentLock : this.sharedLocks.values()) {
            if (!currentLock.hasExpired()) continue;
            this.sharedLocks.remove(currentLock.path);
        }
        for (LockInfo currentLock : this.resourceLocks.values()) {
            if (currentLock.isExclusive()) {
                if (!currentLock.hasExpired()) continue;
                this.resourceLocks.remove(currentLock.path);
                continue;
            }
            for (String token : currentLock.sharedTokens) {
                if (this.sharedLocks.get(token) != null) continue;
                currentLock.sharedTokens.remove(token);
            }
            if (!currentLock.sharedTokens.isEmpty()) continue;
            this.resourceLocks.remove(currentLock.path);
        }
        this.store.periodicEvent();
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException e) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        if (req.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(req, resp);
            return;
        }
        if (this.isSpecialPath(path)) {
            resp.sendError(404);
            return;
        }
        String method = req.getMethod();
        if (this.debug > 0) {
            this.log("[" + method + "] " + path);
        }
        if (method.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, WebResource resource) throws IOException {
        if (resource != null && !super.checkIfHeaders(request, response, resource)) {
            return false;
        }
        String ifHeaderValue = request.getHeader("If");
        if (ifHeaderValue != null) {
            WebdavIfHeader ifHeader = new WebdavIfHeader(this.getUriPrefix(request), ifHeaderValue);
            if (!ifHeader.hasValue()) {
                return !this.strictIfProcessing;
            }
            String path = this.getRelativePath(request);
            Iterator<String> hrefs = ifHeader.getResources();
            String currentPath = null;
            String currentHref = null;
            WebResource currentWebResource = null;
            if (hrefs.hasNext()) {
                currentHref = hrefs.next();
                currentPath = this.getPathFromHref(currentHref, request);
                if (currentPath == null) {
                    return false;
                }
                currentWebResource = this.resources.getResource(currentPath);
            } else {
                currentPath = path;
                currentHref = this.getEncodedPath(path, resource, request);
                currentWebResource = resource;
            }
            while (true) {
                boolean exists = currentWebResource != null && currentWebResource.exists();
                String eTag = exists ? this.generateETag(currentWebResource) : "";
                ArrayList<String> lockTokens = new ArrayList<String>();
                if (!this.strictIfProcessing || exists) {
                    String parentPath = currentPath;
                    while (true) {
                        int slash;
                        LockInfo parentLock;
                        if ((parentLock = this.resourceLocks.get(parentPath)) != null) {
                            if (parentLock.hasExpired()) {
                                this.resourceLocks.remove(parentPath);
                            } else if (parentPath != currentPath && parentLock.depth > 0 || parentPath == currentPath) {
                                if (parentLock.isExclusive()) {
                                    lockTokens.add(LOCK_SCHEME + parentLock.token);
                                } else {
                                    for (String token : parentLock.sharedTokens) {
                                        if (this.sharedLocks.get(token) != null) continue;
                                        parentLock.sharedTokens.remove(token);
                                    }
                                    if (parentLock.sharedTokens.isEmpty()) {
                                        this.resourceLocks.remove(parentLock.path);
                                    }
                                    for (String token : parentLock.sharedTokens) {
                                        LockInfo sharedLock = this.sharedLocks.get(token);
                                        if (sharedLock == null || (parentPath == currentPath || sharedLock.depth <= 0) && parentPath != currentPath) continue;
                                        lockTokens.add(LOCK_SCHEME + token);
                                    }
                                }
                            }
                        }
                        if ((slash = parentPath.lastIndexOf(47)) < 0) break;
                        parentPath = parentPath.substring(0, slash);
                    }
                }
                if (ifHeader.matches(currentHref, lockTokens, eTag)) {
                    return true;
                }
                if (!hrefs.hasNext()) break;
                currentHref = hrefs.next();
                currentPath = this.getPathFromHref(currentHref, request);
                currentWebResource = this.resources.getResource(currentPath);
            }
            return false;
        }
        return true;
    }

    @Override
    protected String getRelativePath(HttpServletRequest request, boolean allowEmptyPath) {
        if (this.serveSubpathOnly) {
            return super.getRelativePath(request, allowEmptyPath);
        }
        String pathInfo = request.getAttribute("javax.servlet.include.request_uri") != null ? (String)request.getAttribute("javax.servlet.include.path_info") : request.getPathInfo();
        StringBuilder result = new StringBuilder();
        if (pathInfo != null) {
            result.append(pathInfo);
        }
        if (result.length() == 0) {
            result.append('/');
        }
        String resultString = result.toString();
        if (!allowEmptyPath && resultString.length() > 1 && resultString.endsWith("/")) {
            resultString = resultString.substring(0, resultString.length() - 1);
        }
        return resultString;
    }

    @Override
    protected String getPathPrefix(HttpServletRequest request) {
        if (this.serveSubpathOnly) {
            return super.getPathPrefix(request);
        }
        String contextPath = request.getContextPath();
        if (request.getServletPath() != null) {
            contextPath = contextPath + request.getServletPath();
        }
        return contextPath;
    }

    @Override
    protected String determineMethodsAllowed(HttpServletRequest req) {
        WebResource resource = this.resources.getResource(this.getRelativePath(req));
        StringBuilder methodsAllowed = new StringBuilder("OPTIONS, GET, POST, HEAD");
        if (!this.isReadOnly()) {
            methodsAllowed.append(", DELETE");
            if (!resource.isDirectory()) {
                methodsAllowed.append(", PUT");
            }
        }
        if (req instanceof RequestFacade && ((RequestFacade)req).getAllowTrace()) {
            methodsAllowed.append(", TRACE");
        }
        methodsAllowed.append(", LOCK, UNLOCK, PROPPATCH, COPY, MOVE");
        if (this.isListings()) {
            methodsAllowed.append(", PROPFIND");
        }
        if (!resource.exists()) {
            methodsAllowed.append(", MKCOL");
        }
        return methodsAllowed.toString();
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1,2,3");
        resp.addHeader("Allow", this.determineMethodsAllowed(req));
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebResource resource;
        if (!this.isListings()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        String path = this.getRelativePath(req);
        ArrayList<Node> properties = new ArrayList<Node>();
        int depth = this.maxDepth;
        PropfindType type = null;
        String depthStr = req.getHeader("Depth");
        if (depthStr == null) {
            depth = this.maxDepth;
        } else if (depthStr.equals("0")) {
            depth = 0;
        } else if (depthStr.equals("1")) {
            depth = 1;
        } else if (depthStr.equals("infinity")) {
            depth = this.maxDepth;
        } else {
            resp.sendError(400);
            return;
        }
        byte[] body = null;
        try (ServletInputStream is = req.getInputStream();
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            IOTools.flow(is, os);
            body = os.toByteArray();
        }
        catch (IOException e) {
            resp.sendError(400);
            return;
        }
        if (body.length > 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(body)));
                Element rootElement = document.getDocumentElement();
                if (!"propfind".equals(WebdavServlet.getDAVNode(rootElement))) {
                    resp.sendError(400);
                    return;
                }
                NodeList childList = rootElement.getChildNodes();
                block22: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block22;
                        }
                        case 1: {
                            String nodeName = WebdavServlet.getDAVNode(currentNode);
                            if ("prop".equals(nodeName)) {
                                if (type != null) {
                                    resp.sendError(400);
                                    return;
                                }
                                type = PropfindType.FIND_BY_PROPERTY;
                                NodeList propChildList = currentNode.getChildNodes();
                                block23: for (int j = 0; j < propChildList.getLength(); ++j) {
                                    Node currentNode2 = propChildList.item(j);
                                    switch (currentNode2.getNodeType()) {
                                        case 3: {
                                            continue block23;
                                        }
                                        case 1: {
                                            properties.add(currentNode2);
                                        }
                                    }
                                }
                            }
                            if ("propname".equals(nodeName)) {
                                if (type != null) {
                                    resp.sendError(400);
                                    return;
                                }
                                type = PropfindType.FIND_PROPERTY_NAMES;
                            }
                            if (!"allprop".equals(nodeName)) continue block22;
                            if (type != null) {
                                resp.sendError(400);
                                return;
                            }
                            type = PropfindType.FIND_ALL_PROP;
                        }
                    }
                }
            }
            catch (IOException | SAXException e) {
                resp.sendError(400);
                return;
            }
            if (type == null) {
                resp.sendError(400);
                return;
            }
        } else {
            type = PropfindType.FIND_ALL_PROP;
        }
        if (!this.checkIfHeaders(req, resp, resource = this.resources.getResource(path))) {
            resp.setStatus(412);
            return;
        }
        if (!resource.exists()) {
            resp.sendError(404);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (depth == 0) {
            this.propfindResource(generatedXML, this.getEncodedPath(path, resource, req), path, type, properties, resource.isFile(), resource.getCreation(), resource.getLastModified(), resource.getContentLength(), this.getServletContext().getMimeType(resource.getName()), this.generateETag(resource));
        } else {
            ArrayDeque<String> stack = new ArrayDeque<String>();
            stack.addFirst(path);
            ArrayDeque<String> stackBelow = new ArrayDeque<String>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.remove();
                if (this.isSpecialPath(currentPath)) continue;
                resource = this.resources.getResource(currentPath);
                if (resource.exists()) {
                    this.propfindResource(generatedXML, this.getEncodedPath(currentPath, resource, req), currentPath, type, properties, resource.isFile(), resource.getCreation(), resource.getLastModified(), resource.getContentLength(), this.getServletContext().getMimeType(resource.getName()), this.generateETag(resource));
                }
                if (resource.isDirectory() && depth > 0) {
                    String[] entries;
                    for (String entry : entries = this.resources.list(currentPath)) {
                        String newPath = currentPath;
                        if (!newPath.endsWith("/")) {
                            newPath = newPath + "/";
                        }
                        newPath = newPath + entry;
                        stackBelow.addFirst(newPath);
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new ArrayDeque();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        if (!this.checkIfHeaders(req, resp, resource)) {
            resp.setStatus(412);
            return;
        }
        if (!resource.exists()) {
            resp.sendError(404);
            return;
        }
        if (this.isReadOnly()) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(path, req)) {
            resp.sendError(423);
            return;
        }
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        ArrayList<ProppatchOperation> operations = new ArrayList<ProppatchOperation>();
        byte[] body = null;
        try (ServletInputStream is = req.getInputStream();
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            IOTools.flow(is, os);
            body = os.toByteArray();
        }
        catch (IOException e) {
            resp.sendError(400);
            return;
        }
        if (body.length <= 0) {
            resp.sendError(400);
            return;
        }
        try {
            Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(body)));
            Element rootElement = document.getDocumentElement();
            if (!"propertyupdate".equals(WebdavServlet.getDAVNode(rootElement))) {
                resp.sendError(400);
                return;
            }
            NodeList childList = rootElement.getChildNodes();
            block34: for (int i = 0; i < childList.getLength(); ++i) {
                Node currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block34;
                    }
                    case 1: {
                        Node currentNode3;
                        int k;
                        Node property;
                        NodeList propChildList;
                        Node currentNode2;
                        int j;
                        String nodeName = WebdavServlet.getDAVNode(currentNode);
                        if ("set".equals(nodeName)) {
                            NodeList setChildList = currentNode.getChildNodes();
                            block35: for (j = 0; j < setChildList.getLength(); ++j) {
                                currentNode2 = setChildList.item(j);
                                switch (currentNode2.getNodeType()) {
                                    case 3: {
                                        continue block35;
                                    }
                                    case 1: {
                                        if (!"prop".equals(WebdavServlet.getDAVNode(currentNode2))) continue block35;
                                        propChildList = currentNode2.getChildNodes();
                                        property = null;
                                        block36: for (k = 0; k < propChildList.getLength(); ++k) {
                                            currentNode3 = propChildList.item(k);
                                            switch (currentNode3.getNodeType()) {
                                                case 3: {
                                                    continue block36;
                                                }
                                                case 1: {
                                                    property = currentNode3;
                                                }
                                            }
                                        }
                                        if (property != null) {
                                            operations.add(new ProppatchOperation(PropertyUpdateType.SET, property));
                                            continue block35;
                                        }
                                        resp.sendError(400);
                                        return;
                                    }
                                }
                            }
                        }
                        if (!"remove".equals(nodeName)) continue block34;
                        NodeList removeChildList = currentNode.getChildNodes();
                        block37: for (j = 0; j < removeChildList.getLength(); ++j) {
                            currentNode2 = removeChildList.item(j);
                            switch (currentNode2.getNodeType()) {
                                case 3: {
                                    continue block37;
                                }
                                case 1: {
                                    if (!"prop".equals(WebdavServlet.getDAVNode(currentNode2))) continue block37;
                                    propChildList = currentNode2.getChildNodes();
                                    property = null;
                                    block38: for (k = 0; k < propChildList.getLength(); ++k) {
                                        currentNode3 = propChildList.item(k);
                                        switch (currentNode3.getNodeType()) {
                                            case 3: {
                                                continue block38;
                                            }
                                            case 1: {
                                                property = currentNode3;
                                            }
                                        }
                                    }
                                    if (property != null) {
                                        operations.add(new ProppatchOperation(PropertyUpdateType.REMOVE, property));
                                        continue block37;
                                    }
                                    resp.sendError(400);
                                    return;
                                }
                            }
                        }
                        continue block34;
                    }
                }
            }
        }
        catch (IOException | SAXException e) {
            resp.sendError(400);
            return;
        }
        this.store.proppatch(path, operations);
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        generatedXML.writeElement("D", "response", 0);
        generatedXML.writeElement("D", "href", 0);
        generatedXML.writeText(this.getEncodedPath(path, resource, req));
        generatedXML.writeElement("D", "href", 1);
        for (ProppatchOperation operation : operations) {
            generatedXML.writeElement("D", "propstat", 0);
            generatedXML.writeElement("D", "prop", 0);
            generatedXML.writeElement(operation.propertyNode.getPrefix(), operation.propertyNode.getNamespaceURI(), operation.propertyNode.getLocalName(), 2);
            generatedXML.writeElement("D", "prop", 1);
            generatedXML.writeElement("D", "status", 0);
            generatedXML.writeText("HTTP/1.1 " + String.valueOf(operation.getStatusCode()) + " ");
            generatedXML.writeElement("D", "status", 1);
            if (operation.getProtectedProperty() && operation.getStatusCode() == 403) {
                generatedXML.writeElement("D", "error", 0);
                generatedXML.writeElement("D", "cannot-modify-protected-property", 2);
                generatedXML.writeElement("D", "error", 1);
            }
            generatedXML.writeElement("D", "propstat", 1);
        }
        generatedXML.writeElement("D", "response", 1);
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        if (!this.checkIfHeaders(req, resp, resource)) {
            resp.setStatus(412);
            return;
        }
        if (resource.exists()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        if (this.isReadOnly()) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(path, req)) {
            resp.sendError(423);
            return;
        }
        if (req.getContentLengthLong() > 0L || "chunked".equalsIgnoreCase(req.getHeader("Transfer-Encoding"))) {
            resp.sendError(415);
            return;
        }
        if (this.resources.mkdir(path)) {
            resp.setStatus(201);
        } else {
            resp.sendError(409);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isReadOnly()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        String path = this.getRelativePath(req);
        this.deleteResource(path, req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        if (!this.checkIfHeaders(req, resp, resource)) {
            resp.setStatus(412);
            return;
        }
        if (this.isLocked(path, req)) {
            resp.sendError(423);
            return;
        }
        if (resource.isDirectory()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        super.doPut(req, resp);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isReadOnly()) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        this.copyResource(path, req, resp);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isReadOnly()) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        if (this.isLocked(path, req)) {
            resp.sendError(423);
            return;
        }
        if (this.copyResource(path, req, resp)) {
            this.deleteResource(path, req, resp, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isReadOnly()) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        if (!this.checkIfHeaders(req, resp, resource)) {
            resp.setStatus(412);
            return;
        }
        LockInfo lock = new LockInfo(this.maxDepth);
        lock.principal = req.getRemoteUser();
        String depthStr = req.getHeader("Depth");
        if (depthStr == null) {
            lock.depth = this.maxDepth;
        } else if (depthStr.equals("0")) {
            lock.depth = 0;
        } else if (depthStr.equals("infinity")) {
            lock.depth = this.maxDepth;
        } else {
            resp.sendError(400);
            return;
        }
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr != null) {
            if (lockDurationStr.startsWith("Second-")) {
                try {
                    lockDuration = Integer.parseInt(lockDurationStr.substring("Second-".length()));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (lockDurationStr.equals("Infinite")) {
                lockDuration = 604800;
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockCreation = false;
        Node lockInfoNode = null;
        byte[] body = null;
        try (ServletInputStream is = req.getInputStream();
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            IOTools.flow(is, os);
            body = os.toByteArray();
        }
        catch (IOException e) {
            resp.sendError(400);
            return;
        }
        if (body.length > 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource(new ByteArrayInputStream(body)));
                Element rootElement = document.getDocumentElement();
                if (!"lockinfo".equals(WebdavServlet.getDAVNode(rootElement))) {
                    resp.sendError(400);
                    return;
                }
                lockInfoNode = rootElement;
                lockCreation = true;
            }
            catch (IOException | SAXException e) {
                resp.sendError(400);
                return;
            }
        }
        if (lockInfoNode != null) {
            void var16_35;
            void var15_26;
            Node currentNode;
            int i;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Object var15_25 = null;
            Object var16_34 = null;
            Node lockOwnerNode = null;
            block32: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block32;
                    }
                    case 1: {
                        if ("lockscope".equals(WebdavServlet.getDAVNode(currentNode))) {
                            Node node = currentNode;
                        }
                        if ("locktype".equals(WebdavServlet.getDAVNode(currentNode))) {
                            Node node = currentNode;
                        }
                        if (!"owner".equals(WebdavServlet.getDAVNode(currentNode))) continue block32;
                        lockOwnerNode = currentNode;
                    }
                }
            }
            if (var15_26 != null) {
                childList = var15_26.getChildNodes();
                block33: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block33;
                        }
                        case 1: {
                            lock.scope = WebdavServlet.getDAVNode(currentNode);
                        }
                    }
                }
                if (lock.scope == null) {
                    resp.sendError(400);
                    return;
                }
            } else {
                resp.sendError(400);
                return;
            }
            if (var16_35 != null) {
                childList = var16_35.getChildNodes();
                block34: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block34;
                        }
                        case 1: {
                            lock.type = WebdavServlet.getDAVNode(currentNode);
                        }
                    }
                }
                if (lock.type == null) {
                    resp.sendError(400);
                    return;
                }
            } else {
                resp.sendError(400);
                return;
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block35: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            continue block35;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter(strWriter);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                        }
                    }
                }
                if (lock.owner == null) {
                    resp.sendError(400);
                    return;
                }
            } else {
                lock.owner = "";
            }
        }
        lock.path = path;
        if (lockCreation) {
            String parentPath = path;
            while (true) {
                int slash;
                LockInfo parentLock;
                if ((parentLock = this.resourceLocks.get(parentPath)) != null) {
                    if (parentLock.hasExpired()) {
                        this.resourceLocks.remove(parentPath);
                    } else if (parentLock.isExclusive() || lock.isExclusive()) {
                        resp.setStatus(423);
                        return;
                    }
                }
                if ((slash = parentPath.lastIndexOf(47)) < 0) break;
                parentPath = parentPath.substring(0, slash);
            }
            lock.token = UUID.randomUUID().toString();
            if (resource.isDirectory() && lock.depth == this.maxDepth) {
                ArrayList<String> lockPaths = new ArrayList<String>();
                for (LockInfo lockInfo : this.resourceLocks.values()) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.isExclusive() && !lock.isExclusive() || !lockInfo.path.startsWith(lock.path + "/")) continue;
                    lockPaths.add(lockInfo.lockroot);
                }
                if (!lockPaths.isEmpty()) {
                    resp.setStatus(207);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    generatedXML.writeElement("D", "response", 0);
                    generatedXML.writeElement("D", "href", 0);
                    generatedXML.writeText(this.getEncodedPath(path, resource, req));
                    generatedXML.writeElement("D", "href", 1);
                    generatedXML.writeElement("D", "status", 0);
                    generatedXML.writeText("HTTP/1.1 424 ");
                    generatedXML.writeElement("D", "status", 1);
                    generatedXML.writeElement("D", "response", 1);
                    for (String string : lockPaths) {
                        generatedXML.writeElement("D", "response", 0);
                        generatedXML.writeElement("D", "href", 0);
                        generatedXML.writeText(string);
                        generatedXML.writeElement("D", "href", 1);
                        generatedXML.writeElement("D", "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 ");
                        generatedXML.writeElement("D", "status", 1);
                        generatedXML.writeElement("D", "response", 1);
                    }
                    generatedXML.writeElement("D", "multistatus", 1);
                    PrintWriter printWriter = resp.getWriter();
                    ((Writer)printWriter).write(generatedXML.toString());
                    ((Writer)printWriter).close();
                    return;
                }
            } else if (!resource.exists()) {
                if (!this.resources.write(path, new ByteArrayInputStream(new byte[0]), false)) {
                    resp.sendError(409);
                    return;
                }
                resp.setStatus(201);
            }
            lock.lockroot = this.getEncodedPath(lock.path, resource, req);
            if (lock.isExclusive()) {
                this.resourceLocks.put(path, lock);
            } else {
                LockInfo sharedLock = this.resourceLocks.get(path);
                if (sharedLock == null) {
                    sharedLock = new LockInfo(this.maxDepth);
                    sharedLock.scope = "shared";
                    sharedLock.path = path;
                    sharedLock.lockroot = lock.lockroot;
                    sharedLock.depth = this.maxDepth;
                    this.resourceLocks.put(path, sharedLock);
                }
                sharedLock.sharedTokens.add(lock.token);
                this.sharedLocks.put(lock.token, lock);
            }
            resp.addHeader("Lock-Token", "<urn:uuid:" + lock.token + ">");
        }
        if (!lockCreation) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                resp.sendError(400);
                return;
            }
            LockInfo toRenew = null;
            String parentPath = path;
            while (true) {
                int n;
                LockInfo lockInfo;
                if ((lockInfo = this.resourceLocks.get(parentPath)) != null) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(parentPath);
                    } else if (parentPath != path && lockInfo.depth > 0 || parentPath == path) {
                        if (lockInfo.isExclusive()) {
                            if (ifHeader.contains(":" + lockInfo.token + ">") && (lockInfo.principal == null || lockInfo.principal.equals(req.getRemoteUser()))) {
                                toRenew = lockInfo;
                                break;
                            }
                        } else {
                            for (String token : lockInfo.sharedTokens) {
                                LockInfo sharedLock;
                                if (!ifHeader.contains(":" + token + ">") || (sharedLock = this.sharedLocks.get(token)) == null || sharedLock.principal != null && !sharedLock.principal.equals(req.getRemoteUser()) || (parentPath == path || sharedLock.depth <= 0) && parentPath != path) continue;
                                toRenew = sharedLock;
                                break;
                            }
                        }
                    }
                }
                if ((n = parentPath.lastIndexOf(47)) < 0) break;
                parentPath = parentPath.substring(0, n);
            }
            if (toRenew != null) {
                if (!toRenew.hasExpired()) {
                    toRenew.expiresAt = lock.expiresAt;
                } else {
                    toRenew = null;
                }
            }
            lock = toRenew;
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        generatedXML.writeElement("D", "lockdiscovery", 0);
        if (lock != null) {
            lock.toXML(generatedXML);
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
        generatedXML.writeElement("D", "prop", 1);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isReadOnly()) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        if (!this.checkIfHeaders(req, resp, resource)) {
            resp.setStatus(412);
            return;
        }
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            resp.sendError(400);
            return;
        }
        boolean unlocked = false;
        String parentPath = path;
        while (true) {
            int slash;
            LockInfo parentLock;
            if ((parentLock = this.resourceLocks.get(parentPath)) != null) {
                if (parentLock.hasExpired()) {
                    this.resourceLocks.remove(parentPath);
                } else if (parentPath != path && parentLock.depth > 0 || parentPath == path) {
                    if (parentLock.isExclusive()) {
                        if (lockTokenHeader.contains(":" + parentLock.token + ">") && (parentLock.principal == null || parentLock.principal.equals(req.getRemoteUser()))) {
                            this.resourceLocks.remove(parentPath);
                            unlocked = true;
                            break;
                        }
                        unlocked = false;
                        break;
                    }
                    for (String token : parentLock.sharedTokens) {
                        if (!lockTokenHeader.contains(":" + token + ">")) continue;
                        LockInfo lock = this.sharedLocks.get(token);
                        if (lock == null) {
                            parentLock.sharedTokens.remove(token);
                            break;
                        }
                        if (lock.principal != null && !lock.principal.equals(req.getRemoteUser()) || (parentPath == path || lock.depth <= 0) && parentPath != path) break;
                        parentLock.sharedTokens.remove(token);
                        this.sharedLocks.remove(token);
                        unlocked = true;
                        break;
                    }
                    if (parentLock.sharedTokens.isEmpty()) {
                        this.resourceLocks.remove(parentPath);
                    }
                }
            }
            if ((slash = parentPath.lastIndexOf(47)) < 0) break;
            parentPath = parentPath.substring(0, slash);
        }
        if (unlocked) {
            resp.setStatus(204);
        } else {
            this.sendReport(req, resp, parentPath, 409, "lock-token-matches-request-uri");
        }
    }

    private boolean isSpecialPath(String path) {
        String upperCasePath;
        return !this.allowSpecialPaths && ((upperCasePath = path.toUpperCase(Locale.ENGLISH)).startsWith("/WEB-INF/") || upperCasePath.startsWith("/META-INF/") || upperCasePath.equals("/WEB-INF") || upperCasePath.equals("/META-INF"));
    }

    private String getEncodedPath(String path, WebResource resource, HttpServletRequest request) {
        String href = this.getPathPrefix(request);
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (resource != null && resource.isDirectory() && !href.endsWith("/")) {
            href = href + "/";
        }
        return this.rewriteUrl(href);
    }

    private String getUriPrefix(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName();
    }

    private String getPathFromHref(String href, HttpServletRequest req) {
        String reqContextPath;
        URI hrefUri;
        if (href == null || href.isEmpty()) {
            return null;
        }
        try {
            hrefUri = new URI(href);
        }
        catch (URISyntaxException e) {
            return null;
        }
        String hrefPath = hrefUri.getPath();
        if (!hrefPath.equals(RequestUtil.normalize(hrefPath))) {
            return null;
        }
        if (hrefUri.isAbsolute() && !req.getServerName().equals(hrefUri.getHost())) {
            return null;
        }
        if (hrefPath.length() > 1 && hrefPath.endsWith("/")) {
            hrefPath = hrefPath.substring(0, hrefPath.length() - 1);
        }
        if (!hrefPath.startsWith((reqContextPath = this.getPathPrefix(req)) + "/")) {
            return null;
        }
        hrefPath = hrefPath.substring(reqContextPath.length());
        if (this.debug > 0) {
            this.log(href + " Href path: " + hrefPath);
        }
        if (this.isSpecialPath(hrefPath)) {
            return null;
        }
        return hrefPath;
    }

    private boolean isLocked(String path, HttpServletRequest req) {
        String ifHeader;
        if (path == null) {
            path = this.getRelativePath(req);
        }
        if ((ifHeader = req.getHeader("If")) == null) {
            ifHeader = "";
        }
        return this.isLocked(path, req.getRemoteUser(), ifHeader);
    }

    private boolean isLocked(String path, String principal, String ifHeader) {
        boolean unmatchedSharedLock = false;
        String parentPath = path;
        while (true) {
            int slash;
            LockInfo parentLock;
            if ((parentLock = this.resourceLocks.get(parentPath)) != null) {
                if (parentLock.hasExpired()) {
                    this.resourceLocks.remove(parentPath);
                } else if (parentPath != path && parentLock.depth > 0 || parentPath == path) {
                    if (parentLock.isExclusive()) {
                        return !ifHeader.contains(":" + parentLock.token + ">") || parentLock.principal != null && !parentLock.principal.equals(principal);
                    }
                    for (String token : parentLock.sharedTokens) {
                        LockInfo lock = this.sharedLocks.get(token);
                        if (lock == null || (parentPath == path || lock.depth <= 0) && parentPath != path) continue;
                        if (ifHeader.contains(":" + token + ">") && (lock.principal == null || lock.principal.equals(principal))) {
                            return false;
                        }
                        unmatchedSharedLock = true;
                    }
                }
            }
            if ((slash = parentPath.lastIndexOf(47)) < 0) break;
            parentPath = parentPath.substring(0, slash);
        }
        return unmatchedSharedLock;
    }

    private boolean copyResource(String path, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean result;
        String reqContextPath;
        URI destinationUri;
        WebResource source = this.resources.getResource(path);
        if (!source.exists()) {
            resp.sendError(404);
            return false;
        }
        if (!this.checkIfHeaders(req, resp, source)) {
            resp.setStatus(412);
            return false;
        }
        String destinationHeader = req.getHeader("Destination");
        if (destinationHeader == null || destinationHeader.isEmpty()) {
            resp.sendError(400);
            return false;
        }
        try {
            destinationUri = new URI(destinationHeader);
        }
        catch (URISyntaxException e) {
            resp.sendError(400);
            return false;
        }
        String destinationPath = destinationUri.getPath();
        if (!destinationPath.equals(RequestUtil.normalize(destinationPath))) {
            resp.sendError(400);
            return false;
        }
        if (destinationUri.isAbsolute()) {
            if (!req.getScheme().equals(destinationUri.getScheme()) || !req.getServerName().equals(destinationUri.getHost())) {
                resp.sendError(403);
                return false;
            }
            if (!(req.getServerPort() == destinationUri.getPort() || destinationUri.getPort() == -1 && ("http".equals(req.getScheme()) && req.getServerPort() == 80 || "https".equals(req.getScheme()) && req.getServerPort() == 443))) {
                resp.sendError(403);
                return false;
            }
        }
        if (destinationPath.length() > 1 && destinationPath.endsWith("/")) {
            destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
        }
        String expectedTargetPath = reqContextPath = this.getPathPrefix(req);
        if (this.serveSubpathOnly && req.getServletPath() != null) {
            expectedTargetPath = expectedTargetPath + req.getServletPath();
        }
        if (!destinationPath.startsWith(expectedTargetPath + "/")) {
            resp.sendError(403);
            return false;
        }
        destinationPath = destinationPath.substring(reqContextPath.length());
        if (this.debug > 0) {
            this.log("Dest path: " + destinationPath);
        }
        if (this.isSpecialPath(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        if (destinationPath.equals(path)) {
            resp.sendError(403);
            return false;
        }
        if (destinationPath.startsWith(path) && destinationPath.charAt(path.length()) == '/' || path.startsWith(destinationPath) && path.charAt(destinationPath.length()) == '/') {
            resp.sendError(403);
            return false;
        }
        if (this.isLocked(destinationPath, req)) {
            resp.sendError(423);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        WebResource destination = this.resources.getResource(destinationPath);
        if (overwrite) {
            if (destination.exists()) {
                if (!this.deleteResource(destinationPath, req, resp, true)) {
                    return false;
                }
            } else {
                resp.setStatus(201);
            }
        } else if (destination.exists()) {
            resp.sendError(412);
            return false;
        }
        LinkedHashMap<String, Integer> errorList = new LinkedHashMap<String, Integer>();
        boolean infiniteCopy = true;
        String depthHeader = req.getHeader("Depth");
        if (depthHeader != null && !depthHeader.equals("infinity")) {
            if (depthHeader.equals("0")) {
                infiniteCopy = false;
            } else {
                resp.sendError(400);
                return false;
            }
        }
        if (!(result = this.copyResource(errorList, path, destinationPath, infiniteCopy)) || !errorList.isEmpty()) {
            if (errorList.size() == 1) {
                resp.sendError((Integer)errorList.values().iterator().next());
            } else {
                this.sendReport(req, resp, errorList);
            }
            return false;
        }
        if (destination.exists()) {
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(Map<String, Integer> errorList, String source, String dest, boolean infiniteCopy) {
        String parent;
        WebResource parentResource;
        int lastSlash;
        WebResource sourceResource;
        if (this.debug > 1) {
            this.log("Copy: " + source + " To: " + dest + " Infinite: " + infiniteCopy);
        }
        if ((sourceResource = this.resources.getResource(source)).isDirectory()) {
            String[] entries;
            if (!this.resources.mkdir(dest)) {
                WebResource destResource = this.resources.getResource(dest);
                if (!destResource.isDirectory()) {
                    errorList.put(dest, 409);
                    return false;
                }
            } else {
                this.store.copy(source, dest);
            }
            if (!infiniteCopy) return true;
            String[] stringArray = entries = this.resources.list(source);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String childDest = dest;
                if (!childDest.equals("/")) {
                    childDest = childDest + "/";
                }
                childDest = childDest + entry;
                String childSrc = source;
                if (!childSrc.equals("/")) {
                    childSrc = childSrc + "/";
                }
                childSrc = childSrc + entry;
                this.copyResource(errorList, childSrc, childDest, true);
                ++n2;
            }
            return true;
        }
        if (!sourceResource.isFile()) {
            errorList.put(source, 500);
            return false;
        }
        WebResource destResource = this.resources.getResource(dest);
        if (!(destResource.exists() || destResource.getWebappPath().endsWith("/") || (lastSlash = destResource.getWebappPath().lastIndexOf(47)) <= 0 || (parentResource = this.resources.getResource(parent = destResource.getWebappPath().substring(0, lastSlash))).isDirectory())) {
            errorList.put(source, 409);
            return false;
        }
        if (!destResource.exists() && dest.endsWith("/") && dest.length() > 1) {
            dest = dest.substring(0, dest.length() - 1);
        }
        try (InputStream is = sourceResource.getInputStream();){
            if (!this.resources.write(dest, is, false)) {
                errorList.put(source, 500);
                boolean bl = false;
                return bl;
            }
            this.store.copy(source, dest);
            return true;
        }
        catch (IOException e) {
            this.log(sm.getString("webdavservlet.inputstreamclosefail", source), e);
            return true;
        }
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WebResource resource = this.resources.getResource(path);
        if (!this.checkIfHeaders(req, resp, resource)) {
            resp.setStatus(412);
            return false;
        }
        return this.deleteResource(path, req, resp, true);
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp, boolean setStatus) throws IOException {
        if (this.isLocked(path, req)) {
            resp.sendError(423);
            return false;
        }
        WebResource resource = this.resources.getResource(path);
        if (!resource.exists()) {
            resp.sendError(404);
            return false;
        }
        if (!resource.isDirectory()) {
            if (!resource.delete()) {
                this.sendNotAllowed(req, resp);
                return false;
            }
            this.deletedResource(path);
        } else {
            LinkedHashMap<String, Integer> errorList = new LinkedHashMap<String, Integer>();
            this.deleteCollection(req, path, errorList);
            if (!resource.delete()) {
                if (this.resources.list(path).length == 0) {
                    errorList.put(path, 405);
                }
            } else {
                this.deletedResource(path);
            }
            if (!errorList.isEmpty()) {
                this.sendReport(req, resp, errorList);
                return false;
            }
        }
        if (setStatus) {
            resp.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest req, String path, Map<String, Integer> errorList) {
        String[] entries;
        if (this.debug > 1) {
            this.log("Delete collection: " + path);
        }
        if (this.isSpecialPath(path)) {
            errorList.put(path, 403);
            return;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        for (String entry : entries = this.resources.list(path)) {
            String childName = path;
            if (!childName.equals("/")) {
                childName = childName + "/";
            }
            if (this.isLocked(childName = childName + entry, req.getRemoteUser(), ifHeader)) {
                errorList.put(childName, 423);
                continue;
            }
            WebResource childResource = this.resources.getResource(childName);
            if (childResource.isDirectory()) {
                this.deleteCollection(req, childName, errorList);
            }
            if (!childResource.delete()) {
                if (childResource.isDirectory() && this.resources.list(childName).length != 0) continue;
                errorList.put(childName, 405);
                continue;
            }
            this.deletedResource(childName);
        }
    }

    private void deletedResource(String path) {
        LockInfo lock = this.resourceLocks.remove(path);
        if (lock != null && !lock.isExclusive()) {
            for (String token : lock.sharedTokens) {
                this.sharedLocks.remove(token);
            }
        }
        this.store.delete(path);
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Map<String, Integer> errorList) throws IOException {
        resp.setStatus(207);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        for (Map.Entry<String, Integer> errorEntry : errorList.entrySet()) {
            String errorPath = errorEntry.getKey();
            int errorCode = errorEntry.getValue();
            generatedXML.writeElement("D", "response", 0);
            generatedXML.writeElement("D", "href", 0);
            generatedXML.writeText(this.getEncodedPath(errorPath, null, req));
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " ");
            generatedXML.writeElement("D", "status", 1);
            generatedXML.writeElement("D", "response", 1);
        }
        generatedXML.writeElement("D", "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, String errorPath, int errorCode, String error) throws IOException {
        resp.setStatus(errorCode);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "error", 0);
        if (errorPath != null && errorPath.length() > 0) {
            generatedXML.writeElement("D", error, 0);
            generatedXML.writeElement("D", "href", 0);
            generatedXML.writeText(this.getEncodedPath(errorPath, null, req));
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", error, 1);
        } else {
            generatedXML.writeElement("D", error, 2);
        }
        generatedXML.writeElement("D", "error", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void propfindResource(XMLWriter generatedXML, String rewrittenUrl, String path, PropfindType propFindType, List<Node> properties, boolean isFile, long created, long lastModified, long contentLength, String contentType, String eTag) {
        generatedXML.writeElement("D", "response", 0);
        String status = "HTTP/1.1 200 ";
        generatedXML.writeElement("D", "href", 0);
        generatedXML.writeText(rewrittenUrl);
        generatedXML.writeElement("D", "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (propFindType) {
            case FIND_ALL_PROP: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", WebdavServlet.getISOCreationDate(created));
                generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                if (isFile) {
                    generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                    if (contentType != null) {
                        generatedXML.writeProperty("D", "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty("D", "getetag", eTag);
                    generatedXML.writeElement("D", "resourcetype", 2);
                } else {
                    generatedXML.writeElement("D", "resourcetype", 0);
                    generatedXML.writeElement("D", "collection", 2);
                    generatedXML.writeElement("D", "resourcetype", 1);
                }
                this.store.propfind(path, null, false, generatedXML);
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeRaw(SUPPORTED_LOCKS);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case FIND_PROPERTY_NAMES: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                if (isFile) {
                    generatedXML.writeElement("D", "getcontentlength", 2);
                    if (contentType != null) {
                        generatedXML.writeElement("D", "getcontenttype", 2);
                    }
                    generatedXML.writeElement("D", "getetag", 2);
                }
                generatedXML.writeElement("D", "getlastmodified", 2);
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "supportedlock", 2);
                this.store.propfind(path, null, true, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case FIND_BY_PROPERTY: {
                ArrayList<Node> propertiesNotFound = new ArrayList<Node>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                for (Node propertyNode : properties) {
                    boolean protectedProperty;
                    String property = WebdavServlet.getDAVNode(propertyNode);
                    boolean bl = protectedProperty = property != null && !property.equals("displayname") && !property.equals("getcontentlanguage");
                    if (property == null || !protectedProperty) {
                        if (this.store.propfind(path, propertyNode, false, generatedXML)) continue;
                        propertiesNotFound.add(propertyNode);
                        continue;
                    }
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", WebdavServlet.getISOCreationDate(created));
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                            continue;
                        }
                        propertiesNotFound.add(propertyNode);
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (isFile && contentType != null) {
                            generatedXML.writeProperty("D", "getcontenttype", contentType);
                            continue;
                        }
                        propertiesNotFound.add(propertyNode);
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getetag", eTag);
                            continue;
                        }
                        propertiesNotFound.add(propertyNode);
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (isFile) {
                            generatedXML.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "collection", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeRaw(SUPPORTED_LOCKS);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        this.generateLockDiscovery(path, generatedXML);
                        continue;
                    }
                    propertiesNotFound.add(propertyNode);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                if (propertiesNotFound.isEmpty()) break;
                status = "HTTP/1.1 404 ";
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                for (Node propertyNotFoundNode : propertiesNotFound) {
                    String propertyNotFound = WebdavServlet.getDAVNode(propertyNotFoundNode);
                    if (propertyNotFound != null) {
                        generatedXML.writeElement("D", propertyNotFound, 2);
                        continue;
                    }
                    generatedXML.writeElement(null, propertyNotFoundNode.getNamespaceURI(), propertyNotFoundNode.getLocalName(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private void generateLockDiscovery(String path, XMLWriter generatedXML) {
        generatedXML.writeElement("D", "lockdiscovery", 0);
        String parentPath = path;
        while (true) {
            int slash;
            LockInfo parentLock;
            if ((parentLock = this.resourceLocks.get(parentPath)) != null) {
                if (parentLock.hasExpired()) {
                    this.resourceLocks.remove(parentPath);
                } else if (parentPath != path && parentLock.depth > 0 || parentPath == path) {
                    if (parentLock.isExclusive()) {
                        parentLock.toXML(generatedXML);
                    } else {
                        for (String lockToken : parentLock.sharedTokens) {
                            LockInfo sharedLock = this.sharedLocks.get(lockToken);
                            if (sharedLock == null) continue;
                            if (sharedLock.hasExpired()) {
                                this.sharedLocks.remove(lockToken);
                                continue;
                            }
                            if ((parentPath == path || sharedLock.depth <= 0) && parentPath != path) continue;
                            sharedLock.toXML(generatedXML);
                        }
                    }
                }
            }
            if ((slash = parentPath.lastIndexOf(47)) < 0) break;
            parentPath = parentPath.substring(0, slash);
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
    }

    private static String getISOCreationDate(long creationDate) {
        return creationDateFormat.format(new Date(creationDate));
    }

    private static String getDAVNode(Node node) {
        if (DEFAULT_NAMESPACE.equals(node.getNamespaceURI())) {
            return node.getLocalName();
        }
        return null;
    }

    private static boolean propertyEquals(Node node1, Node node2) {
        return node1.getLocalName().equals(node2.getLocalName()) && (node1.getNamespaceURI() == null && node2.getNamespaceURI() == null || node1.getNamespaceURI() != null && node1.getNamespaceURI().equals(node2.getNamespaceURI()));
    }

    public static interface PropertyStore {
        public void init();

        public void destroy();

        public void periodicEvent();

        public void copy(String var1, String var2);

        public void delete(String var1);

        public boolean propfind(String var1, Node var2, boolean var3, XMLWriter var4);

        public void proppatch(String var1, ArrayList<ProppatchOperation> var2);
    }

    public static class MemoryPropertyStore
    implements PropertyStore {
        private final ConcurrentHashMap<String, ArrayList<Node>> deadProperties = new ConcurrentHashMap();

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void periodicEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(String source, String destination) {
            ArrayList<Node> properties = this.deadProperties.get(source);
            ArrayList<Node> propertiesDest = this.deadProperties.get(destination);
            if (properties != null) {
                if (propertiesDest == null) {
                    propertiesDest = new ArrayList();
                    this.deadProperties.put(destination, propertiesDest);
                }
                ArrayList<Node> arrayList = properties;
                synchronized (arrayList) {
                    ArrayList<Node> arrayList2 = propertiesDest;
                    synchronized (arrayList2) {
                        for (Node node : properties) {
                            node = node.cloneNode(true);
                            boolean found = false;
                            for (int i = 0; i < propertiesDest.size(); ++i) {
                                Node propertyNode = propertiesDest.get(i);
                                if (!WebdavServlet.propertyEquals(node, propertyNode)) continue;
                                found = true;
                                propertiesDest.set(i, node);
                                break;
                            }
                            if (found) continue;
                            propertiesDest.add(node);
                        }
                    }
                }
            }
        }

        @Override
        public void delete(String resource) {
            this.deadProperties.remove(resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean propfind(String resource, Node property, boolean nameOnly, XMLWriter generatedXML) {
            ArrayList<Node> properties = this.deadProperties.get(resource);
            if (properties != null) {
                ArrayList<Node> arrayList = properties;
                synchronized (arrayList) {
                    if (nameOnly) {
                        for (Node node : properties) {
                            generatedXML.writeElement(null, node.getNamespaceURI(), node.getLocalName(), 2);
                        }
                    } else if (property != null) {
                        Node foundNode = null;
                        for (Node node : properties) {
                            if (!WebdavServlet.propertyEquals(node, property)) continue;
                            foundNode = node;
                        }
                        if (foundNode != null) {
                            StringWriter strWriter = new StringWriter();
                            DOMWriter domWriter = new DOMWriter(strWriter);
                            domWriter.print(foundNode);
                            generatedXML.writeRaw(strWriter.toString());
                            return true;
                        }
                    } else {
                        StringWriter strWriter = new StringWriter();
                        DOMWriter domWriter = new DOMWriter(strWriter);
                        for (Node node : properties) {
                            domWriter.print(node);
                        }
                        generatedXML.writeRaw(strWriter.toString());
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void proppatch(String resource, ArrayList<ProppatchOperation> operations) {
            boolean protectedProperty = false;
            for (ProppatchOperation operation : operations) {
                if (!operation.getProtectedProperty()) continue;
                protectedProperty = true;
                operation.setStatusCode(403);
            }
            if (protectedProperty) {
                for (ProppatchOperation operation : operations) {
                    if (operation.getProtectedProperty()) continue;
                    operation.setStatusCode(424);
                }
            } else {
                ArrayList<Node> properties = this.deadProperties.get(resource);
                if (properties == null) {
                    properties = new ArrayList();
                    this.deadProperties.put(resource, properties);
                }
                ArrayList<Node> arrayList = properties;
                synchronized (arrayList) {
                    block5: for (ProppatchOperation operation : operations) {
                        Node node;
                        if (operation.getUpdateType() == PropertyUpdateType.SET) {
                            node = operation.getPropertyNode().cloneNode(true);
                            boolean found = false;
                            for (int i = 0; i < properties.size(); ++i) {
                                Node propertyNode = properties.get(i);
                                if (!WebdavServlet.propertyEquals(node, propertyNode)) continue;
                                found = true;
                                properties.set(i, node);
                                break;
                            }
                            if (!found) {
                                properties.add(node);
                            }
                        }
                        if (operation.getUpdateType() != PropertyUpdateType.REMOVE) continue;
                        node = operation.getPropertyNode();
                        for (int i = 0; i < properties.size(); ++i) {
                            Node propertyNode = properties.get(i);
                            if (!WebdavServlet.propertyEquals(node, propertyNode)) continue;
                            properties.remove(i);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String lockroot = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        String token = "";
        List<String> sharedTokens = new CopyOnWriteArrayList<String>();
        long expiresAt = 0L;
        String principal = null;

        LockInfo(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Type:");
            result.append(this.type);
            result.append("\nScope:");
            result.append(this.scope);
            result.append("\nDepth:");
            result.append(this.depth);
            result.append("\nOwner:");
            result.append(this.owner);
            result.append("\nExpiration:");
            result.append(FastHttpDateFormat.formatDate(this.expiresAt));
            result.append("\nToken:");
            result.append(this.token);
            result.append("\n");
            return result.toString();
        }

        public boolean hasExpired() {
            return this.sharedTokens.size() == 0 && System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter generatedXML) {
            generatedXML.writeElement("D", "activelock", 0);
            generatedXML.writeElement("D", "locktype", 0);
            generatedXML.writeElement("D", this.type, 2);
            generatedXML.writeElement("D", "locktype", 1);
            generatedXML.writeElement("D", "lockscope", 0);
            generatedXML.writeElement("D", this.scope, 2);
            generatedXML.writeElement("D", "lockscope", 1);
            generatedXML.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement("D", "depth", 1);
            generatedXML.writeElement("D", "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement("D", "owner", 1);
            generatedXML.writeElement("D", "timeout", 0);
            long timeout = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout);
            generatedXML.writeElement("D", "timeout", 1);
            generatedXML.writeElement("D", "lockroot", 0);
            generatedXML.writeElement("D", "href", 0);
            generatedXML.writeText(this.lockroot);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "lockroot", 1);
            generatedXML.writeElement("D", "locktoken", 0);
            generatedXML.writeElement("D", "href", 0);
            generatedXML.writeText(WebdavServlet.LOCK_SCHEME + this.token);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "locktoken", 1);
            generatedXML.writeElement("D", "activelock", 1);
        }
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        WebdavResolver(ServletContext theContext) {
            this.context = theContext;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.externalEntityIgnored", publicId, systemId));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    static enum PropfindType {
        FIND_BY_PROPERTY,
        FIND_ALL_PROP,
        FIND_PROPERTY_NAMES;

    }

    public static class ProppatchOperation {
        private final PropertyUpdateType updateType;
        private final Node propertyNode;
        private final boolean protectedProperty;
        private int statusCode = 200;

        public ProppatchOperation(PropertyUpdateType updateType, Node propertyNode) {
            this.updateType = updateType;
            this.propertyNode = propertyNode;
            String davName = WebdavServlet.getDAVNode(propertyNode);
            this.protectedProperty = davName != null && !davName.equals("displayname") && !davName.equals("getcontentlanguage");
        }

        public PropertyUpdateType getUpdateType() {
            return this.updateType;
        }

        public Node getPropertyNode() {
            return this.propertyNode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public boolean getProtectedProperty() {
            return this.protectedProperty;
        }
    }

    static enum PropertyUpdateType {
        SET,
        REMOVE;

    }
}

