/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListPrivateIpsRequest
extends BmcRequest<Void> {
    private Integer limit;
    private String page;
    private String ipAddress;
    private String subnetId;
    private String vnicId;
    private String vlanId;

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public Builder toBuilder() {
        return new Builder().limit(this.limit).page(this.page).ipAddress(this.ipAddress).subnetId(this.subnetId).vnicId(this.vnicId).vlanId(this.vlanId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(",subnetId=").append(String.valueOf(this.subnetId));
        sb.append(",vnicId=").append(String.valueOf(this.vnicId));
        sb.append(",vlanId=").append(String.valueOf(this.vlanId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPrivateIpsRequest)) {
            return false;
        }
        ListPrivateIpsRequest other = (ListPrivateIpsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.vnicId, other.vnicId) && Objects.equals(this.vlanId, other.vlanId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        result = result * 59 + (this.vlanId == null ? 43 : this.vlanId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPrivateIpsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Integer limit = null;
        private String page = null;
        private String ipAddress = null;
        private String subnetId = null;
        private String vnicId = null;
        private String vlanId = null;

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPrivateIpsRequest o) {
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.ipAddress(o.getIpAddress());
            this.subnetId(o.getSubnetId());
            this.vnicId(o.getVnicId());
            this.vlanId(o.getVlanId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPrivateIpsRequest build() {
            ListPrivateIpsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPrivateIpsRequest buildWithoutInvocationCallback() {
            ListPrivateIpsRequest request = new ListPrivateIpsRequest();
            request.limit = this.limit;
            request.page = this.page;
            request.ipAddress = this.ipAddress;
            request.subnetId = this.subnetId;
            request.vnicId = this.vnicId;
            request.vlanId = this.vlanId;
            return request;
        }
    }
}

