/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstanceConfigurationLaunchInstancePlatformConfig;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig
extends InstanceConfigurationLaunchInstancePlatformConfig {
    @JsonProperty(value="numaNodesPerSocket")
    private final NumaNodesPerSocket numaNodesPerSocket;
    @JsonProperty(value="isSymmetricMultiThreadingEnabled")
    private final Boolean isSymmetricMultiThreadingEnabled;
    @JsonProperty(value="isAccessControlServiceEnabled")
    private final Boolean isAccessControlServiceEnabled;
    @JsonProperty(value="areVirtualInstructionsEnabled")
    private final Boolean areVirtualInstructionsEnabled;
    @JsonProperty(value="isInputOutputMemoryManagementUnitEnabled")
    private final Boolean isInputOutputMemoryManagementUnitEnabled;
    @JsonProperty(value="percentageOfCoresEnabled")
    private final Integer percentageOfCoresEnabled;
    @JsonProperty(value="configMap")
    private final Map<String, String> configMap;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig(Boolean isSecureBootEnabled, Boolean isTrustedPlatformModuleEnabled, Boolean isMeasuredBootEnabled, Boolean isMemoryEncryptionEnabled, NumaNodesPerSocket numaNodesPerSocket, Boolean isSymmetricMultiThreadingEnabled, Boolean isAccessControlServiceEnabled, Boolean areVirtualInstructionsEnabled, Boolean isInputOutputMemoryManagementUnitEnabled, Integer percentageOfCoresEnabled, Map<String, String> configMap) {
        super(isSecureBootEnabled, isTrustedPlatformModuleEnabled, isMeasuredBootEnabled, isMemoryEncryptionEnabled);
        this.numaNodesPerSocket = numaNodesPerSocket;
        this.isSymmetricMultiThreadingEnabled = isSymmetricMultiThreadingEnabled;
        this.isAccessControlServiceEnabled = isAccessControlServiceEnabled;
        this.areVirtualInstructionsEnabled = areVirtualInstructionsEnabled;
        this.isInputOutputMemoryManagementUnitEnabled = isInputOutputMemoryManagementUnitEnabled;
        this.percentageOfCoresEnabled = percentageOfCoresEnabled;
        this.configMap = configMap;
    }

    public NumaNodesPerSocket getNumaNodesPerSocket() {
        return this.numaNodesPerSocket;
    }

    public Boolean getIsSymmetricMultiThreadingEnabled() {
        return this.isSymmetricMultiThreadingEnabled;
    }

    public Boolean getIsAccessControlServiceEnabled() {
        return this.isAccessControlServiceEnabled;
    }

    public Boolean getAreVirtualInstructionsEnabled() {
        return this.areVirtualInstructionsEnabled;
    }

    public Boolean getIsInputOutputMemoryManagementUnitEnabled() {
        return this.isInputOutputMemoryManagementUnitEnabled;
    }

    public Integer getPercentageOfCoresEnabled() {
        return this.percentageOfCoresEnabled;
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", numaNodesPerSocket=").append(String.valueOf((Object)this.numaNodesPerSocket));
        sb.append(", isSymmetricMultiThreadingEnabled=").append(String.valueOf(this.isSymmetricMultiThreadingEnabled));
        sb.append(", isAccessControlServiceEnabled=").append(String.valueOf(this.isAccessControlServiceEnabled));
        sb.append(", areVirtualInstructionsEnabled=").append(String.valueOf(this.areVirtualInstructionsEnabled));
        sb.append(", isInputOutputMemoryManagementUnitEnabled=").append(String.valueOf(this.isInputOutputMemoryManagementUnitEnabled));
        sb.append(", percentageOfCoresEnabled=").append(String.valueOf(this.percentageOfCoresEnabled));
        sb.append(", configMap=").append(String.valueOf(this.configMap));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig)) {
            return false;
        }
        InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig other = (InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig)((Object)o);
        return Objects.equals((Object)this.numaNodesPerSocket, (Object)other.numaNodesPerSocket) && Objects.equals(this.isSymmetricMultiThreadingEnabled, other.isSymmetricMultiThreadingEnabled) && Objects.equals(this.isAccessControlServiceEnabled, other.isAccessControlServiceEnabled) && Objects.equals(this.areVirtualInstructionsEnabled, other.areVirtualInstructionsEnabled) && Objects.equals(this.isInputOutputMemoryManagementUnitEnabled, other.isInputOutputMemoryManagementUnitEnabled) && Objects.equals(this.percentageOfCoresEnabled, other.percentageOfCoresEnabled) && Objects.equals(this.configMap, other.configMap) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.numaNodesPerSocket == null ? 43 : this.numaNodesPerSocket.hashCode());
        result = result * 59 + (this.isSymmetricMultiThreadingEnabled == null ? 43 : this.isSymmetricMultiThreadingEnabled.hashCode());
        result = result * 59 + (this.isAccessControlServiceEnabled == null ? 43 : this.isAccessControlServiceEnabled.hashCode());
        result = result * 59 + (this.areVirtualInstructionsEnabled == null ? 43 : this.areVirtualInstructionsEnabled.hashCode());
        result = result * 59 + (this.isInputOutputMemoryManagementUnitEnabled == null ? 43 : this.isInputOutputMemoryManagementUnitEnabled.hashCode());
        result = result * 59 + (this.percentageOfCoresEnabled == null ? 43 : this.percentageOfCoresEnabled.hashCode());
        result = result * 59 + (this.configMap == null ? 43 : this.configMap.hashCode());
        return result;
    }

    public static enum NumaNodesPerSocket implements BmcEnum
    {
        Nps0("NPS0"),
        Nps1("NPS1"),
        Nps2("NPS2"),
        Nps4("NPS4"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NumaNodesPerSocket> map;

        private NumaNodesPerSocket(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NumaNodesPerSocket create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NumaNodesPerSocket', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NumaNodesPerSocket.class);
            map = new HashMap<String, NumaNodesPerSocket>();
            for (NumaNodesPerSocket v : NumaNodesPerSocket.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isSecureBootEnabled")
        private Boolean isSecureBootEnabled;
        @JsonProperty(value="isTrustedPlatformModuleEnabled")
        private Boolean isTrustedPlatformModuleEnabled;
        @JsonProperty(value="isMeasuredBootEnabled")
        private Boolean isMeasuredBootEnabled;
        @JsonProperty(value="isMemoryEncryptionEnabled")
        private Boolean isMemoryEncryptionEnabled;
        @JsonProperty(value="numaNodesPerSocket")
        private NumaNodesPerSocket numaNodesPerSocket;
        @JsonProperty(value="isSymmetricMultiThreadingEnabled")
        private Boolean isSymmetricMultiThreadingEnabled;
        @JsonProperty(value="isAccessControlServiceEnabled")
        private Boolean isAccessControlServiceEnabled;
        @JsonProperty(value="areVirtualInstructionsEnabled")
        private Boolean areVirtualInstructionsEnabled;
        @JsonProperty(value="isInputOutputMemoryManagementUnitEnabled")
        private Boolean isInputOutputMemoryManagementUnitEnabled;
        @JsonProperty(value="percentageOfCoresEnabled")
        private Integer percentageOfCoresEnabled;
        @JsonProperty(value="configMap")
        private Map<String, String> configMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isSecureBootEnabled(Boolean isSecureBootEnabled) {
            this.isSecureBootEnabled = isSecureBootEnabled;
            this.__explicitlySet__.add("isSecureBootEnabled");
            return this;
        }

        public Builder isTrustedPlatformModuleEnabled(Boolean isTrustedPlatformModuleEnabled) {
            this.isTrustedPlatformModuleEnabled = isTrustedPlatformModuleEnabled;
            this.__explicitlySet__.add("isTrustedPlatformModuleEnabled");
            return this;
        }

        public Builder isMeasuredBootEnabled(Boolean isMeasuredBootEnabled) {
            this.isMeasuredBootEnabled = isMeasuredBootEnabled;
            this.__explicitlySet__.add("isMeasuredBootEnabled");
            return this;
        }

        public Builder isMemoryEncryptionEnabled(Boolean isMemoryEncryptionEnabled) {
            this.isMemoryEncryptionEnabled = isMemoryEncryptionEnabled;
            this.__explicitlySet__.add("isMemoryEncryptionEnabled");
            return this;
        }

        public Builder numaNodesPerSocket(NumaNodesPerSocket numaNodesPerSocket) {
            this.numaNodesPerSocket = numaNodesPerSocket;
            this.__explicitlySet__.add("numaNodesPerSocket");
            return this;
        }

        public Builder isSymmetricMultiThreadingEnabled(Boolean isSymmetricMultiThreadingEnabled) {
            this.isSymmetricMultiThreadingEnabled = isSymmetricMultiThreadingEnabled;
            this.__explicitlySet__.add("isSymmetricMultiThreadingEnabled");
            return this;
        }

        public Builder isAccessControlServiceEnabled(Boolean isAccessControlServiceEnabled) {
            this.isAccessControlServiceEnabled = isAccessControlServiceEnabled;
            this.__explicitlySet__.add("isAccessControlServiceEnabled");
            return this;
        }

        public Builder areVirtualInstructionsEnabled(Boolean areVirtualInstructionsEnabled) {
            this.areVirtualInstructionsEnabled = areVirtualInstructionsEnabled;
            this.__explicitlySet__.add("areVirtualInstructionsEnabled");
            return this;
        }

        public Builder isInputOutputMemoryManagementUnitEnabled(Boolean isInputOutputMemoryManagementUnitEnabled) {
            this.isInputOutputMemoryManagementUnitEnabled = isInputOutputMemoryManagementUnitEnabled;
            this.__explicitlySet__.add("isInputOutputMemoryManagementUnitEnabled");
            return this;
        }

        public Builder percentageOfCoresEnabled(Integer percentageOfCoresEnabled) {
            this.percentageOfCoresEnabled = percentageOfCoresEnabled;
            this.__explicitlySet__.add("percentageOfCoresEnabled");
            return this;
        }

        public Builder configMap(Map<String, String> configMap) {
            this.configMap = configMap;
            this.__explicitlySet__.add("configMap");
            return this;
        }

        public InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig build() {
            InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig model = new InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig(this.isSecureBootEnabled, this.isTrustedPlatformModuleEnabled, this.isMeasuredBootEnabled, this.isMemoryEncryptionEnabled, this.numaNodesPerSocket, this.isSymmetricMultiThreadingEnabled, this.isAccessControlServiceEnabled, this.areVirtualInstructionsEnabled, this.isInputOutputMemoryManagementUnitEnabled, this.percentageOfCoresEnabled, this.configMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceConfigurationAmdMilanBmLaunchInstancePlatformConfig model) {
            if (model.wasPropertyExplicitlySet("isSecureBootEnabled")) {
                this.isSecureBootEnabled(model.getIsSecureBootEnabled());
            }
            if (model.wasPropertyExplicitlySet("isTrustedPlatformModuleEnabled")) {
                this.isTrustedPlatformModuleEnabled(model.getIsTrustedPlatformModuleEnabled());
            }
            if (model.wasPropertyExplicitlySet("isMeasuredBootEnabled")) {
                this.isMeasuredBootEnabled(model.getIsMeasuredBootEnabled());
            }
            if (model.wasPropertyExplicitlySet("isMemoryEncryptionEnabled")) {
                this.isMemoryEncryptionEnabled(model.getIsMemoryEncryptionEnabled());
            }
            if (model.wasPropertyExplicitlySet("numaNodesPerSocket")) {
                this.numaNodesPerSocket(model.getNumaNodesPerSocket());
            }
            if (model.wasPropertyExplicitlySet("isSymmetricMultiThreadingEnabled")) {
                this.isSymmetricMultiThreadingEnabled(model.getIsSymmetricMultiThreadingEnabled());
            }
            if (model.wasPropertyExplicitlySet("isAccessControlServiceEnabled")) {
                this.isAccessControlServiceEnabled(model.getIsAccessControlServiceEnabled());
            }
            if (model.wasPropertyExplicitlySet("areVirtualInstructionsEnabled")) {
                this.areVirtualInstructionsEnabled(model.getAreVirtualInstructionsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isInputOutputMemoryManagementUnitEnabled")) {
                this.isInputOutputMemoryManagementUnitEnabled(model.getIsInputOutputMemoryManagementUnitEnabled());
            }
            if (model.wasPropertyExplicitlySet("percentageOfCoresEnabled")) {
                this.percentageOfCoresEnabled(model.getPercentageOfCoresEnabled());
            }
            if (model.wasPropertyExplicitlySet("configMap")) {
                this.configMap(model.getConfigMap());
            }
            return this;
        }
    }
}

