/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class HttpServerURLMapper
extends URLMapper {
    public FileObject[] getFileObjects(URL url) {
        String path = url.getPath();
        String wrapper = HttpServerURLMapper.httpserverSettings().getWrapperBaseURL();
        if (path == null || !path.startsWith(wrapper)) {
            return null;
        }
        if ((path = path.substring(wrapper.length())).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return new FileObject[0];
        }
        URL u = this.decodeURL(path);
        if (u == null) {
            return new FileObject[0];
        }
        return URLMapper.findFileObjects((URL)u);
    }

    private URL decodeURL(String path) {
        StringTokenizer slashTok = new StringTokenizer(path, "/", true);
        StringBuffer newPath = new StringBuffer();
        while (slashTok.hasMoreTokens()) {
            String tok = slashTok.nextToken();
            if (tok.startsWith("/")) {
                newPath.append(tok);
                continue;
            }
            try {
                String decodedToken = URLDecoder.decode(tok, "UTF-8");
                if (decodedToken.startsWith("/") && decodedToken.endsWith("/")) {
                    newPath.append(decodedToken, 1, decodedToken.length() - 1);
                    continue;
                }
                newPath.append(tok);
            }
            catch (UnsupportedEncodingException e) {
                assert (false) : e;
                return null;
            }
        }
        try {
            return new URL(newPath.toString());
        }
        catch (MalformedURLException ex) {
            Exceptions.attachMessage((Throwable)ex, (String)("using: " + newPath));
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public URL getURL(FileObject fileObject, int type) {
        if (type != 2) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        URL u = URLMapper.findURL((FileObject)fileObject, (int)1);
        if (u == null && (u = URLMapper.findURL((FileObject)fileObject, (int)0)) == null) {
            return null;
        }
        String path = this.encodeURL(u);
        HttpServerSettings settings = HttpServerURLMapper.httpserverSettings();
        settings.setRunning(true);
        try {
            URL newURL = new URL("http", HttpServerURLMapper.getLocalHost(), settings.getPort(), settings.getWrapperBaseURL() + path);
            return newURL;
        }
        catch (MalformedURLException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
            return null;
        }
    }

    private String encodeURL(URL u) {
        String orig = u.toExternalForm();
        StringTokenizer slashTok = new StringTokenizer(orig, "/", true);
        StringBuilder path = new StringBuilder();
        while (slashTok.hasMoreTokens()) {
            String tok = slashTok.nextToken();
            if (tok.startsWith("/")) {
                path.append(tok);
                continue;
            }
            try {
                if (!URLEncoder.encode(tok, "UTF-8").equals(tok)) {
                    path.append(URLEncoder.encode("/" + tok + "/", "UTF-8"));
                    continue;
                }
                path.append(tok);
            }
            catch (UnsupportedEncodingException e) {
                assert (false) : e;
                return null;
            }
        }
        return path.toString();
    }

    private static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    static HttpServerSettings httpserverSettings() {
        return HttpServerSettings.getDefault();
    }
}

