/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.ui.issue.FindBar;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class FindSupport {
    private static final String FIND_NEXT_ACTION = "find-next";
    private static final String FIND_PREVIOUS_ACTION = "find-previous";
    private TopComponent tc;
    private FindBar bar;
    private Highlighter.HighlightPainter highlighterAll;
    private Highlighter.HighlightPainter highlighterCurrent;
    private Pattern pattern;
    private JTextComponent currentComp;
    private int currentStart;
    private int currentEnd;

    private FindSupport(TopComponent tc) {
        this.tc = tc;
        this.bar = new FindBar(this);
        ActionMap actionMap = tc.getActionMap();
        CallbackSystemAction a = (CallbackSystemAction)SystemAction.get(org.openide.actions.FindAction.class);
        actionMap.put(a.getActionMapKey(), new FindAction(true));
        actionMap.put(FIND_NEXT_ACTION, new FindAction(true));
        actionMap.put(FIND_PREVIOUS_ACTION, new FindAction(false));
        JEditorPane pane = new JEditorPane();
        for (Action action : pane.getEditorKitForContentType("text/x-java").getActions()) {
            Object name = action.getValue("Name");
            if (!FIND_NEXT_ACTION.equals(name) && !FIND_PREVIOUS_ACTION.equals(name)) continue;
            this.reuseShortcut(action);
        }
        this.highlighterAll = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 180, 66));
        this.highlighterCurrent = new DefaultHighlighter.DefaultHighlightPainter(new Color(176, 197, 227));
        this.pattern = Pattern.compile("$^");
    }

    private void reuseShortcut(Action action) {
        Object key = action.getValue("AcceleratorKey");
        if (key instanceof KeyStroke) {
            InputMap inputMap = this.tc.getInputMap(1);
            inputMap.put((KeyStroke)key, action.getValue("Name"));
        }
    }

    public static FindSupport create(TopComponent tc) {
        return new FindSupport(tc);
    }

    public JComponent getFindBar() {
        return this.bar;
    }

    void reset() {
        this.highlight((Component)this.tc, true);
        this.currentComp = null;
    }

    void updatePattern() {
        this.reset();
        String p = this.bar.getPattern();
        if (!this.bar.getRegularExpression()) {
            p = Pattern.quote(p);
            if (this.bar.getWholeWords()) {
                p = "\\b" + p + "\\b";
            }
        }
        int flags = 8;
        if (!this.bar.getMatchCase()) {
            flags |= 2;
        }
        try {
            this.pattern = Pattern.compile(p, flags);
        }
        catch (PatternSyntaxException psex) {
            String message = NbBundle.getMessage(FindSupport.class, (String)"FindBar.invalidExpression");
            StatusDisplayer.getDefault().setStatusText(message, 800);
        }
        this.findNext();
        if (this.bar.getHighlightResults()) {
            this.highlight((Component)this.tc, false);
        }
    }

    void findNext() {
        boolean found = false;
        if (this.currentComp != null && this.currentComp.isVisible()) {
            this.highlight((Component)this.tc, true);
            found = this.findNext((Component)this.tc);
        }
        if (!found) {
            this.currentComp = null;
            this.findNext((Component)this.tc);
        }
        if (this.currentComp != null && this.currentComp.isVisible() && this.bar.getHighlightResults()) {
            this.highlight((Component)this.tc, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean findNext(Component comp) {
        if (comp == this.bar) {
            return false;
        }
        if (comp instanceof JTextPane) {
            int idx;
            if (this.currentComp != null && this.currentComp != comp) return false;
            if (!comp.isVisible()) {
                return false;
            }
            JTextPane tcomp = (JTextPane)comp;
            String txt = tcomp.getText();
            Matcher matcher = this.pattern.matcher(txt);
            int n = idx = this.currentComp == null ? 0 : this.currentEnd;
            if (matcher.find(idx)) {
                this.currentComp = tcomp;
                this.currentStart = matcher.start();
                this.currentEnd = matcher.end();
                if (this.currentStart == this.currentEnd) {
                    this.currentComp = null;
                    return false;
                }
                try {
                    Highlighter highlighter = tcomp.getHighlighter();
                    highlighter.addHighlight(this.currentStart, this.currentEnd, this.highlighterCurrent);
                    this.scrollToCurrent();
                    return true;
                }
                catch (BadLocationException blex) {
                    BugtrackingManager.LOG.log(Level.INFO, blex.getMessage(), blex);
                }
                return true;
            }
            this.currentComp = null;
            return false;
        }
        if (!(comp instanceof Container)) return false;
        Container cont = (Container)comp;
        for (Component subComp : cont.getComponents()) {
            if (!this.findNext(subComp)) continue;
            return true;
        }
        return false;
    }

    private void scrollToCurrent() {
        try {
            Rectangle r1 = this.currentComp.modelToView(this.currentStart);
            Rectangle r2 = this.currentComp.modelToView(this.currentStart);
            Rectangle r = r1.union(r2);
            this.currentComp.scrollRectToVisible(r);
        }
        catch (BadLocationException blex) {
            BugtrackingManager.LOG.log(Level.INFO, blex.getMessage(), blex);
        }
    }

    void findPrevious() {
        boolean found = false;
        if (this.currentComp != null) {
            this.highlight((Component)this.tc, true);
            found = this.findPrevious((Component)this.tc);
        }
        if (!found) {
            this.currentComp = null;
            this.findPrevious((Component)this.tc);
        }
        if (this.currentComp != null && this.bar.getHighlightResults()) {
            this.highlight((Component)this.tc, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean findPrevious(Component comp) {
        if (comp == this.bar) {
            return false;
        }
        if (comp instanceof JTextPane) {
            boolean found;
            if (this.currentComp != null && this.currentComp != comp) return false;
            JTextPane tcomp = (JTextPane)comp;
            String txt = tcomp.getText();
            Matcher matcher = this.pattern.matcher(txt);
            Highlighter highlighter = tcomp.getHighlighter();
            int lastStart = -1;
            int lastEnd = -1;
            while ((found = matcher.find(lastEnd == -1 ? 0 : lastEnd)) && (this.currentComp == null || matcher.end() <= this.currentStart) && (lastStart = matcher.start()) != (lastEnd = matcher.end())) {
            }
            if (lastEnd == -1 || lastStart == lastEnd) {
                this.currentComp = null;
                return false;
            }
            this.currentComp = tcomp;
            this.currentStart = lastStart;
            this.currentEnd = lastEnd;
            try {
                highlighter.addHighlight(this.currentStart, this.currentEnd, this.highlighterCurrent);
                this.scrollToCurrent();
                return true;
            }
            catch (BadLocationException blex) {
                BugtrackingManager.LOG.log(Level.INFO, blex.getMessage(), blex);
            }
            return true;
        }
        if (!(comp instanceof Container)) return false;
        Container cont = (Container)comp;
        Component[] comps = cont.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            if (!this.findPrevious(comps[i])) continue;
            return true;
        }
        return false;
    }

    void cancel() {
        if (this.currentComp != null) {
            this.currentComp.requestFocus();
        }
        this.reset();
        this.bar.setVisible(false);
    }

    void switchHighlight(boolean on) {
        if (!on) {
            this.highlight((Component)this.tc, true);
        }
        if (this.currentComp != null) {
            try {
                this.currentComp.getHighlighter().addHighlight(this.currentStart, this.currentEnd, this.highlighterCurrent);
            }
            catch (BadLocationException blex) {
                BugtrackingManager.LOG.log(Level.INFO, blex.getMessage(), blex);
            }
        }
        if (on) {
            this.highlight((Component)this.tc, false);
        }
    }

    private void highlight(Component comp, boolean cancel) {
        block9: {
            block8: {
                if (comp == this.bar) {
                    return;
                }
                if (!(comp instanceof JTextPane)) break block8;
                JTextPane tcomp = (JTextPane)comp;
                if (!tcomp.isVisible()) {
                    return;
                }
                String txt = tcomp.getText();
                Matcher matcher = this.pattern.matcher(txt);
                Highlighter highlighter = tcomp.getHighlighter();
                if (cancel) {
                    highlighter.removeAllHighlights();
                } else {
                    int end;
                    int start;
                    int idx = 0;
                    while (matcher.find(idx) && (start = matcher.start()) != (end = matcher.end())) {
                        try {
                            highlighter.addHighlight(start, end, this.highlighterAll);
                        }
                        catch (BadLocationException blex) {
                            BugtrackingManager.LOG.log(Level.INFO, blex.getMessage(), blex);
                        }
                        idx = matcher.end();
                    }
                }
                break block9;
            }
            if (!(comp instanceof Container)) break block9;
            Container cont = (Container)comp;
            for (Component subComp : cont.getComponents()) {
                this.highlight(subComp, cancel);
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        private boolean forward;

        FindAction(boolean forward) {
            this.forward = forward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindSupport.this.bar.isVisible()) {
                if (this.forward) {
                    FindSupport.this.findNext();
                } else {
                    FindSupport.this.findPrevious();
                }
            } else {
                FindSupport.this.bar.setVisible(true);
                FindSupport.this.updatePattern();
            }
            FindSupport.this.bar.requestFocusInWindow();
        }
    }
}

