/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsf.editor.index.ResourcesMappingModel;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class JsfIndex {
    private final FileObject[] roots;
    private final FileObject[] binaryRoots;
    private final ThreadLocal<QuerySupport> indexCacheEmbedding = new ThreadLocal();
    private final ThreadLocal<QuerySupport> indexCacheBinary = new ThreadLocal();
    private final ThreadLocal<QuerySupport> indexCacheCustom = new ThreadLocal();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public static JsfIndex create(ClassPath sourceCp, ClassPath compileCp, ClassPath executeCp, ClassPath bootCp) {
        return new JsfIndex(sourceCp, compileCp, executeCp, bootCp);
    }

    private JsfIndex(ClassPath sourceCp, ClassPath compileCp, ClassPath executeCp, ClassPath bootCp) {
        HashSet<FileObject> cbRoots = new HashSet<FileObject>();
        cbRoots.addAll(Arrays.asList(compileCp.getRoots()));
        cbRoots.addAll(Arrays.asList(executeCp.getRoots()));
        this.binaryRoots = cbRoots.toArray(new FileObject[0]);
        HashSet<FileObject> croots = new HashSet<FileObject>();
        croots.addAll(Arrays.asList(sourceCp.getRoots()));
        for (ClassPath cp : new ClassPath[]{compileCp, bootCp}) {
            for (FileObject root : cp.getRoots()) {
                URL rootUrl = root.toURL();
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)rootUrl).getRoots();
                if (sourceRoots.length == 0) {
                    croots.add(root);
                    continue;
                }
                croots.addAll(Arrays.asList(sourceRoots));
            }
        }
        this.roots = croots.toArray(new FileObject[0]);
    }

    private synchronized QuerySupport createBinaryIndex() throws IOException {
        QuerySupport result = this.indexCacheBinary.get();
        if (result == null) {
            result = QuerySupport.forRoots((String)"jsfBinary", (int)11, (FileObject[])this.binaryRoots);
            this.indexCacheBinary.set(result);
        }
        return result;
    }

    private synchronized QuerySupport createCustomIndex() throws IOException {
        QuerySupport result = this.indexCacheCustom.get();
        if (result == null) {
            result = QuerySupport.forRoots((String)"jsfCustomIndexer", (int)7, (FileObject[])this.roots);
            this.indexCacheCustom.set(result);
        }
        return result;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void notifyChange() {
        this.changeSupport.fireChange();
    }

    public Collection<String> getAllCompositeLibraryNames() {
        LinkedHashSet<String> col = new LinkedHashSet<String>();
        try {
            col.addAll(this.getAllCompositeLibraryNames(this.createBinaryIndex()));
            col.addAll(this.getAllCompositeLibraryNames(this.createCustomIndex()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getAllCompositeLibraryNames(QuerySupport index) {
        ArrayList<String> libNames = new ArrayList<String>();
        try {
            Collection results = index.query("library", "", QuerySupport.Kind.PREFIX, new String[]{"library"});
            for (IndexResult result : results) {
                String libraryName = result.getValue("library");
                if (libraryName == null) continue;
                libNames.add(libraryName);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return libNames;
    }

    public Collection<String> getCompositeLibraryComponents(String libraryName) {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getCompositeLibraryComponents(this.createBinaryIndex(), libraryName));
            col.addAll(this.getCompositeLibraryComponents(this.createCustomIndex(), libraryName));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getCompositeLibraryComponents(QuerySupport index, String libraryName) {
        ArrayList<String> components = new ArrayList<String>();
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                components.add(file.getName());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return components;
    }

    public CompositeComponentModel getCompositeComponentModel(String libraryName, String componentName) {
        try {
            CompositeComponentModel model = this.getCompositeComponentModel(this.createCustomIndex(), libraryName, componentName);
            return model != null ? model : this.getCompositeComponentModel(this.createBinaryIndex(), libraryName, componentName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Map<FileObject, CompositeComponentModel> getCompositeComponentModels(String libraryName) {
        HashMap<FileObject, CompositeComponentModel> models = new HashMap<FileObject, CompositeComponentModel>();
        try {
            models.putAll(this.getCompositeComponentModels(this.createCustomIndex(), libraryName));
            models.putAll(this.getCompositeComponentModels(this.createBinaryIndex(), libraryName));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return models;
    }

    private Map<FileObject, CompositeComponentModel> getCompositeComponentModels(QuerySupport index, String libraryName) {
        HashMap<FileObject, CompositeComponentModel> modelsMap = new HashMap<FileObject, CompositeComponentModel>();
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation", "interface_facets", "interface_description"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                CompositeComponentModel model = (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(result);
                modelsMap.put(file, model);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelsMap;
    }

    private CompositeComponentModel getCompositeComponentModel(QuerySupport index, String libraryName, String componentName) {
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation", "interface_facets", "interface_description"});
            for (IndexResult result : results) {
                String fileName;
                FileObject file = result.getFile();
                if (file == null || !(fileName = file.getName()).equals(componentName)) continue;
                return (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(result);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Collection<IndexedFile> getAllFaceletsLibraryDescriptors() {
        ArrayList<IndexedFile> files = new ArrayList<IndexedFile>();
        try {
            this.queryFaceletsLibraryDescriptors(this.createBinaryIndex(), files);
            this.queryFaceletsLibraryDescriptors(this.createCustomIndex(), files);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return files;
    }

    private void queryFaceletsLibraryDescriptors(QuerySupport index, Collection<IndexedFile> files) throws IOException {
        Collection results = index.query("faceletsLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor", "timestamp", "fileContentChecksum"});
        this.convertToFiles(results, files);
    }

    public IndexedFile getTagLibraryDescriptor(String namespace) {
        try {
            IndexedFile file = this.findTLD(this.createCustomIndex(), namespace);
            return file != null ? file : this.findTLD(this.createBinaryIndex(), namespace);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private IndexedFile findTLD(QuerySupport index, String namespace) throws IOException {
        Collection results = index.query("namespace", namespace, QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "timestamp", "fileContentChecksum"});
        for (IndexResult result : results) {
            FileObject file;
            if (result.getValue("tagLibraryDescriptor") == null || (file = result.getFile()) == null) continue;
            long timestamp = Long.parseLong(result.getValue("timestamp"));
            String md5checksum = result.getValue("fileContentChecksum");
            return new IndexedFile(timestamp, md5checksum, file);
        }
        return null;
    }

    private void convertToFiles(Collection<? extends IndexResult> results, Collection<IndexedFile> files) {
        for (IndexResult indexResult : results) {
            FileObject file = indexResult.getFile();
            if (file == null) continue;
            long timestamp = Long.parseLong(indexResult.getValue("timestamp"));
            String md5checksum = indexResult.getValue("fileContentChecksum");
            files.add(new IndexedFile(timestamp, md5checksum, file));
        }
    }

    public Collection<ResourcesMappingModel.Resource> getAllStaticResources() {
        ArrayList<ResourcesMappingModel.Resource> resources = new ArrayList<ResourcesMappingModel.Resource>();
        try {
            QuerySupport index = this.createCustomIndex();
            Collection results = index.query("static_resources", "", QuerySupport.Kind.PREFIX, new String[]{"static_resources"});
            for (IndexResult result : results) {
                String resourceString = result.getValue("static_resources");
                resources.addAll(ResourcesMappingModel.parseResourcesFromString(resourceString));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return resources;
    }
}

