/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.antlr4;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Predicate;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;

public final class AntlrTokenSequence {
    private final TokenSource tokens;
    private boolean eofRead = false;
    private int readIndex;
    private int cursorOffset;
    private ListIterator<Token> cursor;
    private final ArrayList<Token> tokenList = new ArrayList(200);
    public static final Predicate<Token> DEFAULT_CHANNEL = new ChannelFilter(0);

    public AntlrTokenSequence(TokenSource tokens) {
        this.tokens = tokens;
        this.cursor = this.tokenList.listIterator();
    }

    public void seekTo(int offset) {
        if (offset > this.readIndex) {
            if (this.cursor.hasNext()) {
                this.cursor = this.tokenList.listIterator(this.tokenList.size());
            }
            Token t2 = this.read();
            while (t2 != null && t2.getStopIndex() + 1 < offset) {
                t2 = this.read();
            }
            if (t2 != null && offset < t2.getStopIndex() + 1) {
                this.cursor.previous();
                this.cursorOffset = t2.getStartIndex();
            } else {
                this.cursorOffset = this.readIndex;
            }
        } else if (offset > this.getOffset()) {
            this.next(t -> t.getStopIndex() > offset);
            if (this.cursor.hasPrevious()) {
                this.cursor.previous();
            }
        } else {
            this.previous(t -> t.getStartIndex() < offset);
        }
    }

    public boolean isEmpty() {
        return this.tokenList.isEmpty() && !this.hasNext();
    }

    public boolean hasNext() {
        Token t;
        if (!this.eofRead && this.cursorOffset == this.readIndex && !this.cursor.hasNext() && (t = this.read()) != null) {
            this.cursor.previous();
        }
        return !this.eofRead || this.cursor.hasNext();
    }

    public boolean hasPrevious() {
        return this.cursor.hasPrevious();
    }

    public int getOffset() {
        return this.cursorOffset;
    }

    public Optional<Token> previous() {
        Optional<Token> ret = this.cursor.hasPrevious() ? Optional.of(this.cursor.previous()) : Optional.empty();
        this.cursorOffset = this.cursor.hasPrevious() ? ((Token)ret.get()).getStartIndex() : 0;
        return ret;
    }

    public Optional<Token> previous(Predicate<Token> filter) {
        Optional<Token> ot = this.previous();
        while (ot.isPresent() && !filter.test(ot.get())) {
            ot = this.previous();
        }
        return ot;
    }

    public Optional<Token> previous(int tokenType) {
        return this.previous(t -> t.getType() == tokenType);
    }

    public Optional<Token> next() {
        if (this.hasNext()) {
            Token t = this.cursor.next();
            this.cursorOffset = t.getStopIndex() + 1;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public Optional<Token> next(Predicate<Token> filter) {
        Optional<Token> ot = this.next();
        while (ot.isPresent() && !filter.test(ot.get())) {
            ot = this.next();
        }
        return ot;
    }

    public Optional<Token> next(int tokenType) {
        return this.next(t -> t.getType() == tokenType);
    }

    private Token read() {
        if (this.eofRead) {
            return null;
        }
        Token t = this.tokens.nextToken();
        if (t.getType() != -1) {
            this.cursor.add(t);
            this.readIndex = t.getStopIndex() + 1;
            return t;
        }
        this.eofRead = true;
        return null;
    }

    public static final class ChannelFilter
    implements Predicate<Token> {
        private final int channel;

        public ChannelFilter(int channel) {
            this.channel = channel;
        }

        @Override
        public boolean test(Token t) {
            return this.channel == t.getChannel();
        }
    }
}

