/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetKnowledgeBaseRequest
extends BmcRequest<Void> {
    private String knowledgeBaseId;
    private String opcRequestId;

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().knowledgeBaseId(this.knowledgeBaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",knowledgeBaseId=").append(String.valueOf(this.knowledgeBaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetKnowledgeBaseRequest)) {
            return false;
        }
        GetKnowledgeBaseRequest other = (GetKnowledgeBaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.knowledgeBaseId, other.knowledgeBaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.knowledgeBaseId == null ? 43 : this.knowledgeBaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetKnowledgeBaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String knowledgeBaseId = null;
        private String opcRequestId = null;

        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetKnowledgeBaseRequest o) {
            this.knowledgeBaseId(o.getKnowledgeBaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetKnowledgeBaseRequest build() {
            GetKnowledgeBaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetKnowledgeBaseRequest buildWithoutInvocationCallback() {
            GetKnowledgeBaseRequest request = new GetKnowledgeBaseRequest();
            request.knowledgeBaseId = this.knowledgeBaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

