/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class InputOutputCache {
    private static final Logger LOGGER = Logger.getLogger(InputOutputCache.class.getName());
    private static final Map<InputOutput, CachedInputOutput> AVAILABLE = new WeakHashMap<InputOutput, CachedInputOutput>();
    private static final Set<String> ACTIVE_DISPLAY_NAMES = new HashSet<String>();

    private InputOutputCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedInputOutput get(String name, List<Action> actions) {
        Class<CachedInputOutput> clazz = CachedInputOutput.class;
        synchronized (CachedInputOutput.class) {
            CachedInputOutput result = InputOutputCache.getInputOutput(name, actions);
            if (result == null) {
                result = InputOutputCache.createInputOutput(name, actions);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedInputOutput get(InputOutput inputOutput) {
        CachedInputOutput result = null;
        Class<InputOutputCache> clazz = InputOutputCache.class;
        synchronized (InputOutputCache.class) {
            Iterator<Map.Entry<InputOutput, CachedInputOutput>> it = AVAILABLE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<InputOutput, CachedInputOutput> entry = it.next();
                InputOutput free = entry.getKey();
                CachedInputOutput data = entry.getValue();
                if (free.isClosed()) {
                    it.remove();
                    continue;
                }
                if (free.equals((Object)inputOutput)) {
                    result = data;
                    ACTIVE_DISPLAY_NAMES.add(result.getDisplayName());
                    it.remove();
                }
                LOGGER.log(Level.FINEST, "Pooled: {0}", data.getDisplayName());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(CachedInputOutput data) {
        Class<InputOutputCache> clazz = InputOutputCache.class;
        synchronized (InputOutputCache.class) {
            InputOutput io = data.getInputOutput();
            if (io != null) {
                AVAILABLE.put(io, data);
                ACTIVE_DISPLAY_NAMES.remove(data.getDisplayName());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedInputOutput getInputOutput(String name, List<Action> actions) {
        CachedInputOutput result = null;
        TreeSet<CachedInputOutput> candidates = new TreeSet<CachedInputOutput>(CachedInputOutput.DISPLAY_NAME_COMPARATOR);
        Class<InputOutputCache> clazz = InputOutputCache.class;
        synchronized (InputOutputCache.class) {
            Iterator<Map.Entry<InputOutput, CachedInputOutput>> it = AVAILABLE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<InputOutput, CachedInputOutput> entry = it.next();
                InputOutput free = entry.getKey();
                CachedInputOutput data = entry.getValue();
                if (free.isClosed()) {
                    it.remove();
                    continue;
                }
                if (InputOutputCache.isAppropriateName(name, data.getDisplayName())) {
                    List<Action> candidateActions = data.getActions();
                    if (candidateActions.isEmpty() && (actions == null || actions.isEmpty())) {
                        candidates.add(data);
                    } else if (actions != null && candidateActions.size() == actions.size()) {
                        boolean differs = false;
                        for (int i = 0; i < candidateActions.size(); ++i) {
                            if (candidateActions.get(i).getClass() == actions.get(i).getClass()) continue;
                            differs = true;
                            break;
                        }
                        if (!differs) {
                            candidates.add(data);
                        }
                    }
                }
                LOGGER.log(Level.FINEST, "Pooled: {0}", data.getDisplayName());
            }
            if (!candidates.isEmpty()) {
                result = (CachedInputOutput)candidates.first();
                AVAILABLE.remove(result.getInputOutput());
                ACTIVE_DISPLAY_NAMES.add(result.getDisplayName());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedInputOutput createInputOutput(String originalDisplayName, List<Action> actions) {
        Class<InputOutputCache> clazz = InputOutputCache.class;
        synchronized (InputOutputCache.class) {
            String displayName = InputOutputCache.getNonActiveDisplayName(originalDisplayName);
            InputOutput io = actions != null && !actions.isEmpty() ? IOProvider.getDefault().getIO(displayName, actions.toArray(new Action[0])) : IOProvider.getDefault().getIO(displayName, true);
            ACTIVE_DISPLAY_NAMES.add(displayName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new CachedInputOutput(io, displayName, actions);
        }
    }

    private static boolean isAppropriateName(String base, String toMatch) {
        if (!toMatch.startsWith(base)) {
            return false;
        }
        return toMatch.substring(base.length()).matches("^(\\ #[0-9]+)?$");
    }

    private static String getNonActiveDisplayName(String displayNameBase) {
        String nonActiveDN = displayNameBase;
        if (ACTIVE_DISPLAY_NAMES.contains(nonActiveDN)) {
            String testdn;
            int i = 2;
            while (ACTIVE_DISPLAY_NAMES.contains(testdn = Bundle.LBL_Uniquified(nonActiveDN, i++))) {
            }
            nonActiveDN = testdn;
        }
        assert (!ACTIVE_DISPLAY_NAMES.contains(nonActiveDN));
        return nonActiveDN;
    }

    public static final class CachedInputOutput {
        private static final Comparator<CachedInputOutput> DISPLAY_NAME_COMPARATOR = new Comparator<CachedInputOutput>(){

            @Override
            public int compare(CachedInputOutput o1, CachedInputOutput o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        };
        private final WeakReference<InputOutput> inputOutput;
        private final String displayName;
        private final List<Action> actions;

        public CachedInputOutput(InputOutput inputOutput, String displayName, List<Action> actions) {
            this.inputOutput = new WeakReference<InputOutput>(inputOutput);
            this.displayName = displayName;
            this.actions = new ArrayList<Action>(actions);
        }

        @CheckForNull
        public InputOutput getInputOutput() {
            return (InputOutput)this.inputOutput.get();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<Action> getActions() {
            return Collections.unmodifiableList(this.actions);
        }
    }
}

