/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;

public class QueryBuilderSqlCompletion
extends DefaultStyledDocument {
    private List dictionary = new ArrayList();
    private JTextComponent comp;
    private int charCount = -1;
    private int lastOffset = 0;

    public QueryBuilderSqlCompletion(JTextComponent field, String[] aDictionary) {
        this.comp = field;
        this.dictionary.addAll(Arrays.asList(aDictionary));
    }

    public void addDictionaryEntry(String item) {
        this.dictionary.add(item);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
        this.charCount = offs + this.charCount <= this.lastOffset ? 0 : ++this.charCount;
        String charTyped = this.getText(offs - this.charCount, this.comp.getCaretPosition() - (offs - this.charCount));
        String word = this.completeText(charTyped);
        if (word != null) {
            super.insertString(offs + str.length(), word, a);
            this.comp.setCaretPosition(offs + str.length());
            this.comp.moveCaretPosition(offs + word.length() + 1);
        } else {
            this.comp.setCaretPosition(offs + str.length());
            if (this.charCount >= 0) {
                --this.charCount;
            }
        }
        this.lastOffset = offs;
    }

    public String completeText(String text) {
        for (String word : this.dictionary) {
            if (word.startsWith(text)) {
                return word.substring(text.length());
            }
            if (!word.startsWith(text.toUpperCase())) continue;
            return word.substring(text.length()).toLowerCase();
        }
        return null;
    }
}

