/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.symbol;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.micronaut.symbol.Bundle;
import org.netbeans.modules.micronaut.symbol.MicronautSymbolSearcher;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class MicronautSymbolErrorProvider
implements ErrorProvider {
    public List<? extends Diagnostic> computeErrors(ErrorProvider.Context context) {
        Project project;
        if (context.errorKind() != ErrorProvider.Kind.ERRORS || context.isCancelled()) {
            return Collections.emptyList();
        }
        FileObject fo = context.file();
        Project project2 = project = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : null;
        if (project == null) {
            return Collections.emptyList();
        }
        try {
            return MicronautSymbolSearcher.getSymbolsWithPathDuplicates(project, fo).stream().filter(descriptor -> descriptor.getFileObject() == fo).map(descriptor -> this.desc2diag((MicronautSymbolSearcher.SymbolDescriptor)((Object)descriptor))).collect(Collectors.toList());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private Diagnostic desc2diag(MicronautSymbolSearcher.SymbolDescriptor descriptor) {
        OffsetRange offsetRange = descriptor.getElement().getOffsetRange(null);
        return Diagnostic.Builder.create(() -> offsetRange.getStart(), () -> offsetRange.getEnd(), (String)Bundle.ERR_Duplicated_URI_path(descriptor.getElement().getName())).setCode("WARN_Duplicated_MN_Data_Endpoint_Path " + offsetRange.getStart() + " - " + offsetRange.getEnd()).setSeverity(Diagnostic.Severity.Warning).build();
    }
}

