/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.javascript2.editor.spi.CompletionProviderEx;
import org.netbeans.modules.javascript2.editor.spi.ProposalRequest;
import org.netbeans.modules.javascript2.html.HtmlAttrElement;
import org.netbeans.modules.javascript2.html.HtmlCompletionItem;

public class HtmlTagCompletionProvider
implements CompletionProviderEx {
    public List<CompletionProposal> complete(ProposalRequest request) {
        if (!request.getSelectors().contains("Element")) {
            return Collections.emptyList();
        }
        ArrayList<CompletionProposal> resultList = new ArrayList<CompletionProposal>();
        for (HtmlTagAttribute attribute : this.getAllAttributes()) {
            if (!attribute.getName().startsWith(request.getPrefix())) continue;
            resultList.add(new HtmlCompletionItem(request.getInfo(), attribute, request.getAnchor()));
        }
        return resultList;
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        if (!(element instanceof HtmlAttrElement)) {
            return null;
        }
        return ((HtmlAttrElement)element).getDocumentation().toString();
    }

    private Collection<HtmlTagAttribute> getAllAttributes() {
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        HashMap<String, HtmlTagAttribute> result = new HashMap<String, HtmlTagAttribute>();
        for (HtmlTag htmlTag : htmlModel.getAllTags()) {
            for (HtmlTagAttribute htmlTagAttribute : htmlTag.getAttributes()) {
                if (result.containsKey(htmlTagAttribute.getName())) continue;
                result.put(htmlTagAttribute.getName(), htmlTagAttribute);
            }
        }
        return result.values();
    }
}

