/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTenancyRequest
extends BmcRequest<Void> {
    private String tenancyId;

    public String getTenancyId() {
        return this.tenancyId;
    }

    public Builder toBuilder() {
        return new Builder().tenancyId(this.tenancyId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTenancyRequest)) {
            return false;
        }
        GetTenancyRequest other = (GetTenancyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tenancyId, other.tenancyId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTenancyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tenancyId = null;

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTenancyRequest o) {
            this.tenancyId(o.getTenancyId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTenancyRequest build() {
            GetTenancyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTenancyRequest buildWithoutInvocationCallback() {
            GetTenancyRequest request = new GetTenancyRequest();
            request.tenancyId = this.tenancyId;
            return request;
        }
    }
}

