/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.cli.Bundle;
import org.netbeans.modules.subversion.client.cli.CLIStatus;
import org.netbeans.modules.subversion.client.cli.Commandline;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.netbeans.modules.subversion.client.cli.commands.AddCommand;
import org.netbeans.modules.subversion.client.cli.commands.BlameCommand;
import org.netbeans.modules.subversion.client.cli.commands.CatCommand;
import org.netbeans.modules.subversion.client.cli.commands.CheckoutCommand;
import org.netbeans.modules.subversion.client.cli.commands.CleanupCommand;
import org.netbeans.modules.subversion.client.cli.commands.CommitCommand;
import org.netbeans.modules.subversion.client.cli.commands.CopyCommand;
import org.netbeans.modules.subversion.client.cli.commands.ExportCommand;
import org.netbeans.modules.subversion.client.cli.commands.ImportCommand;
import org.netbeans.modules.subversion.client.cli.commands.InfoCommand;
import org.netbeans.modules.subversion.client.cli.commands.ListCommand;
import org.netbeans.modules.subversion.client.cli.commands.ListPropertiesCommand;
import org.netbeans.modules.subversion.client.cli.commands.LogCommand;
import org.netbeans.modules.subversion.client.cli.commands.MergeCommand;
import org.netbeans.modules.subversion.client.cli.commands.MkdirCommand;
import org.netbeans.modules.subversion.client.cli.commands.MoveCommand;
import org.netbeans.modules.subversion.client.cli.commands.PropertyDelCommand;
import org.netbeans.modules.subversion.client.cli.commands.PropertyGetCommand;
import org.netbeans.modules.subversion.client.cli.commands.PropertySetCommand;
import org.netbeans.modules.subversion.client.cli.commands.RelocateCommand;
import org.netbeans.modules.subversion.client.cli.commands.RemoveCommand;
import org.netbeans.modules.subversion.client.cli.commands.ResolvedCommand;
import org.netbeans.modules.subversion.client.cli.commands.RevertCommand;
import org.netbeans.modules.subversion.client.cli.commands.StatusCommand;
import org.netbeans.modules.subversion.client.cli.commands.SwitchToCommand;
import org.netbeans.modules.subversion.client.cli.commands.UpdateCommand;
import org.netbeans.modules.subversion.client.cli.commands.UpgradeCommand;
import org.netbeans.modules.subversion.client.cli.commands.VersionCommand;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.ParserSvnStatus;
import org.netbeans.modules.subversion.client.parser.SvnWcParser;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.Annotations;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.ISVNStatusCallback;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNKeywords;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CommandlineClient
extends AbstractClientAdapter
implements ISVNClientAdapter {
    private String user;
    private String psswd;
    private File configDir;
    private NotificationHandler notificationHandler = new NotificationHandler();
    private SvnWcParser wcParser = new SvnWcParser();
    private Commandline cli = new Commandline();
    public static String ERR_CLI_NOT_AVALABLE = "commandline is not available";
    public static String ERR_JAVAHL_NOT_SUPPORTED = "unsupported javahl version";
    private static boolean supportedMetadataFormat;

    public boolean checkSupportedVersion() throws SVNClientException {
        VersionCommand cmd = new VersionCommand();
        try {
            this.config(cmd);
            this.cli.exec(cmd);
            this.checkErrors(cmd);
            if (!cmd.checkForErrors()) {
                if (cmd.isUnsupportedVersion()) {
                    Subversion.LOG.log(Level.WARNING, "Unsupported svn version. You need >= 1.5");
                }
                throw new SVNClientException(ERR_CLI_NOT_AVALABLE + "\n" + cmd.getOutput());
            }
            supportedMetadataFormat = cmd.isMetadataFormatSupported();
            return supportedMetadataFormat;
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.FINE, null, ex);
            throw new SVNClientException(ERR_CLI_NOT_AVALABLE);
        }
    }

    public String getVersion() throws SVNClientException {
        VersionCommand cmd = new VersionCommand();
        try {
            this.config(cmd);
            this.cli.exec(cmd);
            this.checkErrors(cmd);
            return cmd.getOutput();
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.FINE, null, ex);
            throw SVNClientException.wrapException((Exception)ex);
        }
    }

    public void addNotifyListener(ISVNNotifyListener l) {
        this.notificationHandler.add(l);
    }

    public void removeNotifyListener(ISVNNotifyListener l) {
        this.notificationHandler.remove(l);
    }

    public void setUsername(String user) {
        this.user = user;
    }

    public void setPassword(String psswd) {
        this.psswd = psswd;
    }

    public void setConfigDirectory(File file) throws SVNClientException {
        this.configDir = file;
    }

    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void addFile(File file) throws SVNClientException {
        this.addFile(new File[]{file}, false);
    }

    public void addFile(File[] file, boolean recursive) throws SVNClientException {
        AddCommand cmd = new AddCommand(file, recursive, false);
        this.exec(cmd);
    }

    public void addDirectory(File dir, boolean recursive) throws SVNClientException {
        this.addDirectory(dir, recursive, false);
    }

    public void addDirectory(File dir, boolean recursive, boolean force) throws SVNClientException {
        AddCommand cmd = new AddCommand(new File[]{dir}, recursive, force);
        this.exec(cmd);
    }

    public void checkout(SVNUrl url, File file, SVNRevision revision, boolean recurse) throws SVNClientException {
        CheckoutCommand cmd = new CheckoutCommand(url, file, revision, recurse);
        this.exec(cmd);
    }

    public void doExport(SVNUrl url, File destination, SVNRevision revision, boolean force) throws SVNClientException {
        ExportCommand cmd = new ExportCommand(url, destination, revision, force);
        this.exec(cmd);
    }

    public void doExport(File fileFrom, File fileTo, boolean force) throws SVNClientException {
        ExportCommand cmd = new ExportCommand(fileFrom, fileTo, force);
        this.exec(cmd);
    }

    public long commit(File[] files, String message, boolean recurse) throws SVNClientException {
        return this.commit(files, message, false, recurse);
    }

    public long commit(File[] files, String message, boolean keep, boolean recursive) throws SVNClientException {
        int retry = 0;
        CommitCommand cmd = null;
        while (true) {
            try {
                cmd = new CommitCommand(files, keep, recursive, message);
                this.exec(cmd);
            }
            catch (SVNClientException e) {
                if (e.getMessage().startsWith("svn: Attempted to lock an already-locked dir")) {
                    Subversion.LOG.fine("ComandlineClient.comit() : " + e.getMessage());
                    try {
                        if (++retry > 14) {
                            throw e;
                        }
                        Thread.sleep(retry * 50);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
        return cmd != null ? cmd.getRevision() : -1L;
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recursivelly) throws SVNClientException {
        ListCommand cmd = new ListCommand(url, revision, recursivelly);
        this.exec(cmd);
        return cmd.getEntries();
    }

    public ISVNInfo getInfo(SVNUrl url) throws SVNClientException {
        return super.getInfo(url);
    }

    public ISVNInfo getInfo(File file) throws SVNClientException {
        return this.getInfoFromWorkingCopy(file);
    }

    public String getPostCommitError() {
        return null;
    }

    private ISVNInfo[] getInfo(File[] files, SVNRevision revision, SVNRevision pegging) throws SVNClientException, SVNClientException {
        if (files == null || files.length == 0) {
            return new ISVNInfo[0];
        }
        InfoCommand infoCmd = new InfoCommand(files, revision, pegging);
        this.exec(infoCmd);
        ISVNInfo[] infos = infoCmd.getInfo();
        return infos;
    }

    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision pegging) throws SVNClientException {
        InfoCommand cmd = new InfoCommand(url, revision, pegging);
        this.exec(cmd);
        ISVNInfo[] infos = cmd.getInfo();
        ISVNInfo info = null;
        if (infos.length > 0) {
            info = infos[0];
        }
        return info;
    }

    public void copy(File fileFrom, File fileTo) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(fileFrom, fileTo);
        this.exec(cmd);
    }

    public void copy(File file, SVNUrl url, String msg) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(file, url, msg);
        this.exec(cmd);
    }

    public void copy(SVNUrl url, File file, SVNRevision rev) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(url, file, rev);
        this.exec(cmd);
    }

    public void copy(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev) throws SVNClientException {
        this.copy(fromUrl, toUrl, msg, rev, false);
    }

    public void remove(SVNUrl[] url, String msg) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void remove(File[] files, boolean force) throws SVNClientException {
        RemoveCommand cmd = new RemoveCommand(files, force);
        this.exec(cmd);
    }

    public void doImport(File File2, SVNUrl url, String msg, boolean recursivelly) throws SVNClientException {
        ImportCommand cmd = new ImportCommand(File2, url, recursivelly, msg);
        this.exec(cmd);
    }

    public void mkdir(SVNUrl url, String msg) throws SVNClientException {
        MkdirCommand cmd = new MkdirCommand(url, msg);
        this.exec(cmd);
    }

    public void mkdir(SVNUrl url, boolean parents, String msg) throws SVNClientException {
        if (parents) {
            List<SVNUrl> parent = this.getAllNotExistingParents(url);
            for (SVNUrl p : parent) {
                this.mkdir(p, msg);
            }
        } else {
            this.mkdir(url, msg);
        }
    }

    public void mkdir(File file) throws SVNClientException {
        MkdirCommand cmd = new MkdirCommand(file);
        this.exec(cmd);
    }

    public void move(File fromFile, File toFile, boolean force) throws SVNClientException {
        MoveCommand cmd = new MoveCommand(fromFile, toFile, force);
        this.exec(cmd);
    }

    public void move(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev) throws SVNClientException {
        MoveCommand cmd = new MoveCommand(fromUrl, toUrl, msg, rev);
        this.exec(cmd);
    }

    public long update(File file, SVNRevision rev, boolean recursivelly) throws SVNClientException {
        UpdateCommand cmd = new UpdateCommand(new File[]{file}, rev, recursivelly, false);
        this.exec(cmd);
        return cmd.getRevision();
    }

    public long[] update(File[] files, SVNRevision rev, boolean recursivelly, boolean ignoreExternals) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revert(File file, boolean recursivelly) throws SVNClientException {
        this.revert(new File[]{file}, recursivelly);
    }

    public void revert(File[] files, boolean recursivelly) throws SVNClientException {
        if (files == null || files.length == 0) {
            return;
        }
        RevertCommand cmd = new RevertCommand(files, recursivelly);
        this.exec(cmd);
    }

    public ISVNStatus[] getStatus(File[] files) throws SVNClientException {
        HashMap<File, SVNStatusUnversioned> unversionedMap = new HashMap<File, SVNStatusUnversioned>();
        ArrayList<File> filesForStatus = new ArrayList<File>();
        ArrayList<File> filesForInfo = new ArrayList<File>();
        for (File f : files) {
            if (!this.isManaged(f)) {
                unversionedMap.put(f, new SVNStatusUnversioned(f));
                continue;
            }
            filesForStatus.add(f);
        }
        StatusCommand.Status[] statusValues = new StatusCommand.Status[]{};
        if (!filesForStatus.isEmpty()) {
            StatusCommand statusCmd = new StatusCommand(filesForStatus.toArray(new File[0]), true, false, false, false);
            this.exec(statusCmd);
            statusValues = statusCmd.getStatusValues();
        }
        for (StatusCommand.Status status : statusValues) {
            if (!this.isManaged(status.getWcStatus())) continue;
            filesForInfo.add(new File(status.getPath()));
        }
        HashMap<File, ISVNInfo> infoMap = new HashMap<File, ISVNInfo>();
        if (!filesForInfo.isEmpty()) {
            ISVNInfo[] infos;
            ISVNInfo[] f = infos = this.getInfo(filesForInfo.toArray(new File[0]), null, null);
            int n = f.length;
            for (int i = 0; i < n; ++i) {
                ISVNInfo info = f[i];
                infoMap.put(info.getFile(), info);
            }
        }
        HashMap<File, CLIStatus> statusMap = new HashMap<File, CLIStatus>();
        for (StatusCommand.Status status : statusValues) {
            File file = new File(status.getPath());
            if (status == null || !this.isManaged(status.getWcStatus())) {
                if (!SVNStatusKind.UNVERSIONED.equals((Object)status.getRepoStatus())) {
                    statusMap.put(file, new CLIStatus(status, status.getPath()));
                    continue;
                }
                statusMap.put(file, (CLIStatus)new SVNStatusUnversioned(file, SVNStatusKind.IGNORED.equals((Object)status.getWcStatus())));
                continue;
            }
            ISVNInfo info = (ISVNInfo)infoMap.get(file);
            if (info == null) continue;
            statusMap.put(file, new CLIStatus(status, info));
        }
        ArrayList<ISVNStatus> ret = new ArrayList<ISVNStatus>();
        for (File f : files) {
            ISVNStatus s = (ISVNStatus)statusMap.get(f);
            if (s == null) {
                s = (ISVNStatus)unversionedMap.get(f);
            }
            if (s == null) continue;
            ret.add(s);
        }
        return ret.toArray(new ISVNStatus[0]);
    }

    public ISVNStatus[] getStatus(File file, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(file, descend, getAll, contactServer, false);
    }

    public ISVNStatus[] getStatus(File file, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        StatusCommand.Status[] statusValues = null;
        try {
            if (!this.isManaged(file)) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            StatusCommand statusCmd = new StatusCommand(new File[]{file}, getAll, descend, contactServer, ignoreExternals);
            this.exec(statusCmd);
            statusValues = statusCmd.getStatusValues();
        }
        catch (SVNClientException e) {
            if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage())) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            throw e;
        }
        ArrayList<File> filesForInfo = new ArrayList<File>();
        for (StatusCommand.Status status : statusValues) {
            if (!this.isManaged(status.getWcStatus())) continue;
            filesForInfo.add(new File(status.getPath()));
        }
        ISVNInfo[] infos = this.getInfo(filesForInfo.toArray(new File[0]), null, null);
        HashMap<File, ISVNInfo> infoMap = new HashMap<File, ISVNInfo>();
        for (ISVNInfo info : infos) {
            infoMap.put(info.getFile(), info);
        }
        HashMap<File, CLIStatus> statusMap = new HashMap<File, CLIStatus>();
        for (StatusCommand.Status status : statusValues) {
            File f = new File(status.getPath());
            if (status == null || !this.isManaged(status.getWcStatus())) {
                if (!SVNStatusKind.UNVERSIONED.equals((Object)status.getRepoStatus())) {
                    statusMap.put(f, new CLIStatus(status, status.getPath()));
                    continue;
                }
                statusMap.put(f, (CLIStatus)new SVNStatusUnversioned(f, SVNStatusKind.IGNORED.equals((Object)status.getWcStatus())));
                continue;
            }
            ISVNInfo info = (ISVNInfo)infoMap.get(f);
            if (info == null) continue;
            statusMap.put(f, new CLIStatus(status, info));
        }
        ArrayList<ISVNStatus> ret = new ArrayList<ISVNStatus>();
        for (StatusCommand.Status status : statusValues) {
            File f = new File(status.getPath());
            ISVNStatus s = (ISVNStatus)statusMap.get(f);
            if (s == null) {
                s = new SVNStatusUnversioned(f);
            }
            ret.add(s);
        }
        return ret.toArray(new ISVNStatus[0]);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        return super.getLogMessages(url, revStart, revEnd);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revStart, SVNRevision revEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, null, revStart, revEnd, false, fetchChangePath);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        LogCommand cmd = new LogCommand(url, paths, revStart, revEnd, SVNRevision.HEAD, stopOnCopy, fetchChangePath, 0L);
        return this.getLog(cmd);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revPeg, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        LogCommand cmd = new LogCommand(url, null, revStart, revEnd, revPeg, stopOnCopy, fetchChangePath, limit);
        return this.getLog(cmd);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        return super.getLogMessages(file, revStart, revEnd);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision revStart, SVNRevision revEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(file, revStart, revEnd, false, fetchChangePath);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(file, revStart, revEnd, stopOnCopy, fetchChangePath, 0L);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        return this.getLogMessages(file, SVNRevision.HEAD, revStart, revEnd, stopOnCopy, fetchChangePath, limit, false);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision pegRevision, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        LogCommand logCmd = info.getSchedule().equals((Object)SVNScheduleKind.ADD) && info.getCopyUrl() != null ? new LogCommand(info.getCopyUrl(), null, revStart, revEnd, pegRevision, stopOnCopy, fetchChangePath, limit) : new LogCommand(file, revStart, revEnd, pegRevision, stopOnCopy, fetchChangePath, limit);
        return this.getLog(logCmd);
    }

    private ISVNLogMessage[] getLog(LogCommand cmd) throws SVNClientException {
        this.exec(cmd);
        return cmd.getLogMessages();
    }

    public InputStream getContent(SVNUrl url, SVNRevision rev) throws SVNClientException {
        return this.getContent(url, rev, null);
    }

    public InputStream getContent(File file, SVNRevision rev) throws SVNClientException {
        CatCommand cmd = new CatCommand(file, rev);
        this.exec(cmd);
        return cmd.getOutput();
    }

    public void propertySet(File file, String name, String value, boolean rec) throws SVNClientException {
        ISVNStatus[] oldStatus = this.getStatus(file, rec, true);
        PropertySetCommand cmd = new PropertySetCommand(name, value, file, rec);
        this.exec(cmd);
        this.notifyChangedStatus(file, rec, oldStatus);
    }

    public void propertySet(File file, String name, File propFile, boolean rec) throws SVNClientException, IOException {
        ISVNStatus[] oldStatus = this.getStatus(file, rec, true);
        PropertySetCommand cmd = new PropertySetCommand(name, propFile, file, rec);
        this.exec(cmd);
        this.notifyChangedStatus(file, rec, oldStatus);
    }

    public void propertyDel(File file, String name, boolean rec) throws SVNClientException {
        ISVNStatus[] oldStatus = this.getStatus(file, rec, true);
        PropertyDelCommand cmd = new PropertyDelCommand(file, name, rec);
        this.exec(cmd);
        this.notifyChangedStatus(file, rec, oldStatus);
    }

    public ISVNProperty propertyGet(File file, String name) throws SVNClientException {
        return this.propertyGet(new PropertyGetCommand(file, name), name, null, file);
    }

    public ISVNProperty propertyGet(SVNUrl url, String name) throws SVNClientException {
        return super.propertyGet(url, name);
    }

    public ISVNProperty propertyGet(SVNUrl url, SVNRevision rev, SVNRevision peg, String name) throws SVNClientException {
        return this.propertyGet(new PropertyGetCommand(url, rev, peg, name), name, url, null);
    }

    ISVNProperty propertyGet(PropertyGetCommand cmd, final String name, final SVNUrl url, final File file) throws SVNClientException {
        this.exec(cmd);
        final byte[] bytes = cmd.getOutput();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ISVNProperty(){
            final /* synthetic */ CommandlineClient this$0;
            {
                this.this$0 = this$0;
            }

            public String getName() {
                return name;
            }

            public String getValue() {
                return new String(bytes);
            }

            public File getFile() {
                return file;
            }

            public SVNUrl getUrl() {
                return url;
            }

            public byte[] getData() {
                return bytes;
            }
        };
    }

    public List getIgnoredPatterns(File file) throws SVNClientException {
        return super.getIgnoredPatterns(file);
    }

    public void addToIgnoredPatterns(File file, String value) throws SVNClientException {
        super.addToIgnoredPatterns(file, value);
    }

    public void setIgnoredPatterns(File file, List l) throws SVNClientException {
        super.setIgnoredPatterns(file, l);
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        return this.annotate(new BlameCommand(url, revStart, revEnd), new CatCommand(url, revEnd, null));
    }

    public ISVNAnnotations annotate(File file, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        BlameCommand blameCommand = info.getSchedule().equals((Object)SVNScheduleKind.ADD) && info.getCopyUrl() != null ? new BlameCommand(info.getCopyUrl(), revStart, revEnd) : new BlameCommand(file, revStart, revEnd);
        return this.annotate(blameCommand, new CatCommand(file, revEnd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNAnnotations annotate(BlameCommand blameCmd, CatCommand catCmd) throws SVNClientException {
        this.exec(blameCmd);
        Annotations.Annotation[] annotations = blameCmd.getAnnotation();
        this.exec(catCmd);
        InputStream is = catCmd.getOutput();
        Annotations ret = new Annotations();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        try {
            for (Annotations.Annotation annotation : annotations) {
                String line = null;
                try {
                    line = r.readLine();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.INFO, ex.getMessage(), ex);
                }
                annotation.setLine(line);
                ret.addAnnotation(annotation);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    public ISVNProperty[] getProperties(final File file) throws SVNClientException {
        ListPropertiesCommand cmd = new ListPropertiesCommand(file, false);
        this.exec(cmd);
        List<String> names = cmd.getPropertyNames();
        ArrayList<ISVNProperty> props = new ArrayList<ISVNProperty>(names.size());
        for (final String name : names) {
            ISVNProperty prop = this.propertyGet(file, name);
            if (prop == null) {
                props.add(new ISVNProperty(){
                    final /* synthetic */ CommandlineClient this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String getName() {
                        return name;
                    }

                    public String getValue() {
                        return "";
                    }

                    public File getFile() {
                        return file;
                    }

                    public SVNUrl getUrl() {
                        return null;
                    }

                    public byte[] getData() {
                        return new byte[0];
                    }
                });
                continue;
            }
            props.add(prop);
        }
        return props.toArray(new ISVNProperty[0]);
    }

    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        ListPropertiesCommand cmd = new ListPropertiesCommand(url, false);
        this.exec(cmd);
        List<String> names = cmd.getPropertyNames();
        ArrayList<ISVNProperty> props = new ArrayList<ISVNProperty>(names.size());
        for (String name : names) {
            ISVNProperty prop = this.propertyGet(url, name);
            if (prop == null) continue;
            props.add(prop);
        }
        return props.toArray(new ISVNProperty[0]);
    }

    public void resolved(File file) throws SVNClientException {
        ResolvedCommand cmd = new ResolvedCommand(file, false);
        this.exec(cmd);
    }

    public void cancelOperation() throws SVNClientException {
        this.cli.interrupt();
    }

    public void switchToUrl(File file, SVNUrl url, SVNRevision rev, boolean rec) throws SVNClientException {
        SwitchToCommand cmd = new SwitchToCommand(file, url, rev, rec);
        this.exec(cmd);
    }

    public void merge(SVNUrl startUrl, SVNRevision startRev, SVNUrl endUrl, SVNRevision endRev, File file, boolean force, boolean recurse) throws SVNClientException {
        super.merge(startUrl, startRev, endUrl, endRev, file, force, recurse);
    }

    public void merge(SVNUrl startUrl, SVNRevision startRev, SVNUrl endUrl, SVNRevision endRev, File file, boolean force, boolean recurse, boolean dryRun) throws SVNClientException {
        super.merge(startUrl, startRev, endUrl, endRev, file, force, recurse, dryRun);
    }

    public void merge(SVNUrl startUrl, SVNRevision startRev, SVNUrl endUrl, SVNRevision endRev, File file, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        MergeCommand cmd = new MergeCommand(startUrl, endUrl, startRev, endRev, file, recurse, force, ignoreAncestry, dryRun);
        this.exec(cmd);
    }

    public void relocate(String from, String to, String path, boolean rec) throws SVNClientException {
        RelocateCommand cmd = new RelocateCommand(from, to, path, rec);
        this.exec(cmd);
    }

    public ISVNStatus getSingleStatus(File file) throws SVNClientException {
        block6: {
            if (supportedMetadataFormat) {
                try {
                    return this.wcParser.getSingleStatus(file);
                }
                catch (LocalSubversionException ex) {
                    if (ex.getCause() != null && "WC1_7Format".equals(ex.getCause().getMessage())) break block6;
                    throw new SVNClientException((Throwable)ex);
                }
            }
        }
        try {
            ISVNStatus[] statuses = this.getStatus(new File[]{file});
            return statuses.length > 0 ? statuses[0] : new ParserSvnStatus(file, null, 0L, "unknown", SVNStatusKind.UNVERSIONED.toString(), SVNStatusKind.UNVERSIONED.toString(), null, 0L, null, false, null, null, null, null, null, null, null, false, null);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage()) || SvnClientExceptionHandler.isNodeNotFound(ex.getMessage())) {
                return new SVNStatusUnversioned(file);
            }
            throw ex;
        }
    }

    public ISVNStatus[] getStatus(File file, boolean descend, boolean getAll) throws SVNClientException {
        block3: {
            if (supportedMetadataFormat) {
                try {
                    return this.wcParser.getStatus(file, descend, getAll);
                }
                catch (LocalSubversionException ex) {
                    if (ex.getCause() != null && "WC1_7Format".equals(ex.getCause().getMessage())) break block3;
                    throw new SVNClientException((Throwable)ex);
                }
            }
        }
        return this.getStatus(file, descend, getAll, false, true);
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws SVNClientException {
        block6: {
            if (supportedMetadataFormat) {
                try {
                    return this.wcParser.getInfoFromWorkingCopy(file);
                }
                catch (LocalSubversionException ex) {
                    if (ex.getCause() != null && "WC1_7Format".equals(ex.getCause().getMessage())) break block6;
                    throw new SVNClientException((Throwable)ex);
                }
            }
        }
        try {
            ISVNInfo[] infos = this.getInfo(new File[]{file}, null, null);
            return infos.length > 0 ? infos[0] : null;
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isNodeNotFound(ex.getMessage())) {
                return this.wcParser.getUnknownInfo(file);
            }
            throw ex;
        }
    }

    private void exec(SvnCommand cmd) throws SVNClientException {
        try {
            this.config(cmd);
            this.cli.exec(cmd);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.FINE, null, ex);
            throw new SVNClientException((Throwable)ex);
        }
        this.checkErrors(cmd);
    }

    private void config(SvnCommand cmd) {
        cmd.setNotificationHandler(this.notificationHandler);
        cmd.setConfigDir(this.configDir);
        cmd.setUsername(this.user);
        cmd.setPassword(this.psswd);
    }

    private void checkErrors(SvnCommand cmd) throws SVNClientException {
        List<String> errors = cmd.getCmdError();
        if (errors == null || errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < errors.size(); ++i) {
            sb.append(errors.get(i));
            if (i >= errors.size() - 1) continue;
            sb.append('\n');
        }
        throw new SVNClientException(sb.toString());
    }

    private List<SVNUrl> getAllNotExistingParents(SVNUrl url) throws SVNClientException {
        ArrayList<SVNUrl> ret = new ArrayList<SVNUrl>();
        if (url == null) {
            return ret;
        }
        try {
            this.getInfo(url);
        }
        catch (SVNClientException e) {
            if (e.getMessage().indexOf("Not a valid URL") > -1 || e.getMessage().contains("non-existent in revision")) {
                ret.addAll(this.getAllNotExistingParents(url.getParent()));
                ret.add(url);
            }
            throw e;
        }
        return ret;
    }

    private boolean isManaged(SVNStatusKind s) {
        return !s.equals((Object)SVNStatusKind.UNVERSIONED) && !s.equals((Object)SVNStatusKind.NONE) && !s.equals((Object)SVNStatusKind.IGNORED) && !s.equals((Object)SVNStatusKind.EXTERNAL);
    }

    private boolean hasMetadata(File file) {
        return SvnUtils.hasMetadata(file);
    }

    private boolean isManaged(File file) {
        boolean managed = true;
        if (supportedMetadataFormat) {
            managed = this.hasMetadata(file.getParentFile()) || this.hasMetadata(file);
        }
        return managed;
    }

    public long[] commitAcrossWC(File[] arg0, String arg1, boolean arg2, boolean arg3, boolean arg4) throws SVNClientException {
        return super.commitAcrossWC(arg0, arg1, arg2, arg3, arg4);
    }

    public ISVNDirEntry getDirEntry(SVNUrl arg0, SVNRevision arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry getDirEntry(File arg0, SVNRevision arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRevProperty(SVNUrl arg0, SVNRevision.Number arg1, String arg2, String arg3, boolean arg4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File arg0, SVNRevision arg1, File arg2, SVNRevision arg3, File arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File arg0, SVNRevision arg1, File arg2, SVNRevision arg3, File arg4, boolean arg5, boolean arg6, boolean arg7, boolean arg8) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File arg0, File arg1, boolean arg2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl arg0, SVNRevision arg1, SVNUrl arg2, SVNRevision arg3, File arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl arg0, SVNRevision arg1, SVNUrl arg2, SVNRevision arg3, File arg4, boolean arg5, boolean arg6, boolean arg7, boolean arg8) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, File arg3, boolean arg4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File arg0, SVNUrl arg1, SVNRevision arg2, File arg3, boolean arg4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNKeywords getKeywords(File arg0) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setKeywords(File arg0, SVNKeywords arg1, boolean arg2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNKeywords addKeywords(File arg0, SVNKeywords arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNKeywords removeKeywords(File arg0, SVNKeywords arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void createRepository(File arg0, String arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void lock(SVNUrl[] arg0, String arg1, boolean arg2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unlock(SVNUrl[] arg0, boolean arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void lock(File[] arg0, String arg1, boolean arg2) throws SVNClientException {
        throw new SVNClientException((Throwable)new UnsupportedOperationException("Not supported with commandline client."));
    }

    public void unlock(File[] arg0, boolean arg1) throws SVNClientException {
        throw new SVNClientException((Throwable)new UnsupportedOperationException("Not supported with commandline client."));
    }

    public boolean statusReturnsRemoteInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canCommitAcrossWC() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getAdminDirectoryName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAdminDirectory(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPasswordCallback(ISVNPromptUserPassword arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(File arg0, SVNRevision arg1, boolean arg2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cleanup(File file) throws SVNClientException {
        CleanupCommand cmd = new CleanupCommand(file);
        this.exec(cmd);
    }

    private void notifyChangedStatus(File file, boolean rec, ISVNStatus[] oldStatuses) throws SVNClientException {
        ISVNStatus[] newStatuses;
        HashMap<File, ISVNStatus> oldStatusMap = new HashMap<File, ISVNStatus>();
        for (ISVNStatus s : oldStatuses) {
            oldStatusMap.put(s.getFile(), s);
        }
        for (ISVNStatus newStatus : newStatuses = this.getStatus(file, rec, true)) {
            ISVNStatus oldStatus = (ISVNStatus)oldStatusMap.get(newStatus.getFile());
            if ((oldStatus != null || newStatus == null) && oldStatus.getTextStatus() == newStatus.getTextStatus() && oldStatus.getPropStatus() == newStatus.getPropStatus()) continue;
            this.notificationHandler.notifyListenersOfChange(newStatus.getPath());
        }
    }

    public ISVNDirEntryWithLock[] getListWithLocks(SVNUrl svnurl, SVNRevision svnr, SVNRevision svnr1, boolean bln) throws SVNClientException {
        return new ISVNDirEntryWithLock[0];
    }

    public void copy(SVNUrl svnurl, File file, SVNRevision svnr, SVNRevision svnr1, boolean bln, boolean bln1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long[] update(File[] files, SVNRevision svnr, int i, boolean bln, boolean bln1, boolean bln2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getLogMessages(File file, SVNRevision svnr, SVNRevision svnr1, SVNRevision svnr2, boolean bln, boolean bln1, long l, boolean bln2, String[] strings, ISVNLogMessageCallback i) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getLogMessages(SVNUrl svnurl, SVNRevision svnr, SVNRevision svnr1, SVNRevision svnr2, boolean bln, boolean bln1, long l, boolean bln2, String[] strings, ISVNLogMessageCallback i) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRevProperty(SVNUrl svnurl, SVNRevision.Number number, String string) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(SVNUrl svnurl, SVNRevision svnr, SVNRevision svnr1, SVNRevision svnr2, boolean bln, boolean bln1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(File file, SVNRevision svnr, SVNRevision svnr1, SVNRevision svnr2, boolean bln, boolean bln1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        return this.getProperties(url, revision, pegRevision, false);
    }

    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recursive) throws SVNClientException {
        ListPropertiesCommand cmd = new ListPropertiesCommand(url, revision.toString(), recursive);
        this.exec(cmd);
        List<String> names = cmd.getPropertyNames();
        ArrayList<ISVNProperty> props = new ArrayList<ISVNProperty>(names.size());
        for (String name : names) {
            ISVNProperty prop = this.propertyGet(url, name);
            if (prop == null) continue;
            props.add(prop);
        }
        return props.toArray(new ISVNProperty[0]);
    }

    public ISVNProperty[] getRevProperties(SVNUrl svnurl, SVNRevision.Number number) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNInfo[] getInfo(File file, boolean bln) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNDiffSummary[] diffSummarize(File file, SVNUrl svnurl, SVNRevision svnr, boolean bln) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus[] getStatus(File file, boolean bln, boolean bln1, boolean bln2, boolean bln3, ISVNStatusCallback isvnsc) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void propertySet(SVNUrl svnurl, SVNRevision.Number number, String string, String string1, String string2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getProperties(File file, boolean bln) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void upgrade(File wcRoot) throws SVNClientException {
        UpgradeCommand cmd = new UpgradeCommand(wcRoot);
        this.exec(cmd);
    }

    public void switchToUrl(File file, SVNUrl svnurl, SVNRevision svnr, SVNRevision svnr1, int i, boolean bln, boolean bln1, boolean bln2, boolean bln3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus[] getStatus(File file, boolean bln, boolean bln1, boolean bln2, boolean bln3, boolean bln4, ISVNStatusCallback isvnsc) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getPropertiesIncludingInherited(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getPropertiesIncludingInherited(File file, boolean bln, boolean bln1, List<String> list) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getPropertiesIncludingInherited(SVNUrl svnurl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getPropertiesIncludingInherited(SVNUrl svnurl, boolean bln, boolean bln1, List<String> list) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isThreadsafe() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addConflictResolutionCallback(ISVNConflictResolver arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setProgressListener(ISVNProgressListener arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void checkout(SVNUrl arg0, File arg1, SVNRevision arg2, int arg3, boolean arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, boolean arg3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(File arg0, SVNRevision arg1, SVNRevision arg2, boolean arg3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(File[] files, SVNUrl targetUrl, String message, boolean addAsChild, boolean makeParents) throws SVNClientException {
        for (File file : files) {
            CopyCommand cmd = new CopyCommand(file, targetUrl, message, makeParents);
            this.exec(cmd);
        }
    }

    public void copy(SVNUrl arg0, File arg1, SVNRevision arg2, boolean arg3, boolean arg4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev, boolean makeParents) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(fromUrl, toUrl, msg, rev, makeParents);
        this.exec(cmd);
    }

    public void copy(SVNUrl[] arg0, SVNUrl arg1, String arg2, SVNRevision arg3, boolean arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long update(File arg0, SVNRevision arg1, int arg2, boolean arg3, boolean arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, SVNRevision arg3, boolean arg4, boolean arg5, long arg6, boolean arg7) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getContent(SVNUrl url, SVNRevision rev, SVNRevision pegRevision) throws SVNClientException {
        CatCommand cmd = new CatCommand(url, rev, pegRevision);
        this.exec(cmd);
        return cmd.getOutput();
    }

    public void diff(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, SVNRevision arg3, File arg4, int arg5, boolean arg6, boolean arg7, boolean arg8) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, SVNRevision arg3, File arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, boolean arg3, boolean arg4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(File arg0, SVNRevision arg1, SVNRevision arg2, boolean arg3, boolean arg4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resolve(File arg0, int arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void switchToUrl(File arg0, SVNUrl arg1, SVNRevision arg2, int arg3, boolean arg4, boolean arg5, boolean arg6) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void switchToUrl(File arg0, SVNUrl arg1, SVNRevision arg2, SVNRevision arg3, int arg4, boolean arg5, boolean arg6, boolean arg7) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(SVNUrl arg0, SVNRevision arg1, SVNUrl arg2, SVNRevision arg3, File arg4, boolean arg5, int arg6, boolean arg7, boolean arg8, boolean arg9) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mergeReintegrate(SVNUrl arg0, SVNRevision arg1, File arg2, boolean arg3, boolean arg4) throws SVNClientException {
        throw new SVNClientException(SvnModuleConfig.getDefault().isForcedCommandlineClient() ? Bundle.MSG_Error_reintegrateBranchWithCLI_CLIforced() : Bundle.MSG_Error_reintegrateBranchWithCLI());
    }

    public void merge(SVNUrl arg0, SVNRevision arg1, SVNRevisionRange[] arg2, File arg3, boolean arg4, int arg5, boolean arg6, boolean arg7, boolean arg8) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNMergeInfo getMergeInfo(File arg0, SVNRevision arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNMergeInfo getMergeInfo(SVNUrl arg0, SVNRevision arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getMergeinfoLog(int arg0, File arg1, SVNRevision arg2, SVNUrl arg3, SVNRevision arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getMergeinfoLog(int arg0, SVNUrl arg1, SVNRevision arg2, SVNUrl arg3, SVNRevision arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl arg0, SVNRevision arg1, SVNUrl arg2, SVNRevision arg3, int arg4, boolean arg5) throws SVNClientException {
        throw new SVNClientException(SvnModuleConfig.getDefault().isForcedCommandlineClient() ? Bundle.MSG_Error_diffSummaryWithCLI_CLIforced() : Bundle.MSG_Error_diffSummaryWithCLI());
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2, SVNRevision arg3, int arg4, boolean arg5) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] suggestMergeSources(File arg0) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] suggestMergeSources(SVNUrl arg0, SVNRevision arg1) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dispose() {
    }

    class NotificationHandler
    extends SVNNotificationHandler {
        NotificationHandler() {
        }
    }
}

