/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi;

import java.util.Collection;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.osgi.ServiceBinding;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

final class BindingTracker<T>
extends ServiceTracker<T, ServiceBinding<T>> {
    private final Collection<BindingSubscriber<T>> subscribers = Weak.elements();
    private final String clazzName;
    private final int maxRank;
    private boolean isOpen;

    BindingTracker(BundleContext context, int maxRank, String clazzName) {
        super(context, clazzName, null);
        this.clazzName = clazzName;
        this.maxRank = maxRank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(BindingSubscriber<T> subscriber) {
        Collection<BindingSubscriber<T>> collection = this.subscribers;
        synchronized (collection) {
            this.openIfNecessary();
            for (ServiceBinding binding2 : this.getTracked().values()) {
                if (!binding2.isCompatibleWith(subscriber)) continue;
                subscriber.add(binding2, binding2.rank());
            }
            this.subscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(BindingSubscriber<T> subscriber) {
        Collection<BindingSubscriber<T>> collection = this.subscribers;
        synchronized (collection) {
            if (this.subscribers.remove(subscriber)) {
                for (ServiceBinding binding2 : this.getTracked().values()) {
                    subscriber.remove(binding2);
                }
            }
            this.closeIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceBinding<T> addingService(ServiceReference<T> reference) {
        ServiceBinding<T> binding2;
        try {
            binding2 = new ServiceBinding<T>(this.context, this.clazzName, this.maxRank, reference);
        }
        catch (Exception e2) {
            Logs.warn("Problem subscribing to service: {}", reference, e2);
            return null;
        }
        Collection<BindingSubscriber<T>> collection = this.subscribers;
        synchronized (collection) {
            for (BindingSubscriber<T> subscriber : this.subscribers) {
                if (!binding2.isCompatibleWith(subscriber)) continue;
                subscriber.add(binding2, binding2.rank());
            }
            this.closeIfNecessary();
        }
        return binding2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<T> reference, ServiceBinding<T> binding2) {
        Collection<BindingSubscriber<T>> collection = this.subscribers;
        synchronized (collection) {
            for (BindingSubscriber<T> subscriber : this.subscribers) {
                subscriber.remove(binding2);
            }
            this.closeIfNecessary();
        }
        super.removedService(reference, binding2);
    }

    private void openIfNecessary() {
        if (!this.isOpen) {
            this.open(true);
            Logs.trace("Started tracking services: {}", this.filter, null);
            this.isOpen = true;
        }
    }

    private void closeIfNecessary() {
        if (this.isOpen && this.subscribers.isEmpty()) {
            this.isOpen = false;
            Logs.trace("Stopped tracking services: {}", this.filter, null);
            this.close();
        }
    }
}

