﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/gameliftstreams/GameLiftStreams_EXPORTS.h>

namespace Aws {
namespace GameLiftStreams {
namespace Model {
enum class StreamClass {
  NOT_SET,
  gen4n_high,
  gen4n_ultra,
  gen4n_win2022,
  gen5n_high,
  gen5n_ultra,
  gen5n_win2022,
  gen6n_small,
  gen6n_medium,
  gen6n_high,
  gen6n_ultra,
  gen6n_ultra_win2022,
  gen6n_pro,
  gen6n_pro_win2022
};

namespace StreamClassMapper {
AWS_GAMELIFTSTREAMS_API StreamClass GetStreamClassForName(const Aws::String& name);

AWS_GAMELIFTSTREAMS_API Aws::String GetNameForStreamClass(StreamClass value);
}  // namespace StreamClassMapper
}  // namespace Model
}  // namespace GameLiftStreams
}  // namespace Aws
