/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void, VcsShortCommitDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    @NonNls
    private static final String USERS = "users";
    @NonNls
    private static final String USERS_IDS = "users-ids";
    @NotNull
    private final UserIndexer myUserIndexer;

    VcsLogUserIndex(@NotNull StorageId.Directory storageId, @NotNull UserIndexer userIndexer, @NotNull PersistentMapBasedForwardIndex forwardIndex, @Nullable StorageLockContext storageLockContext, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(0);
        }
        if (userIndexer == null) {
            VcsLogUserIndex.$$$reportNull$$$0(1);
        }
        if (forwardIndex == null) {
            VcsLogUserIndex.$$$reportNull$$$0(2);
        }
        if (errorHandler == null) {
            VcsLogUserIndex.$$$reportNull$$$0(3);
        }
        if (disposableParent == null) {
            VcsLogUserIndex.$$$reportNull$$$0(4);
        }
        super(VcsLogUserIndex.createMapReduceIndex(USERS, storageId, userIndexer, VoidDataExternalizer.INSTANCE, storageLockContext, (ForwardIndex)forwardIndex, new KeyCollectionForwardIndexAccessor((DataExternalizer)new IntCollectionDataExternalizer()), errorHandler), disposableParent);
        this.myUserIndexer = userIndexer;
    }

    @NotNull
    private static PersistentEnumerator<VcsUser> createUserEnumerator(@NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsUserRegistry userRegistry) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(5);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(6);
        }
        Path storageFile = storageId.getStorageFile(USERS_IDS);
        return new PersistentEnumerator(storageFile, (KeyDescriptor)new VcsUserKeyDescriptor(userRegistry), AbstractStorage.PAGE_SIZE, storageLockContext, storageId.getVersion());
    }

    @NotNull
    IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) throws IOException, StorageException {
        if (users == null) {
            VcsLogUserIndex.$$$reportNull$$$0(7);
        }
        IntOpenHashSet ids2 = new IntOpenHashSet();
        for (VcsUser vcsUser : users) {
            ids2.add(this.myUserIndexer.getUserId(vcsUser));
        }
        IntSet intSet = this.getCommitsWithAnyKey((IntSet)ids2);
        if (intSet == null) {
            VcsLogUserIndex.$$$reportNull$$$0(8);
        }
        return intSet;
    }

    @Nullable
    VcsUser getAuthorForCommit(int commitId) {
        try {
            Collection<Integer> userIds = this.getKeysForCommit(commitId);
            if (userIds == null || userIds.isEmpty()) {
                return null;
            }
            LOG.assertTrue(userIds.size() == 1);
            return this.myUserIndexer.getUserById(Objects.requireNonNull((Integer)ContainerUtil.getFirstItem(userIds)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    int getUserId(@NotNull VcsUser user2) {
        if (user2 == null) {
            VcsLogUserIndex.$$$reportNull$$$0(9);
        }
        try {
            return this.myUserIndexer.getUserId(user2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    VcsUser getUserById(int id) {
        try {
            return this.myUserIndexer.getUserById(id);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flush() throws StorageException, IOException {
        super.flush();
        this.myUserIndexer.flush();
    }

    @NotNull
    static VcsLogUserIndex create(@NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext, @NotNull VcsUserRegistry userRegistry, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(10);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(11);
        }
        if (errorHandler == null) {
            VcsLogUserIndex.$$$reportNull$$$0(12);
        }
        if (disposableParent == null) {
            VcsLogUserIndex.$$$reportNull$$$0(13);
        }
        Disposable disposable2 = Disposer.newDisposable((Disposable)disposableParent);
        try {
            PersistentMapBasedForwardIndex forwardIndex = new PersistentMapBasedForwardIndex(storageId.getStorageFile("users.idx"), true, false, storageLockContext);
            Disposer.register((Disposable)disposable2, () -> VcsLogUserIndex.catchAndWarn(LOG, (ThrowableRunnable<IOException>)((ThrowableRunnable)() -> ((PersistentMapBasedForwardIndex)forwardIndex).close())));
            PersistentEnumerator<VcsUser> userEnumerator = VcsLogUserIndex.createUserEnumerator(storageId, storageLockContext, userRegistry);
            Disposer.register((Disposable)disposable2, () -> VcsLogUserIndex.catchAndWarn(LOG, (ThrowableRunnable<IOException>)((ThrowableRunnable)() -> ((PersistentEnumerator)userEnumerator).close())));
            UserIndexer userIndexer = new UserIndexer(userEnumerator, e -> errorHandler.handleError(VcsLogErrorHandler.Source.Index, (Throwable)e));
            return new VcsLogUserIndex(storageId, userIndexer, forwardIndex, storageLockContext, errorHandler, disposable2);
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)disposable2);
            throw t;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = USERS;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsForUsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createUserEnumerator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsForUsers";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserId";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static final class UserIndexer
    implements DataIndexer<Integer, Void, VcsShortCommitDetails> {
        @NotNull
        private final PersistentEnumerator<VcsUser> myUserEnumerator;
        @NotNull
        private final Consumer<? super Exception> myFatalErrorConsumer;

        UserIndexer(@NotNull PersistentEnumerator<VcsUser> userEnumerator, @NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (userEnumerator == null) {
                UserIndexer.$$$reportNull$$$0(0);
            }
            if (fatalErrorConsumer == null) {
                UserIndexer.$$$reportNull$$$0(1);
            }
            this.myUserEnumerator = userEnumerator;
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsShortCommitDetails inputData) {
            if (inputData == null) {
                UserIndexer.$$$reportNull$$$0(2);
            }
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
            try {
                result.put(this.myUserEnumerator.enumerate((Object)inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.accept(e);
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = result;
            if (int2ObjectOpenHashMap == null) {
                UserIndexer.$$$reportNull$$$0(3);
            }
            return int2ObjectOpenHashMap;
        }

        @Nullable
        public VcsUser getUserById(int id) throws IOException {
            return (VcsUser)this.myUserEnumerator.valueOf(id);
        }

        public int getUserId(@NotNull VcsUser user2) throws IOException {
            if (user2 == null) {
                UserIndexer.$$$reportNull$$$0(4);
            }
            return this.myUserEnumerator.enumerate((Object)user2);
        }

        public void flush() {
            this.myUserEnumerator.force();
        }

        public void close() throws IOException {
            this.myUserEnumerator.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userEnumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserId";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

