/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;

public class GrFileStub
extends PsiFileStubImpl<GroovyFile> {
    private final String @NotNull [] myAnnotations;
    private final StringRef myName;
    private final boolean isScript;

    public GrFileStub(GroovyFile file) {
        super((PsiFile)file);
        this.myName = StringRef.fromString((String)file.getViewProvider().getVirtualFile().getNameWithoutExtension());
        this.isScript = file.isScript();
        GrPackageDefinition definition = file.getPackageDefinition();
        this.myAnnotations = definition != null ? GrStubUtils.getAnnotationNames(definition) : ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public GrFileStub(StringRef name, boolean isScript, String @NotNull [] annotations) {
        if (annotations == null) {
            GrFileStub.$$$reportNull$$$0(0);
        }
        super(null);
        this.myName = name;
        this.isScript = isScript;
        this.myAnnotations = annotations;
    }

    @NotNull
    public IStubFileElementType<?> getType() {
        IStubFileElementType iStubFileElementType = GroovyParserDefinition.GROOVY_FILE;
        if (iStubFileElementType == null) {
            GrFileStub.$$$reportNull$$$0(1);
        }
        return iStubFileElementType;
    }

    public StringRef getName() {
        return this.myName;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public String @NotNull [] getAnnotations() {
        if (this.myAnnotations == null) {
            GrFileStub.$$$reportNull$$$0(2);
        }
        return this.myAnnotations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

