/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanMetadata;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.document.ConsistencyChecker;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

class Gender {
    private static final String IMPERSONAL_PRONOUNS_MESSAGE = "Bevorzugen Sie geschlechtsneutrale Pronomen";
    private static final String MAN_CLAUSE_MESSAGE = "In manchen Stilen gilt \u201eman\u201c als informell, distanzierend oder nicht inklusiv; bevorzugen Sie konkrete Namen oder neutrale Formulierungen";
    private static final String JOB_TITLES_MESSAGE = "Die Pluralformen \u201e\u2026m\u00e4nner\u201c und \u201e\u2026frauen\u201c sind nicht geschlechtsneutral";
    private static final String GROUP_DESCRIPTION_MSG = "Bevorzugen Sie geschlechtsneutrale Schreibweisen";
    private static final String GENDER_RELATED_WORDS_MESSAGE = "Bevorzugen Sie geschlechtsneutrale Begriffe";
    private static final String NON_INCLUSIVE_JOB_DESCRIPTION_MESSAGE = "Verwenden Sie die inklusive Schreibweise \u201em/w/d\u201c in Stellenausschreibungen";
    private static final String GENDERN_STYLE_MESSAGE = "Verwenden Sie konsequent eine bestimmte geschlechtsneutrale Schreibweise";
    private static final String FALSE_GENDER_ENDING_MSG = "Dieses Wort ist geschlechtsneutral";
    static final String coordinatingConjunctions = "und|oder|/|sowie|plus|bzw|beziehungsweise|&";
    private static final NodePattern firstNameInNom = NodePattern.N.pos("EIG:NOM:SIN:.+:VOR");
    private static final NodePattern umlautFormationNonGenderNeutralPlural = NodePattern.N.form("(anw[\u00e4a]lt|\u00e4rzt|k\u00f6ch)en?");
    private static final NodePattern possibleGenderNeutralPtcpReplacement = NodePattern.N.form(".*(anwender|arbeiter|berater|besucher|bewerber|bewohner|einwohner|erzieher|fahrer|forscher|lehrer|leser|nutzer|pfleger|spieler|teilnehmer|mieter|zu(h\u00f6rer|schauer)|\u00fcbersetzer)n?");
    private static final NodePattern nonGenderNeutralPlural = NodePattern.or(NodePattern.N.form("kunden|(ingenieur|sekret\u00e4r|redakteur|friseur)en?|nachbarn"), NodePattern.N.formSuffix("((f|ph)otogra(f|ph)|administrator|aktivist|architekt|artist|assistent|autor|biolog|dozent|ethnolog|expert|jurist|kolleg|komponist|korrespondent|laborant|logop\u00e4d|meteorolog|philosoph|politolog|polizist|professor|p\u00e4dagog|restaurator|student|technolog|therapeut)en|(apotheker|betreuer|bildner|buchhalter|b\u00e4cker|b\u00fcrger|darsteller|designer|dolmetscher|elektroniker|entwickler|g\u00e4rtner|h\u00e4ndler|k\u00fcnstler|manager|mechaniker|physiker|politiker|priester|programmierer|sch\u00fcler|siedler|sportler|statistiker|s\u00e4nger|techniker|t\u00e4nzer|verk\u00e4ufer|wissenschaftler)n?"), umlautFormationNonGenderNeutralPlural, possibleGenderNeutralPtcpReplacement);
    private static final NodePattern noDet = NodePattern.N.noDependents("det(:poss)?");
    private static final NodePattern relativeClauseDependents = NodePattern.N.withDependent("acl", NodePattern.N.markAs("Relative clause head").andOr(NodePattern.N.withDependent("nsubj.*", NodePattern.N.lemma("der").markAs("Relative clause subject")), NodePattern.N.withDependent("obj", NodePattern.N.lemma("der").noDependents("case").markAs("Relative clause object")), NodePattern.N.withDependent("obl|iobj", NodePattern.N.lemma("der").withDependent("case").markAs("Relative clause prep object"))));
    private static final NodePattern looksLike3PlVerb = NodePattern.or(CommonPatterns.lowercasedHasPos("VER(:MOD)?:3:PLU.*"), NodePattern.N.noPos().form(".+en"));
    static final NodePattern isReallyPlural = CommonPatterns.skipConjUp(NodePattern.or(umlautFormationNonGenderNeutralPlural, AgreementSet.lexicallyPlural, NodePattern.N.withDependent("det(:poss)?", NodePattern.or(NodePattern.N.form("(all|viel|mehr|wenig|einig).*"), NodePattern.N.form(".+er").withHead(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nmod"))), NodePattern.N.form(".+en").withHead(CommonPatterns.skipConjUp(NodePattern.or(NodePattern.N.withDependent("case", Case.datPreposition), NodePattern.N.onlyPos(".*DAT:PLU.*").withDependent("case", Case.accDatPreposition), NodePattern.N.withHeadRelation("iobj")))), NodePattern.N.form(".+e").withHead(CommonPatterns.skipConjUp(NodePattern.or(NodePattern.N.withDependent("case", NodePattern.or(Case.accPreposition, Case.accDatPreposition)), NodePattern.N.withHeadRelation("obj|nsubj(:pass)?").noDependents("case"))))).noForm("(beid|jed).+")), NodePattern.or(NodePattern.N.noDependents("det(:poss)?"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.form("de(ss|r)en"))).andOr(NodePattern.N.form(".+rn"), NodePattern.N.withHead("nsubj(:pass)?", NodePattern.or(NodePattern.N.noDependents("aux(:pass)?|cop").and(looksLike3PlVerb), NodePattern.N.withDependent("aux(:pass)?|cop", looksLike3PlVerb))), NodePattern.N.withDependent("amod", NodePattern.N.form(".+er")).withHead("nmod", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")), NodePattern.N.noDependents("case").withDependent("amod", NodePattern.N.form(".+e"))))).andOr(NodePattern.N.noDependents("acl"), NodePattern.N.withDependent("acl", NodePattern.N.withDependent(".*", GermanTreePatterns.firstInPhraseAfterCommasOrConj.form("die|de[nr]en")))).andNot(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.form(".+e")).pos(".*SIN:FEM.*")).noDependents("det(:poss)?", NodePattern.or(NodePattern.N.pos("ART:IND.*"), NodePattern.N.onlyPos(".*SIN.*").noForm("dessen")));
    private static final NodePattern saenger = NodePattern.N.form(".*s\u00e4ngern?");
    private static final NodePattern taenzer = NodePattern.N.form(".*t\u00e4nzern?");
    private static final NodePattern verkaeufer = NodePattern.N.form(".*verk\u00e4ufern?");
    private static final NodePattern hyphenBefore = NodePattern.or(NodePattern.N.markAs("Head").withDependent("compound", NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE.directlyBefore("Head").noSpaceAfter())), NodePattern.N.withHead("flat", NodePattern.N.markAs("Head")).directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE.directlyAfter("Head").noSpaceAfter().noSpaceBefore()));
    private static final String genderEnding = "(in(nen)?|e?[rmns]|e)";
    private static final NodePattern threeTokenGendern = NodePattern.N.form("[:/]").noSpaceAround().directlyBefore(NodePattern.N.form("(in(nen)?|e?[rmns]|e)").markAs("EndNode")).directlyAfter(NodePattern.N.form("\\p{L}{3,}").markAs("StartNode"));
    static final NodePattern genderSymbolForm = NodePattern.N.form("\\p{L}{3,}[*_:/](in(nen)?|e?[rmns]|e)");
    private static final ConsistencyChecker<GermanParameters.GendernStyle> consistency = new ConsistencyChecker<GermanParameters.GendernStyle>(GermanParameters.GendernStyle.class, GermanMetadata.genderStyle){

        @Override
        @Nullable
        protected ConsistencyChecker.SingleFix correctStyle(GermanParameters.GendernStyle style, Node node) {
            boolean threeTokens = threeTokenGendern.matches(node);
            TextRange sentenceRange = new TextRange((threeTokens ? node.neighbor(-1) : node).startOffset(), (threeTokens ? node.neighbor(1) : node).endOffset());
            String replacement = Gender.forceGendernStyle(style.name(), sentenceRange.substring(node.tree().text()));
            TextRange globalRange = sentenceRange.shiftRight(node.tree().startOffset());
            return replacement == null ? null : new ConsistencyChecker.SingleFix(TextChange.replace(globalRange, replacement), List.of(globalRange), List.of(globalRange), List.of(Gender.changeGenderStyle()));
        }

        @Override
        protected String quickFixMessage(GermanParameters.GendernStyle style) {
            return style.displayName + " \u00fcberall verwenden";
        }
    };

    Gender() {
    }

    private static String replaceAmbiguousNode(Node node) {
        return switch (node.lowForm()) {
            case "er", "ihn" -> "sie";
            case "ihm" -> "ihnen";
            default -> node.lowForm().replaceFirst("sein(e[mnrs]?)?", "ihr$1");
        };
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.IMPERSONAL_PRONOUNS", "Inklusive Anwendung von geschlechtsbezogenen Indefinitpronomen", "Verwenden Sie Indefinitpronomen, die keine Hinweise auf das Geschlecht geben.", "https://www.wien.gv.at/medien/service/medienarbeit/richtlinien/leitfaden-gender/praxis-beispiele.html", () -> Gender.impersonalPronouns(), new Example("<b>Keiner</b> kann etwas daf\u00fcr.", "<b>Niemand</b> kann etwas daf\u00fcr.")).styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.MAN_CLAUSES", "Anwendung von man-Indefinitpronomen", "Vermeiden Sie das nicht geschlechtergerechte Indefinitpronomen \u201eman\u201c.", "https://www.wien.gv.at/medien/service/medienarbeit/richtlinien/leitfaden-gender/praxis-beispiele.html", () -> Gender.manSentences(), new Example("<b>Man</b> sollte \u00fcberlegen, ob das neue Ger\u00e4t wirklich ben\u00f6tigt wird.", new String[0])).disableByDefault().styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.FALSE_GENDER_ENDING", "Falsche Anwendung von geschlechtergerechter Sprache", "Geschlechtsneutrale W\u00f6rter brauchen keine weibliche Endung.", "https://www.duden.de/rechtschreibung/Erstsemester", () -> Gender.falseGenderEnding(), new Example("<b>Die Erstsemesterin</b> war h\u00fcbsch.", "<b>Das Erstsemester</b> war h\u00fcbsch.")).styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.GROUP_DESCRIPTIONS", "Geschlechtsbezogene Berufs- oder Gruppenbezeichnungen", "Verwenden Sie geschlechtsneutrale Berufs- und Gruppenbezeichnungen.", "https://www.duden.de/rechtschreibung/Kaufmann", () -> Gender.groupDescriptions(), new Example("Viele <b>Feuerwehrm\u00e4nner</b> waren im Einsatz.", "Viele <b>Feuerwehrleute</b> waren im Einsatz."), new Example("Morgen kommen die <b>Putzfrauen</b>.", "Morgen kommen die <b>Reinigungskr\u00e4fte</b>."), new Example("Alle <b>Besucher</b> haben Folgendes zu beachten.", "Alle <b>Besuchenden</b> haben Folgendes zu beachten.")).disableByDefault().styleFlavor(StyleFlavor.Inclusivity).coveringLTRules("MAENNER_VS_LEUTE", "PUTZFRAU"), new DocumentRule.PatternRule("Style.GENDERN_STYLE", "Einheitliche Verwendung von geschlechtsneutralen Formen", "Verwenden Sie die Genderschreibweise konsequent.\nDas Gendersternchen betont Geschlechtervielfalt.\nF\u00fcr Screenreader ist der Doppelpunkt am besten geeignet.\nUnabh\u00e4ngig davon, f\u00fcr welche Schreibweise Sie sich entscheiden, sollten Sie ihn durchg\u00e4ngig anwenden.\n", "https://www.duden.de/sprachwissen/sprachratgeber/Geschlechtergerechter-Sprachgebrauch", () -> Gender.gendernStyle(), new Example[]{new Example("Alle <b>BesucherInnen</b> haben Folgendes zu beachten. (Gendersternchen)", List.of("Alle <b>Besucher*innen</b> haben Folgendes zu beachten. (Gendersternchen)"), Map.of(GermanParameters.GENDERN_STYLE, "star")), new Example("Alle <b>Besucher*innen</b> haben Folgendes zu beachten. (Gender-Gap)", List.of("Alle <b>Besucher_innen</b> haben Folgendes zu beachten. (Gender-Gap)"), Map.of(GermanParameters.GENDERN_STYLE, "gap")), new Example("Alle <b>Besucher*innen</b> haben Folgendes zu beachten. (Doppelpunkt)", List.of("Alle <b>Besucher:innen</b> haben Folgendes zu beachten. (Doppelpunkt)"), Map.of(GermanParameters.GENDERN_STYLE, "colon")), new Example("Alle <b>Besucher*innen</b> haben Folgendes zu beachten. (Binnen-I)", List.of("Alle <b>BesucherInnen</b> haben Folgendes zu beachten. (Binnen-I)"), Map.of(GermanParameters.GENDERN_STYLE, "innerI")), new Example("Alle <b>Besucher*innen</b> haben Folgendes zu beachten. (Schr\u00e4gstrich)", List.of("Alle <b>Besucher/innen</b> haben Folgendes zu beachten. (Schr\u00e4gstrich)"), Map.of(GermanParameters.GENDERN_STYLE, "slash"))}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsMetadataBasedDocumentAnalysis();
            }

            @Override
            public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
                return MatchingResult.from(consistency.checkConsistency(sentences, this, Gender.GENDERN_STYLE_MESSAGE));
            }
        }.styleFlavor(StyleFlavor.Inclusivity).disableByDefault(), new Rule.PatternRule("Style.GENDER_RELATED_WORDS", "Anwendung von geschlechtsbezogenen W\u00f6rtern", "Verwenden Sie geschlechtsneutrale W\u00f6rter.", "https://www.duden.de/rechtschreibung/Maedchenname", () -> Gender.genderRelatedWords(), new Example("Das dauert gesch\u00e4tzt sechs <b>Mannstunden</b>.", "Das dauert gesch\u00e4tzt sechs <b>Personenstunden</b>."), new Example("Der <b>M\u00e4dchenname</b> meiner Stiefmutter ist M\u00fcller.", "Der <b>Geburtsname</b> meiner Stiefmutter ist M\u00fcller.")).styleFlavor(StyleFlavor.Inclusivity), new Rule.PatternRule("Style.NON_INCLUSIVE_JOB_DESCRIPTION", "Nicht inclusive Schreibweise", "Verwenden Sie inklusive Schreibweisen f\u00fcr Stellenangebote.", "https://de.wikipedia.org/wiki/Divers#Genderneutrale_Stellenausschreibung", () -> Gender.nonInclusiveDescription(), new Example("Wir suchen Zimmerer (<b>m/w</b>).", "Wir suchen Zimmerer (<b>m/w/d</b>).")).styleFlavor(StyleFlavor.Inclusivity));
    }

    private static NodePattern impersonalPronouns() {
        NodePattern possessivePronoun = NodePattern.N.form("sein(e[mnrs]?)?").andOr(NodePattern.N.withHeadRelation("det(:poss)?"), NodePattern.N.withDependent("det"));
        NodePattern possibleCoreferent = NodePattern.N.form("er|ih[mn]");
        NodePattern lonePronoun = NodePattern.not(NodePattern.N.withHeadRelation("det|nmod|amod|conj")).noDependents("nmod|case|cc|det|conj");
        NodePattern fixCase = NodePattern.custom((pronoun, match) -> {
            String form = pronoun.lowForm();
            String replacement = form.equals("keiner") ? "niemand" : (form.equals("keinem") ? "niemandem" : "niemanden");
            return match.withCorrector(NodeCorrector.replace(pronoun, replacement));
        });
        NodePattern fixCaseAndAgreement = NodePattern.custom((pronoun, match) -> {
            NodeCorrector basicCorrector;
            String replacement;
            String form = pronoun.lowForm();
            String string = replacement = form.equals("jedem") ? "allen" : "alle";
            Case caze = form.equals("jedem") ? Case.DAT : (form.equals("jeden") ? Case.AKK : Case.NOM);
            AgreementSet.InflectedForm pluralForm = new AgreementSet.InflectedForm(AgreementSet.Gender.MAS, AgreementSet.Number.PLU, caze, AdjDeclination.fromNPHead(pronoun), AgreementSet.Person.P3);
            AgreementSet pronounSet = AgreementSet.create(pronoun);
            if (pronounSet == null) {
                return null;
            }
            Map<Node, NodeCorrector> correctors = pronounSet.imposeFeatures(pluralForm, false);
            NodeCorrector facultativeCorrector = basicCorrector = NodeCorrector.replace(pronoun, replacement).join(NodeCorrector.joinAll(correctors.values()));
            Node head = pronoun.head();
            if (head != null) {
                List ambigousNodes = ((StreamEx)head.phraseStart().forward().filter(possessivePronoun::matches)).toList();
                for (Node ambigousNode : ambigousNodes) {
                    facultativeCorrector = facultativeCorrector.join(NodeCorrector.replace(ambigousNode, Gender.replaceAmbiguousNode(ambigousNode)));
                }
                Node scopeStart = StreamEx.of(head.findDependents("a(dv)?cl|parataxis|ccomp|ob[jl]|iobj|nsubj(:pass)?")).findFirst(dep -> dep.isAfter(pronoun)).orElse(null);
                if (scopeStart != null) {
                    ambigousNodes = ((StreamEx)((StreamEx)scopeStart.phraseStart().forward().takeWhile(node -> !lonePronoun.form("(kein|jed)e[rmn]").matches((Node)node) && node != head.phraseEnd())).filter(possibleCoreferent::matches)).toList();
                    for (Node ambigousNode : ambigousNodes) {
                        AgreementSet.InflectedForm pluralNomForm = new AgreementSet.InflectedForm(AgreementSet.Gender.MAS, AgreementSet.Number.PLU, Case.NOM, AdjDeclination.fromNPHead(ambigousNode), AgreementSet.Person.P3);
                        AgreementSet suspiciousNodeSet = AgreementSet.create(ambigousNode);
                        if (suspiciousNodeSet == null) {
                            return null;
                        }
                        Map<Node, NodeCorrector> correctorsAmbigNode = suspiciousNodeSet.imposeFeatures(pluralNomForm, false);
                        facultativeCorrector = facultativeCorrector.join(NodeCorrector.replace(ambigousNode, Gender.replaceAmbiguousNode(ambigousNode)).join(NodeCorrector.joinAll(correctorsAmbigNode.values())));
                    }
                }
            }
            return match.withCorrector(facultativeCorrector).withCorrector(basicCorrector);
        });
        return NodePattern.or(lonePronoun.form("keine[rmn]").and(fixCase), lonePronoun.form("jede[rmn]").and(fixCaseAndAgreement)).message(IMPERSONAL_PRONOUNS_MESSAGE);
    }

    private static NodePattern manSentences() {
        return NodePattern.N.form("man").withHeadRelation("nsubj.*").noDependents().message(MAN_CLAUSE_MESSAGE);
    }

    private static NodePattern falseGenderEnding() {
        NodePattern fixAgreement = NodePattern.custom((word, match) -> {
            Node relativeAntecedent;
            boolean singular = word.lowForm().endsWith("in");
            Node prep = GermanTreePatterns.findPreposition(word);
            boolean genitivePrep = Case.genPreposition.matches(prep);
            boolean genitive = word.hasHeadRelation("nmod") && (prep == null || genitivePrep);
            boolean dative = word.hasHeadRelation("iobj");
            String caseEnding = singular && genitive ? "s" : (!singular && dative ? "n" : "");
            String resultWord = word.form().replaceFirst("(?i)(.*)tsemester.*", "$1tsemester").replaceFirst("(?i)(mitglied)(er)?[*_:]?in(nen)?$", "$1" + (!singular ? "er" : ""));
            NodeCorrector resultCorrector = NodeCorrector.replace(word, resultWord + caseEnding);
            Node relativeSubj = match.findMarkedNode("Relative clause subject");
            Node relativeObj = match.findMarkedNode("Relative clause object");
            Node relativePrepObj = match.findMarkedNode("Relative clause prep object");
            Node determiner = match.findMarkedNode("Determiner");
            if (determiner != null) {
                String numStr;
                String form = determiner.lowForm();
                String string = numStr = singular ? "SIN" : "PLU";
                String caseStr = genitive ? "GEN" : (form.endsWith("e") ? "NOM" : "DAT");
                NodeCorrector detAgreement = NodeCorrector.inflect(determiner, "ART:(IND|DEF).*", "ART:$1:" + caseStr + ":" + numStr + ":NEU");
                resultCorrector = resultCorrector.join(detAgreement);
                if (form.equals("eine")) {
                    for (Node adj : word.findDependents("amod")) {
                        resultCorrector = resultCorrector.join(NodeCorrector.insertAfter(adj, "s"));
                    }
                }
            }
            Node node = relativeSubj != null ? relativeSubj : (relativeAntecedent = relativeObj != null ? relativeObj : relativePrepObj);
            if (relativeAntecedent != null) {
                String relAntecedentForm = relativeAntecedent.lowForm();
                String relReplacement = relativePrepObj != null ? (relAntecedentForm.equals("der") ? "dem" : "das") : (singular ? "das" : "die");
                NodeCorrector relativeClauseAgreement = NodeCorrector.replace(relativeAntecedent, relReplacement);
                resultCorrector = resultCorrector.join(relativeClauseAgreement);
            }
            return match.withCorrector(resultCorrector);
        });
        return NodePattern.or(NodePattern.N.form("(Ers|Zwei|Drit|Vier|F(\u00fc|ue)nf|Sechs|Sieben|Ach|Neun|Zehn|Elf|Zw(\u00f6|oe)lf)tsemester[*_]?in(nen)?"), NodePattern.N.form(".*mitglied(er)?[*_:]?in(nen)?")).andOptionally(relativeClauseDependents).andOptionally(NodePattern.N.withDependent("det", NodePattern.N.markAs("Determiner"))).andOr(NodePattern.N.inFormSequence(0, ".+", "und", ".+semester|.*mitglieder").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "")), NodePattern.N.inFormSequence(2, ".+semester|.*mitglieder", "und", ".+").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")), fixAgreement).message(FALSE_GENDER_ENDING_MSG);
    }

    private static NodeCorrector getPtcpGenderCorrector(Node node, String regexpBefore, String regexAfter) {
        return noDet.matches(node) ? NodeCorrector.regexReplace(node, "(.*)" + regexpBefore + "(n?)", "$1" + regexAfter + "$3") : NodeCorrector.regexReplace(node, "(.*)" + regexpBefore + "(n?)", "$1" + regexAfter + "n");
    }

    private static NodePattern groupDescriptions() {
        return NodePattern.or(NodePattern.or(NodePattern.N.form(".+m(\u00e4|ae)nner.*").noForm("(Hinter|Hampel)m\u00e4nner").noDependents("amod", NodePattern.N.form("beiden?")).noDependents("nummod").andNot(NodePattern.N.inFormSequence(0, ".*", coordinatingConjunctions, ".*frauen.*")).andNot(NodePattern.N.inFormSequence(0, ".*", coordinatingConjunctions, "-", "frauen.*")).andNot(NodePattern.N.inFormSequence(2, ".*frauen.*", coordinatingConjunctions, ".*")).andOptionally(NodePattern.N.form(".*fachm(\u00e4|ae)nnern?").correct(NodeCorrector.regexReplace("(.*f)achm(\u00e4|ae)nner(n?)", "$1achkr\u00e4fte$2"))).correct(NodeCorrector.regexReplace("m(\u00e4|ae)nner", "leute")), NodePattern.N.form("putzfrauen").andOr(NodePattern.N.withHeadRelation("iobj").correct(NodeCorrector.replace("Reinigungskr\u00e4ften")), NodePattern.N.correct(NodeCorrector.replace("Reinigungskr\u00e4fte")))).message(JOB_TITLES_MESSAGE), nonGenderNeutralPlural.and(CommonPatterns.skipUp("flat", CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|appos|vocative|root")))).noDependents("conj", NodePattern.N.form("\\p{L}+innen")).andNot(NodePattern.N.withHead("conj", NodePattern.N.form("\\p{L}+innen"))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj").form("\\p{L}+innen"))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("flat").form("\\p{L}+innen"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("[:/]").noSpaceAround())).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andOptionally(NodePattern.or(NodePattern.N.form(".*lehrern?").correct(NodeCorrector.regexReplace("(.*l)ehrer(n?)", "$1ehrkr\u00e4fte$2")), NodePattern.N.form(".*betreuern?").correct(NodeCorrector.regexReplace("(.*b)etreuer(n?)", "$1etreuungskr\u00e4fte$2")), NodePattern.N.form(".*arbeitern?").correct(NodeCorrector.regexReplace("(.*a)rbeiter(n?)", "Arbeitskr\u00e4fte$2")))).and((node, match) -> {
            String replacement;
            String root;
            if (!umlautFormationNonGenderNeutralPlural.matches(node)) {
                List<String> lemmas = node.lemmaReadings();
                if (lemmas.isEmpty()) {
                    return null;
                }
                String firstLemma = lemmas.get(0);
                root = firstLemma.endsWith("e") ? firstLemma.substring(0, firstLemma.length() - 1) : firstLemma;
            } else {
                root = node.form().replaceFirst("en?$", "");
            }
            String gendernParameter = GermanParameters.GENDERN_STYLE.getValue(node.tree());
            if (!gendernParameter.equals("innerI")) {
                String gendernSymbol = gendernParameter.equals("gap") ? "_" : (gendernParameter.equals("colon") ? ":" : (gendernParameter.equals("slash") ? "/" : "*"));
                replacement = root + gendernSymbol + "innen";
            } else {
                replacement = root + "Innen";
            }
            NodeCorrector ptcpCorrector = null;
            if (possibleGenderNeutralPtcpReplacement.matches(node)) {
                return match.withCorrector(Gender.getPtcpGenderCorrector(node, "(r)", "nde"));
            }
            if (saenger.matches(node)) {
                return match.withCorrector(Gender.getPtcpGenderCorrector(node, "(\u00e4nge)r", "ingende"));
            }
            if (taenzer.matches(node)) {
                return match.withCorrector(Gender.getPtcpGenderCorrector(node, "(\u00e4nze)r", "anzende"));
            }
            if (verkaeufer.matches(node)) {
                return match.withCorrector(Gender.getPtcpGenderCorrector(node, "(erk\u00e4ufe)r", "erkaufende"));
            }
            if (NodePattern.N.form("studenten").matches(node)) {
                return match.withCorrector(Gender.getPtcpGenderCorrector(node, "(enten)", "ierende"));
            }
            String optionalHyphen = hyphenBefore.matches(node) ? "-" : "";
            return match.withCorrector(ptcpCorrector).withCorrector(NodeCorrector.replace(node, replacement)).withCorrector(NodeCorrector.insertBefore(node, root + "innen und " + optionalHyphen)).withCorrector(NodeCorrector.insertAfter(node, " und " + optionalHyphen + root + "innen"));
        }).suggestActions(Gender.changeGenderStyle()).and(isReallyPlural).noDependents("det(:poss)?", NodePattern.N.form("beide.+")).noDependents("nummod", Capitalization.cardinal).noDependents("appos|flat(:name)?").noDependents("amod", NodePattern.N.lemma("wild")).noDependents("case", AdjDeclination.anyFusedPreposition).message(GROUP_DESCRIPTION_MSG));
    }

    private static NodePattern genderRelatedWords() {
        return NodePattern.or(NodePattern.N.form("M(\u00e4|ae)dchennamen?").pos(".*:SIN:.*").noDependents("det", NodePattern.N.pos(".*:IND:.*")).noDependents(NodePattern.or(firstNameInNom, CommonPatterns.capitalized.noPos())).withHead(NodePattern.not(firstNameInNom).andNot(CommonPatterns.capitalized.noPos()).noDependents(firstNameInNom)).correct(NodeCorrector.regexReplace("M(\u00e4|ae)dchen(.*)", "Geburts$2")), NodePattern.N.form("Mann(stunde|tage?|wochen?|monate?|jahre?)n?|Mann(tage?s|monats|jahre?s)").correct(NodeCorrector.regexReplace("Mann(.*)", "Personen$1")), NodePattern.N.form("putzfrau").andOr(NodePattern.N.withDependent("det(:poss)?"), NodePattern.N.withDependent("nmod", NodePattern.N.form("kein(e[mnsr]?)?")), NodePattern.N.withDependent("case", NodePattern.N.form("als|wie"))).correct(NodeCorrector.replace("Reinigungskraft"))).message(GENDER_RELATED_WORDS_MESSAGE);
    }

    private static NodePattern nonInclusiveDescription() {
        return NodePattern.N.inFormSequence(2, "m", "/", "w").reportEverythingTouched().andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("[xdia]"))).correct(NodeCorrector.insertAfter("/d")).message(NON_INCLUSIVE_JOB_DESCRIPTION_MESSAGE);
    }

    private static NodePattern gendernStyle() {
        return NodePattern.or(threeTokenGendern, genderSymbolForm, NodePattern.N.formCaseSensitive("\\p{L}\\p{Ll}{2,}(In(nen)?|E[RrMmNnSs]?|[RMNS])").noForm("LinkedIn")).andOr(GermanParameters.GENDERN_STYLE.withValue("consistently").andOr(NodePattern.N.form(".*:.*").and(consistency.record(GermanParameters.GendernStyle.colon)), NodePattern.N.form(".*/.*").and(consistency.record(GermanParameters.GendernStyle.slash)), NodePattern.N.form(".*\\*.*").and(consistency.record(GermanParameters.GendernStyle.star)), NodePattern.N.form(".*_.*").and(consistency.record(GermanParameters.GendernStyle.gap)), consistency.record(GermanParameters.GendernStyle.innerI)), GermanParameters.GENDERN_STYLE.withValue(".+").and((node, match) -> {
            Node startNode = Objects.requireNonNullElse(match.findMarkedNode("StartNode"), node);
            Node endNode = Objects.requireNonNullElse(match.findMarkedNode("EndNode"), node);
            String originalText = node.tree().text().substring(startNode.startOffset(), endNode.endOffset());
            String style = GermanParameters.GENDERN_STYLE.getValue(node.tree());
            String replacement = Gender.forceGendernStyle(style, originalText);
            if (replacement == null) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(startNode, endNode, replacement).batchCapable("Gendern_" + style)).enableAutoFix();
        }).message(GENDERN_STYLE_MESSAGE).suggestActions(Gender.changeGenderStyle()));
    }

    private static ActionSuggestion.ChangeParameter changeGenderStyle() {
        return new ActionSuggestion.ChangeParameter(GermanParameters.GENDERN_STYLE, null, "Geschlechtsspezifische Schreibweise konfigurieren");
    }

    @Nullable
    private static String forceGendernStyle(String style, String originalText) {
        Object replacement;
        if (!style.equals("innerI")) {
            String gendernSymbol = style.equals("gap") ? "_" : (style.equals("colon") ? ":" : (style.equals("slash") ? "/" : "*"));
            replacement = originalText.replaceFirst("[:*_/]", gendernSymbol).replaceFirst("In(nen)?$", gendernSymbol + "in$1").replaceFirst("E$", gendernSymbol + "e").replaceFirst("E[Rr]$", gendernSymbol + "er").replaceFirst("E[Mm]$", gendernSymbol + "em").replaceFirst("E[Nn]$", gendernSymbol + "en").replaceFirst("E[Ss]$", gendernSymbol + "es");
        } else {
            int i = StringUtils.indexOfAny((CharSequence)originalText, (String)":*_/");
            if (i <= 0) {
                return null;
            }
            String suffix = originalText.substring(i + 1);
            replacement = originalText.substring(0, i) + (String)(suffix.startsWith("i") ? "I" + suffix.substring(1) : suffix.toUpperCase(Locale.ROOT));
        }
        if (originalText.equals(replacement)) {
            return null;
        }
        return replacement;
    }
}

