/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.BufferIterator;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010*\n\u0002\b\u0005\b\u0000\u0018\u0000 )*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001)B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u001b\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016J\u0015\u0010!\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0016\u0010&\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010'J#\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "E", "Lkotlinx/collections/immutable/ImmutableList;", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "buffer", "", "", "<init>", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "size", "", "getSize", "()I", "bufferOfSize", "(I)[Ljava/lang/Object;", "add", "Lkotlinx/collections/immutable/PersistentList;", "element", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "addAll", "elements", "", "removeAll", "predicate", "Lkotlin/Function1;", "", "index", "c", "(ILjava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "removeAt", "builder", "Lkotlinx/collections/immutable/PersistentList$Builder;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "listIterator", "", "get", "(I)Ljava/lang/Object;", "set", "Companion", "kotlinx-collections-immutable"})
@SourceDebugExtension(value={"SMAP\nSmallPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,165:1\n41#2:166\n41#2:167\n*S KotlinDebug\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n*L\n49#1:166\n95#1:167\n*E\n"})
public final class SmallPersistentVector<E>
extends AbstractPersistentList<E>
implements ImmutableList<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object[] buffer;
    @NotNull
    private static final SmallPersistentVector EMPTY = new SmallPersistentVector(new Object[0]);

    public SmallPersistentVector(@NotNull Object[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        CommonFunctionsKt.assert(this.buffer.length <= 32);
    }

    public int getSize() {
        return this.buffer.length;
    }

    private final Object[] bufferOfSize(int size) {
        return new Object[size];
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        if (this.size() < 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[this.size()] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] tail = UtilsKt.presizedBufferWith(element);
        return new PersistentVector(this.buffer, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return this;
        }
        if (this.size() + elements.size() <= 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + elements.size());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            int index = this.size();
            for (E element : elements) {
                newBuffer[index++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder = $this$mutate$iv.builder();
        List it = builder;
        boolean bl = false;
        it.addAll(elements);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList persistentList;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int newSize = this.size();
        int removeMask = 0;
        int n = this.size();
        for (int index = 0; index < n; ++index) {
            Object element = this.buffer[index];
            if (!((Boolean)predicate.invoke(element)).booleanValue()) continue;
            --newSize;
            removeMask |= 1 << index;
        }
        int n2 = newSize;
        if (n2 == this.size()) {
            persistentList = this;
        } else if (n2 == 0) {
            persistentList = EMPTY;
        } else {
            Object[] objectArray = Arrays.copyOf(this.buffer, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            int newIndex = Integer.numberOfTrailingZeros(removeMask);
            int n3 = this.size();
            for (int index = newIndex + 1; index < n3; ++index) {
                if ((removeMask >>> index & 1) != 0) continue;
                newBuffer[newIndex++] = this.buffer[index];
            }
            persistentList = new SmallPersistentVector<E>(newBuffer);
        }
        return persistentList;
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(int index, @NotNull Collection<? extends E> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        if (c.isEmpty()) {
            return this;
        }
        if (this.size() + c.size() <= 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + c.size());
            ArraysKt.copyInto$default((Object[])this.buffer, (Object[])newBuffer, (int)0, (int)0, (int)index, (int)6, null);
            ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)(index + c.size()), (int)index, (int)this.size());
            int position = index;
            for (E element : c) {
                newBuffer[position++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder = $this$mutate$iv.builder();
        List it = builder;
        boolean bl = false;
        it.addAll(index, c);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index, E element) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        if (index == this.size()) {
            return this.add((Object)element);
        }
        if (this.size() < 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + 1);
            ArraysKt.copyInto$default((Object[])this.buffer, (Object[])newBuffer, (int)0, (int)0, (int)index, (int)6, null);
            ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)(index + 1), (int)index, (int)this.size());
            newBuffer[index] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] root = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])root, (int)(index + 1), (int)index, (int)(this.size() - 1));
        root[index] = element;
        Object[] tail = UtilsKt.presizedBufferWith(this.buffer[31]);
        return new PersistentVector(root, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        if (this.size() == 1) {
            return EMPTY;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)index, (int)(index + 1), (int)this.size());
        return new SmallPersistentVector<E>(newBuffer);
    }

    @Override
    @NotNull
    public PersistentList.Builder<E> builder() {
        return new PersistentVectorBuilder(this, null, this.buffer, 0);
    }

    @Override
    public int indexOf(Object element) {
        return ArraysKt.indexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return ArraysKt.lastIndexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        return new BufferIterator<Object>(this.buffer, index, this.size());
    }

    @Override
    public E get(int index) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        return (E)this.buffer[index];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index, E element) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[index] = element;
        return new SmallPersistentVector<E>(newBuffer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector$Companion;", "", "<init>", "()V", "EMPTY", "Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "", "getEMPTY", "()Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "kotlinx-collections-immutable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SmallPersistentVector getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

