/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import jakarta.enterprise.context.Conversation;
import jakarta.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.cdi.AutoConversation;
import org.apache.wicket.cdi.ConversationPropagator;
import org.apache.wicket.cdi.ConversationalComponent;
import org.apache.wicket.cdi.IConversationPropagation;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConversationManager
implements IComponentOnBeforeRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(AutoConversationManager.class);
    @Inject
    private Conversation conversation;
    @Inject
    private AutoConversation autoConversation;
    private IConversationPropagation propagation;

    public AutoConversationManager(IConversationPropagation propagation) {
        NonContextual.of(AutoConversationManager.class).inject(this);
        this.propagation = propagation;
    }

    public void onBeforeRender(Component component) {
        if (component instanceof Page) {
            Page page = (Page)component;
            IRequestHandler activeRequestHandler = page.getRequestCycle().getActiveRequestHandler();
            this.autoEndIfNecessary(page, activeRequestHandler);
            this.autoBeginIfNecessary(page, activeRequestHandler);
        }
    }

    protected void autoBeginIfNecessary(Page page, IRequestHandler handler) {
        if (!(this.conversation != null && this.conversation.isTransient() && page != null && this.hasConversationalComponent(page) && this.propagation.propagatesVia(handler, page))) {
            return;
        }
        this.conversation.begin();
        this.autoConversation.setAutomatic(true);
        logger.debug("Auto-began conversation '{}' for page '{}'", (Object)this.conversation.getId(), (Object)page);
    }

    protected void autoEndIfNecessary(Page page, IRequestHandler handler) {
        if (this.conversation == null || this.conversation.isTransient() || page == null || this.hasConversationalComponent(page) || !this.propagation.propagatesVia(handler, page) || !this.autoConversation.isAutomatic()) {
            return;
        }
        String cid = this.conversation.getId();
        this.autoConversation.setAutomatic(false);
        this.conversation.end();
        ConversationPropagator.removeConversationIdFromPage(page);
        logger.debug("Auto-ended conversation '{}' for page '{}'", (Object)cid, (Object)page);
    }

    protected boolean hasConversationalComponent(Page page) {
        Boolean hasConversational = (Boolean)Visits.visit((Iterable)page, (IVisitor)new IVisitor<Component, Boolean>(){

            public void component(Component object, IVisit<Boolean> visit) {
                if (object instanceof ConversationalComponent) {
                    visit.stop((Object)true);
                }
            }
        });
        return hasConversational == null ? false : hasConversational;
    }
}

