/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic;

import java.util.Map;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlList;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.SecuritySet;

public class DynamicAccessControlListImpl
implements DynamicAccessControlList {
    private static final long serialVersionUID = -5180551537096244085L;
    private Map<? extends Group, ? extends RoleSet> roleSets;
    private Map<? extends Role, ? extends PermissionSet> permissionSets;
    private GroupSet groupSet = new GroupSet();
    private RoleSet roleSet = new RoleSet();
    private PermissionSet permissionSet = new PermissionSet();

    public DynamicAccessControlListImpl(Map<? extends Group, ? extends RoleSet> roleSets, Map<? extends Role, ? extends PermissionSet> permissionSets) {
        this.roleSets = roleSets;
        this.permissionSets = permissionSets;
        for (Map.Entry<? extends Group, ? extends RoleSet> entry : roleSets.entrySet()) {
            Group group = entry.getKey();
            this.groupSet.add(group);
            RoleSet rs = entry.getValue();
            this.roleSet.add(rs);
        }
        for (Map.Entry<SecurityEntity, SecuritySet> entry : permissionSets.entrySet()) {
            Role role = (Role)entry.getKey();
            this.roleSet.add(role);
            PermissionSet ps = (PermissionSet)entry.getValue();
            this.permissionSet.add(ps);
        }
    }

    @Override
    public RoleSet getRoles(Group group) {
        if (group == null) {
            return null;
        }
        return this.roleSets.get(group);
    }

    @Override
    public RoleSet getRoles() {
        return this.roleSet;
    }

    @Override
    public PermissionSet getPermissions(Group group) {
        PermissionSet permissionSet = new PermissionSet();
        if (this.roleSets.containsKey(group)) {
            for (Role role : this.roleSets.get(group)) {
                if (!this.permissionSets.containsKey(role)) continue;
                permissionSet.add(this.permissionSets.get(role));
            }
        }
        return permissionSet;
    }

    @Override
    public PermissionSet getPermissions() {
        return this.permissionSet;
    }

    @Override
    public boolean hasRole(Role role, Group group) {
        RoleSet set = this.getRoles(group);
        if (set == null || role == null) {
            return false;
        }
        return set.contains(role);
    }

    @Override
    public boolean hasRole(Role role, GroupSet groupset) {
        if (role == null) {
            return false;
        }
        return groupset.stream().map(this::getRoles).anyMatch(roles -> roles != null && roles.contains(role));
    }

    @Override
    public boolean hasRole(String role, String group) {
        boolean roleFound = false;
        try {
            for (Map.Entry<? extends Group, ? extends RoleSet> entry : this.roleSets.entrySet()) {
                Group g = entry.getKey();
                if (!g.getName().equalsIgnoreCase(group)) continue;
                RoleSet rs = entry.getValue();
                roleFound = rs.containsName(role);
            }
        }
        catch (Exception e) {
            roleFound = false;
        }
        return roleFound;
    }

    @Override
    public boolean hasRole(String rolename, GroupSet groupset) {
        Role role;
        try {
            role = (Role)this.roleSet.getByName(rolename);
        }
        catch (Exception e) {
            return false;
        }
        if (role == null) {
            return false;
        }
        return groupset.stream().map(this::getRoles).anyMatch(roles -> roles != null && roles.contains(role));
    }

    @Override
    public boolean hasRole(Role role) {
        return this.roleSet.contains(role);
    }

    @Override
    public boolean hasRole(String role) {
        try {
            return this.roleSet.containsName(role);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(Permission permission, Group group) {
        PermissionSet set = this.getPermissions(group);
        if (set == null || permission == null) {
            return false;
        }
        return set.contains(permission);
    }

    @Override
    public boolean hasPermission(Permission permission, GroupSet groupset) {
        if (permission == null) {
            return false;
        }
        return groupset.stream().map(this::getPermissions).anyMatch(permissions -> permissions != null && permissions.contains(permission));
    }

    @Override
    public boolean hasPermission(String permission, String group) {
        try {
            return this.hasPermission((Permission)this.permissionSet.getByName(permission), (Group)this.groupSet.getByName(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(String permission, Group group) {
        try {
            return this.hasPermission((Permission)this.permissionSet.getByName(permission), group);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(String permissionName, GroupSet groupset) {
        Permission permission;
        try {
            permission = (Permission)this.permissionSet.getByName(permissionName);
        }
        catch (Exception e) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        return groupset.stream().map(this::getPermissions).anyMatch(permissions -> permissions != null && permissions.contains(permission));
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.permissionSet.contains(permission);
    }

    @Override
    public boolean hasPermission(String permission) {
        try {
            return this.permissionSet.containsName(permission);
        }
        catch (Exception e) {
            return false;
        }
    }
}

