/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

public class SecurityCheck {
    private String message;
    private String failScreen;
    private RunData data = null;
    private SecurityService securityService = null;
    private boolean initialize;

    public SecurityCheck(RunData data, String message, String failedScreen) {
        this(data, message, failedScreen, false);
    }

    public SecurityCheck(RunData data, String message, String failedScreen, boolean initialize) {
        this.data = data;
        this.message = message;
        this.failScreen = failedScreen;
        this.initialize = initialize;
        this.securityService = (SecurityService)TurbineServices.getInstance().getService(SecurityService.ROLE);
    }

    public boolean hasRole(Role role) throws Exception {
        boolean value = false;
        TurbineAccessControlList acl = (TurbineAccessControlList)this.data.getACL();
        if (acl == null || !acl.hasRole(role)) {
            this.data.setScreen(this.failScreen);
            this.data.setMessage(this.message);
        } else {
            value = true;
        }
        return value;
    }

    public boolean hasRole(String role) throws Exception {
        Role roleObject = null;
        try {
            roleObject = this.securityService.getRoleManager().getRoleByName(role);
        }
        catch (UnknownEntityException e) {
            if (this.initialize) {
                roleObject = this.securityService.getRoleManager().getRoleInstance(role);
                this.securityService.getRoleManager().addRole(roleObject);
                TurbineModelManager modelManager = (TurbineModelManager)this.securityService.getModelManager();
                if (this.data.getUser() == null) {
                    throw new UnknownEntityException("user is null");
                }
                modelManager.grant((User)this.data.getUser().getUserDelegate(), modelManager.getGlobalGroup(), roleObject);
            }
            throw e;
        }
        return this.hasRole(roleObject);
    }

    public boolean hasPermission(Permission permission) throws Exception {
        boolean value = false;
        TurbineAccessControlList acl = (TurbineAccessControlList)this.data.getACL();
        if (acl == null || !acl.hasPermission(permission)) {
            this.data.setScreen(this.failScreen);
            this.data.setMessage(this.message);
        } else {
            value = true;
        }
        return value;
    }

    public boolean hasPermission(String permission) throws Exception {
        Permission permissionObject = null;
        try {
            permissionObject = this.securityService.getPermissionManager().getPermissionByName(permission);
        }
        catch (UnknownEntityException e) {
            if (this.initialize) {
                permissionObject = this.securityService.getPermissionManager().getPermissionInstance(permission);
                this.securityService.getPermissionManager().addPermission(permissionObject);
                Role role = null;
                TurbineAccessControlList acl = (TurbineAccessControlList)this.data.getACL();
                RoleSet roles = acl.getRoles();
                if (roles.size() > 0) {
                    role = ((Role[])roles.toArray((Object[])new Role[0]))[0];
                }
                if (role == null && (roles = this.securityService.getRoleManager().getAllRoles()).size() > 0) {
                    role = ((Role[])roles.toArray((Object[])new Role[0]))[0];
                }
                if (role != null) {
                    TurbineModelManager modelManager = (TurbineModelManager)this.securityService.getModelManager();
                    modelManager.grant(role, permissionObject);
                }
            }
            throw e;
        }
        return this.hasPermission(permissionObject);
    }

    public String getMessage() {
        return this.message;
    }

    public String getFailScreen() {
        return this.failScreen;
    }
}

