/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.layouts;

import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class VelocityLayout
implements Layout {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected static final String prefix = "layouts/";
    @TurbineService
    protected VelocityService velocityService;

    @Override
    public void doBuild(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        Context context = this.velocityService.getContext(pipelineData);
        this.populateContext(pipelineData, context);
        String templateName = data.getTemplateInfo().getLayoutTemplate();
        data.getResponse().setLocale(data.getLocale());
        data.getResponse().setContentType(data.getContentType());
        this.log.debug("Now trying to render layout {}", (Object)templateName);
        this.render(pipelineData, context, templateName);
    }

    protected abstract void populateContext(PipelineData var1, Context var2) throws Exception;

    protected void render(PipelineData pipelineData, Context context, String templateName) throws Exception {
        this.velocityService.handleRequest(context, prefix + templateName, (OutputStream)pipelineData.get(Turbine.class, HttpServletResponse.class).getOutputStream());
    }
}

