/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope.pm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.syncope.BaseSyncopeSearchProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.impl.BasePasswordManagementService;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UriComponentsBuilder;

public class SyncopePasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopePasswordManagementService.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public SyncopePasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties, PasswordHistoryService passwordHistoryService) {
        super(casProperties, cipherExecutor, passwordHistoryService);
    }

    public boolean changeInternal(PasswordChangeRequest bean) {
        String url = this.determinePasswordResetUrl(bean);
        LOGGER.debug("Updating account password on Apache Syncope for user [{}]", (Object)bean.getUsername());
        return Splitter.on((String)",").splitToList((CharSequence)this.casProperties.getAuthn().getPm().getSyncope().getDomain()).stream().allMatch(domain -> {
            HttpExecutionRequest httpRequest = this.buildPasswordChangeHttpRequest(bean, url, (String)domain);
            HttpResponse response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)httpRequest));
            return HttpStatus.resolve((int)response.getCode()).is2xxSuccessful();
        });
    }

    public String findEmail(PasswordManagementQuery query) {
        return this.getUserAttribute(query, "email").orElseGet(() -> ((PasswordManagementQuery)query).getEmail());
    }

    public String findPhone(PasswordManagementQuery query) {
        return this.getUserAttribute(query, "phoneNumber").orElseGet(() -> ((PasswordManagementQuery)query).getEmail());
    }

    public String findUsername(PasswordManagementQuery query) {
        return this.getUserAttribute(query, "username").orElseGet(() -> ((PasswordManagementQuery)query).getEmail());
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) throws Throwable {
        String questionKey = this.searchUser(PasswordManagementQuery.builder().username(query.getUsername()).build()).stream().findFirst().map(syncopeUser -> syncopeUser.getOrDefault("securityQuestion", (List)syncopeUser.get("syncopeUserSecurityQuestion"))).filter(Objects::nonNull).filter(values -> !values.isEmpty()).map(values -> values.getFirst().toString()).orElseThrow();
        String securityQuestionUrl = Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.casProperties.getAuthn().getPm().getSyncope().getUrl()), (CharSequence)"/rest/securityQuestions/%s".formatted(questionKey), new CharSequence[0]);
        HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(securityQuestionUrl).basicAuthUsername(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthUsername()).basicAuthPassword(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthPassword()).headers(Map.of("X-Syncope-Domain", this.casProperties.getAuthn().getPm().getSyncope().getDomain(), "Accept", "application/json", "Content-Type", "application/json")).build();
        HttpResponse response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
        if (HttpStatus.resolve((int)response.getCode()).is2xxSuccessful() && response instanceof HttpEntityContainer) {
            HttpEntityContainer container = (HttpEntityContainer)response;
            HttpEntity entity = container.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            LOGGER.debug("Received security question entity as [{}]", (Object)result);
            return Map.of(MAPPER.readTree(result).get("content").asText(), UUID.randomUUID().toString());
        }
        return Map.of();
    }

    public boolean unlockAccount(Credential credential) throws Throwable {
        String userKey = this.fetchSyncopeUserKey(credential.getId());
        String userStatusUrl = Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.casProperties.getAuthn().getPm().getSyncope().getUrl()), (CharSequence)"/rest/users/%s/status".formatted(userKey), new CharSequence[0]);
        LOGGER.debug("Updating account status on Apache Syncope for user [{}]", (Object)credential.getId());
        HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(userStatusUrl).basicAuthUsername(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthUsername()).basicAuthPassword(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthPassword()).headers(Map.of("X-Syncope-Domain", this.casProperties.getAuthn().getPm().getSyncope().getDomain(), "Accept", "application/json", "Content-Type", "application/json")).entity(MAPPER.writeValueAsString((Object)SyncopePasswordManagementService.getUserStatusUpdatePatch(userKey))).maximumRetryAttempts(1).build();
        HttpResponse response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
        if (HttpStatus.resolve((int)response.getCode()).is2xxSuccessful()) {
            LOGGER.debug("Successfully updated the account status on Apache Syncope for [{}]", (Object)credential.getId());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnswerValidForSecurityQuestion(PasswordManagementQuery query, String question, String knownAnswer, String givenAnswer) {
        boolean bl;
        HttpResponse response = null;
        try {
            String userSecurityAnswerUrl = Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.casProperties.getAuthn().getPm().getSyncope().getUrl()), (CharSequence)"/rest/users/verifySecurityAnswer", new CharSequence[0]);
            LOGGER.debug("Checking security answer validity for user [{}]", (Object)query.getUsername());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(userSecurityAnswerUrl).basicAuthUsername(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthUsername()).basicAuthPassword(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthPassword()).headers(Map.of("X-Syncope-Domain", this.casProperties.getAuthn().getPm().getSyncope().getDomain(), "Accept", "application/json", "Content-Type", "application/json")).parameters(Map.of("username", query.getUsername())).entity(givenAnswer).maximumRetryAttempts(this.casProperties.getAuthn().getSyncope().getMaxRetryAttempts()).build();
            response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
            bl = HttpStatus.resolve((int)response.getCode()).is2xxSuccessful();
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
        return bl;
    }

    protected String fetchSyncopeUserKey(String username) {
        PasswordManagementQuery query = PasswordManagementQuery.builder().username(username).build();
        return this.searchUser(query).stream().findFirst().map(syncopeUser -> syncopeUser.getOrDefault("key", (List)syncopeUser.get("syncopeUserKey"))).filter(Objects::nonNull).filter(values -> !values.isEmpty()).map(values -> values.getFirst().toString()).orElseThrow(() -> new IllegalArgumentException("No user or its key can be found for username: " + username));
    }

    protected Optional<String> getUserAttribute(PasswordManagementQuery query, String attributeName) {
        return this.searchUser(query).stream().findFirst().map(syncopeUser -> {
            String prefix = "%s_%s".formatted("syncopeUserAttr", attributeName);
            return syncopeUser.getOrDefault(attributeName, (List)syncopeUser.get(prefix));
        }).filter(Objects::nonNull).filter(values -> !values.isEmpty()).map(values -> values.getFirst().toString());
    }

    protected List<Map<String, List<Object>>> searchUser(PasswordManagementQuery query) {
        return SyncopeUtils.syncopeUserSearch((BaseSyncopeSearchProperties)this.casProperties.getAuthn().getPm().getSyncope(), query.getUsername());
    }

    protected static JsonNode getPasswordPatch(PasswordChangeRequest bean) {
        ObjectNode passwordPatch = MAPPER.createObjectNode();
        passwordPatch.put("operation", "ADD_REPLACE");
        passwordPatch.put("value", bean.toConfirmedPassword());
        passwordPatch.put("onSyncope", true);
        passwordPatch.set("resources", (JsonNode)MAPPER.createArrayNode());
        return passwordPatch;
    }

    protected static JsonNode getUserPasswordUpdateRequest(PasswordChangeRequest bean, String userKey) {
        ObjectNode userPatch = MAPPER.createObjectNode();
        userPatch.put("_class", "org.apache.syncope.common.lib.request.UserUR");
        userPatch.put("key", userKey);
        userPatch.set("password", SyncopePasswordManagementService.getPasswordPatch(bean));
        return userPatch;
    }

    protected static JsonNode getUserStatusUpdatePatch(String userKey) {
        ObjectNode passwordPatch = MAPPER.createObjectNode();
        passwordPatch.put("operation", "ADD_REPLACE");
        passwordPatch.put("key", userKey);
        passwordPatch.put("type", "REACTIVATE");
        passwordPatch.put("onSyncope", true);
        passwordPatch.set("resources", (JsonNode)MAPPER.createArrayNode());
        return passwordPatch;
    }

    protected HttpExecutionRequest buildPasswordChangeHttpRequest(PasswordChangeRequest bean, String url, String domain) {
        return (HttpExecutionRequest)FunctionUtils.doUnchecked(() -> {
            LOGGER.debug("Changing password for user [{}] via [{}]", (Object)bean.getUsername(), (Object)url);
            if (StringUtils.isBlank((CharSequence)bean.toCurrentPassword())) {
                String userKey = (String)UriComponentsBuilder.fromUriString((String)url).build().getPathSegments().getLast();
                return HttpExecutionRequest.builder().method(HttpMethod.PATCH).url(url).basicAuthUsername(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthUsername()).basicAuthPassword(this.casProperties.getAuthn().getPm().getSyncope().getBasicAuthPassword()).headers(Map.of("X-Syncope-Domain", domain, "Accept", "application/json", "Content-Type", "application/json")).entity(MAPPER.writeValueAsString((Object)SyncopePasswordManagementService.getUserPasswordUpdateRequest(bean, userKey))).maximumRetryAttempts(1).build();
            }
            return HttpExecutionRequest.builder().method(HttpMethod.POST).url(url).basicAuthUsername(bean.getUsername()).basicAuthPassword(bean.toCurrentPassword()).headers(Map.of("X-Syncope-Domain", domain, "Accept", "application/json", "Content-Type", "application/json")).entity(MAPPER.writeValueAsString((Object)SyncopePasswordManagementService.getPasswordPatch(bean))).maximumRetryAttempts(1).build();
        });
    }

    private String determinePasswordResetUrl(PasswordChangeRequest bean) {
        String currentPassword = bean.toCurrentPassword();
        if (StringUtils.isBlank((CharSequence)currentPassword)) {
            String userKey = this.fetchSyncopeUserKey(bean.getUsername());
            return Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.casProperties.getAuthn().getPm().getSyncope().getUrl()), (CharSequence)"/rest/users/%s".formatted(userKey), new CharSequence[0]);
        }
        return Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.casProperties.getAuthn().getPm().getSyncope().getUrl()), (CharSequence)"/rest/users/self/mustChangePassword", new CharSequence[0]);
    }
}

