/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

@Monitorable
public class SyncopeAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeAuthenticationHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final SyncopeAuthenticationProperties properties;
    private final String syncopeDomain;

    public SyncopeAuthenticationHandler(SyncopeAuthenticationProperties properties, PrincipalFactory principalFactory, String syncopeDomain) {
        super(properties.getName(), principalFactory, Integer.valueOf(properties.getOrder()));
        this.properties = properties;
        this.syncopeDomain = syncopeDomain;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws Throwable {
        Optional<JsonNode> result = this.authenticateSyncopeUser(credential);
        if (result.isPresent()) {
            JsonNode user = result.get();
            LOGGER.debug("Received user object as [{}]", (Object)user);
            if (user.has("suspended") && user.get("suspended").asBoolean()) {
                throw new AccountDisabledException("Could not authenticate forbidden account for " + credential.getUsername());
            }
            if (user.has("mustChangePassword") && user.get("mustChangePassword").asBoolean()) {
                throw new AccountPasswordMustChangeException("Account password must change for " + credential.getUsername());
            }
            Map<String, List<Object>> principalAttributes = SyncopeUtils.convertFromUserEntity(user, this.properties.getAttributeMappings());
            String name = this.properties.getAttributeMappings().getOrDefault("domain", "syncopeDomain");
            principalAttributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{this.syncopeDomain}));
            Principal principal = this.principalFactory.createPrincipal(user.get("username").asText(), principalAttributes);
            return this.createHandlerResult((Credential)credential, principal, new ArrayList());
        }
        throw new FailedLoginException("Could not authenticate account for " + credential.getUsername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Optional<JsonNode> authenticateSyncopeUser(UsernamePasswordCredential credential) {
        block4: {
            block6: {
                block5: {
                    response = null;
                    try {
                        syncopeRestUrl = Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getUrl()), (CharSequence)"/rest/users/self", new CharSequence[0]);
                        exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(syncopeRestUrl).basicAuthUsername(credential.getUsername()).basicAuthPassword(credential.toPassword()).headers(CollectionUtils.wrap((String)"X-Syncope-Domain", (Object)this.syncopeDomain)).maximumRetryAttempts(this.properties.getMaxRetryAttempts()).build();
                        response = HttpUtils.execute((HttpExecutionRequest)exec);
                        if (response == null) break block4;
                        SyncopeAuthenticationHandler.LOGGER.debug("Received http response status as [{}]", (Object)response.getCode());
                        if (!response.containsHeader("X-Application-Error-Info") || response.getCode() != 403 && response.getCode() != 401) ** GOTO lbl37
                        appInfoHeader = response.getFirstHeader("X-Application-Error-Info").getValue();
                        if (!Strings.CI.equals("Please change your password first", appInfoHeader)) break block5;
                        user = SyncopeAuthenticationHandler.MAPPER.createObjectNode();
                        user.put("username", credential.getUsername());
                        user.put("mustChangePassword", true);
                        var7_9 = Optional.of(user);
                    }
                    catch (Throwable var9_12) {
                        HttpUtils.close(response);
                        throw var9_12;
                    }
                    HttpUtils.close((HttpResponse)response);
                    return var7_9;
                }
                expectedHeader = "User " + credential.getUsername() + " is suspended";
                if (!Strings.CI.equals(expectedHeader, appInfoHeader)) break block6;
                user = SyncopeAuthenticationHandler.MAPPER.createObjectNode();
                user.put("username", credential.getUsername());
                user.put("suspended", true);
                var8_11 = Optional.of(user);
                HttpUtils.close((HttpResponse)response);
                return var8_11;
            }
            break block4;
lbl37:
            // 1 sources

            if (response.getCode() != 200) break block4;
            var5_6 = SyncopeAuthenticationHandler.parseResponseResults((HttpEntityContainer)response);
            HttpUtils.close((HttpResponse)response);
            return var5_6;
        }
        HttpUtils.close((HttpResponse)response);
        return Optional.empty();
    }

    private static Optional<JsonNode> parseResponseResults(HttpEntityContainer response) {
        return (Optional)FunctionUtils.doUnchecked(() -> {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received user object as [{}]", (Object)result);
            return Optional.of(MAPPER.readTree(result));
        });
    }
}

