/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.core.authentication.passwordsync.LdapPasswordSynchronizationProperties;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.ldaptive.AttributeModification;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.ModifyResponse;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchResponse;
import org.ldaptive.ad.UnicodePwdAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPasswordSynchronizationAuthenticationPostProcessor
implements AuthenticationPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordSynchronizationAuthenticationPostProcessor.class);
    private final LdapConnectionFactory searchFactory;
    private final LdapPasswordSynchronizationProperties ldapProperties;

    public void destroy() {
        this.searchFactory.close();
    }

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws AuthenticationException {
        block6: {
            Optional primaryCredential = transaction.getPrimaryCredential();
            if (primaryCredential.isEmpty()) {
                LOGGER.warn("Current authentication transaction does not have a primary credential");
                return;
            }
            try {
                UsernamePasswordCredential credential = (UsernamePasswordCredential)primaryCredential.get();
                FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter(this.ldapProperties.getSearchFilter(), "user", List.of(credential.getUsername()));
                LOGGER.trace("Constructed LDAP filter [{}] to locate user and update password", (Object)filter);
                SearchResponse response = this.searchFactory.executeSearchOperation(this.ldapProperties.getBaseDn(), filter, this.ldapProperties.getPageSize());
                LOGGER.debug("LDAP response is [{}]", (Object)response);
                if (LdapUtils.containsResultEntry(response)) {
                    boolean result;
                    String dn = response.getEntry().getDn();
                    LOGGER.debug("Updating account password for [{}]", (Object)dn);
                    ModifyOperation operation = new ModifyOperation(this.searchFactory.getConnectionFactory());
                    AttributeModification mod = new AttributeModification(AttributeModification.Type.REPLACE, this.getLdapPasswordAttribute(credential));
                    ModifyResponse updateResponse = operation.execute(new ModifyRequest(dn, new AttributeModification[]{mod}));
                    LOGGER.trace("Result code [{}], message: [{}]", (Object)response.getResultCode(), (Object)response.getDiagnosticMessage());
                    boolean bl = result = updateResponse.getResultCode() == ResultCode.SUCCESS;
                    if (!result) {
                        String message = String.format("Could not update the LDAP entry's password for %s and base DN %s: %s", filter.format(), this.ldapProperties.getBaseDn(), updateResponse.getDiagnosticMessage());
                        throw new IllegalStateException(message);
                    }
                } else {
                    String message = String.format("Could not locate an LDAP entry for %s and base DN %s", filter.format(), this.ldapProperties.getBaseDn());
                    throw new IllegalStateException(message);
                }
                LOGGER.info("Updated the LDAP entry's password for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                if (!this.ldapProperties.isPasswordSynchronizationFailureFatal()) break block6;
                throw new AuthenticationException((Throwable)e);
            }
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    protected LdapAttribute getLdapPasswordAttribute(UsernamePasswordCredential credential) {
        if ("unicodePwd".equals(this.ldapProperties.getPasswordAttribute())) {
            return new UnicodePwdAttribute(new String[]{credential.toPassword()});
        }
        LdapAttribute attr = new LdapAttribute(this.ldapProperties.getPasswordAttribute());
        attr.addStringValues(new String[]{credential.toPassword()});
        return attr;
    }

    @Generated
    public LdapPasswordSynchronizationAuthenticationPostProcessor(LdapConnectionFactory searchFactory, LdapPasswordSynchronizationProperties ldapProperties) {
        this.searchFactory = searchFactory;
        this.ldapProperties = ldapProperties;
    }
}

