/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.util.CollectionUtils;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.RequestControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Monitorable
public class LdapAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationHandler.class);
    protected Map<String, Object> principalAttributeMap = new HashMap<String, Object>();
    private final Authenticator authenticator;
    private String principalIdAttribute;
    private boolean allowMultiplePrincipalAttributeValues;
    private boolean allowMissingPrincipalAttributeValue = true;
    private String[] authenticatedEntryAttributes = ReturnAttributes.NONE.value();
    private boolean collectDnAttribute;
    private String principalDnAttributeName = "principalLdapDn";

    public LdapAuthenticationHandler(String name, PrincipalFactory principalFactory, Integer order, Authenticator authenticator, AuthenticationPasswordPolicyHandlingStrategy strategy) {
        super(name, principalFactory, order);
        this.authenticator = authenticator;
        this.passwordPolicyHandlingStrategy = strategy;
    }

    public void destroy() {
        this.authenticator.close();
    }

    public void initialize() {
        HashSet<String> attributes = new HashSet<String>();
        LOGGER.debug("Initializing LDAP attribute configuration...");
        if (StringUtils.isNotBlank((CharSequence)this.principalIdAttribute)) {
            LOGGER.debug("Configured to retrieve principal id attribute [{}]", (Object)this.principalIdAttribute);
            attributes.add(this.principalIdAttribute);
        }
        if (this.principalAttributeMap != null && !this.principalAttributeMap.isEmpty()) {
            Set<String> attrs = this.principalAttributeMap.keySet();
            attributes.addAll(attrs);
            LOGGER.debug("Configured to retrieve principal attribute collection of [{}]", attrs);
        }
        this.authenticatedEntryAttributes = attributes.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        LOGGER.debug("LDAP authentication entry attributes for the authentication request are [{}]", (Object[])this.authenticatedEntryAttributes);
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential upc, String originalPassword) throws Throwable {
        AuthenticationResponse response = this.getLdapAuthenticationResponse(upc);
        LOGGER.debug("LDAP response: [{}]", (Object)response);
        if (!this.passwordPolicyHandlingStrategy.supports((Object)response)) {
            LOGGER.warn("Authentication has failed because LDAP password policy handling strategy [{}] cannot handle [{}].", (Object)response, (Object)this.passwordPolicyHandlingStrategy.getClass().getSimpleName());
            throw new FailedLoginException("Invalid credentials");
        }
        LOGGER.debug("Attempting to examine and handle LDAP password policy via [{}]", (Object)this.passwordPolicyHandlingStrategy.getClass().getSimpleName());
        List messageList = this.passwordPolicyHandlingStrategy.handle((Object)response, (Object)this.getPasswordPolicyConfiguration());
        if (response.isSuccess()) {
            LOGGER.debug("LDAP response returned a result [{}], creating the final LDAP principal", (Object)response.getLdapEntry());
            Principal principal = this.createPrincipal(upc.getUsername(), response.getLdapEntry());
            return this.createHandlerResult((Credential)upc, principal, messageList);
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            LOGGER.warn("DN resolution failed. [{}]", (Object)response.getDiagnosticMessage());
            throw new AccountNotFoundException(upc.getUsername() + " not found.");
        }
        throw new FailedLoginException("Invalid credentials");
    }

    protected Principal createPrincipal(String username, LdapEntry ldapEntry) throws Throwable {
        LOGGER.debug("Creating LDAP principal for [{}] based on [{}] and attributes [{}]", new Object[]{username, ldapEntry.getDn(), ldapEntry.getAttributeNames()});
        String id = this.getLdapPrincipalIdentifier(username, ldapEntry);
        LOGGER.debug("LDAP principal identifier created is [{}]", (Object)id);
        Map<String, List<Object>> attributeMap = this.collectAttributesForLdapEntry(ldapEntry, id);
        LOGGER.debug("Created LDAP principal for id [{}] and [{}] attributes", (Object)id, (Object)attributeMap.size());
        return this.principalFactory.createPrincipal(id, attributeMap);
    }

    protected Map<String, List<Object>> collectAttributesForLdapEntry(LdapEntry ldapEntry, String username) {
        HashMap<String, List<Object>> attributeMap = new HashMap<String, List<Object>>(this.principalAttributeMap.size());
        LOGGER.debug("The following attributes are requested to be retrieved and mapped: [{}]", attributeMap.keySet());
        this.principalAttributeMap.entrySet().stream().filter(entry -> !Strings.CI.equals((String)entry.getKey(), "*") && !Strings.CI.equals((String)entry.getKey(), "+")).forEach(entry -> {
            ArrayList attributeNames = (ArrayList)CollectionUtils.toCollection(entry.getValue(), ArrayList.class);
            if (attributeNames.size() == 1 && attributeNames.stream().allMatch(name -> !name.toString().isEmpty() && name.toString().charAt(name.toString().length() - 1) == ';')) {
                List<LdapAttribute> attrs = ldapEntry.getAttributes().stream().filter(attr -> attr.getName().startsWith(((String)entry.getKey()).concat(";"))).toList();
                attrs.forEach(attr -> attributeMap.putAll(LdapAuthenticationHandler.collectAttributeValueForEntry(ldapEntry, attr.getName(), List.of())));
            } else {
                attributeMap.putAll(LdapAuthenticationHandler.collectAttributeValueForEntry(ldapEntry, (String)entry.getKey(), attributeNames));
            }
        });
        if (this.collectDnAttribute) {
            LOGGER.debug("Recording principal DN attribute as [{}]", (Object)this.principalDnAttributeName);
            attributeMap.put(this.principalDnAttributeName, CollectionUtils.wrapList((Object[])new Object[]{ldapEntry.getDn()}));
        }
        return attributeMap;
    }

    protected String getLdapPrincipalIdentifier(String username, LdapEntry ldapEntry) throws LoginException {
        if (StringUtils.isNotBlank((CharSequence)this.principalIdAttribute)) {
            LdapAttribute principalAttr = ldapEntry.getAttribute(this.principalIdAttribute);
            if (principalAttr == null || principalAttr.size() == 0) {
                if (this.allowMissingPrincipalAttributeValue) {
                    LOGGER.warn("The principal id attribute [{}] is not found. CAS cannot construct the final authenticated principal if it's unable to locate the attribute that is designated as the principal id. Attributes available on the LDAP entry are [{}]. Since principal id attribute is not available, CAS will fall back to construct the principal based on the provided user id: [{}]", new Object[]{this.principalIdAttribute, ldapEntry.getAttributes(), username});
                    return username;
                }
                LOGGER.error("The principal id attribute [{}] is not found. CAS is configured to disallow missing principal attributes", (Object)this.principalIdAttribute);
                throw new LoginException("Principal id attribute is not found for " + String.valueOf(principalAttr));
            }
            String value = principalAttr.getStringValue();
            if (principalAttr.size() > 1) {
                if (!this.allowMultiplePrincipalAttributeValues) {
                    throw new LoginException("Multiple principal values are not allowed: " + String.valueOf(principalAttr));
                }
                LOGGER.warn("Found multiple values for principal id attribute: [{}]. Using first value=[{}].", (Object)principalAttr, (Object)value);
            }
            LOGGER.debug("Retrieved principal id attribute [{}]", (Object)value);
            return value;
        }
        LOGGER.debug("Principal id attribute is not defined. Using the default provided user id [{}]", (Object)username);
        return username;
    }

    private AuthenticationResponse getLdapAuthenticationResponse(UsernamePasswordCredential upc) throws PreventedException {
        try {
            LOGGER.debug("Attempting LDAP authentication for [{}]. Authenticator pre-configured attributes are [{}], additional requested attributes for this authentication request are [{}]", new Object[]{upc, this.authenticator.getReturnAttributes(), this.authenticatedEntryAttributes});
            org.ldaptive.Credential ldaptiveCred = new org.ldaptive.Credential(upc.getPassword());
            AuthenticationRequest request = new AuthenticationRequest(upc.getUsername(), ldaptiveCred, this.authenticatedEntryAttributes);
            request.setControls(new RequestControl[]{new PasswordPolicyControl()});
            return this.authenticator.authenticate(request);
        }
        catch (LdapException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            throw new PreventedException((Throwable)e);
        }
    }

    private static Map<String, List<Object>> collectAttributeValueForEntry(LdapEntry ldapEntry, String key, Collection<String> attributeNames) {
        HashMap<String, List<Object>> attributeMap = new HashMap<String, List<Object>>();
        LdapAttribute attr = ldapEntry.getAttribute(key);
        if (attr != null) {
            LOGGER.debug("Found principal attribute: [{}]", (Object)attr);
            if (attributeNames.isEmpty()) {
                LOGGER.debug("Principal attribute [{}] is collected as [{}]", (Object)attr, (Object)key);
                attributeMap.put(key, CollectionUtils.wrap((Object)attr.getStringValues()));
            } else {
                attributeNames.forEach(s -> {
                    LOGGER.debug("Principal attribute [{}] is virtually remapped/renamed to [{}]", (Object)attr, s);
                    attributeMap.put((String)s, CollectionUtils.wrap((Object)attr.getStringValues()));
                });
            }
        } else {
            LOGGER.warn("Requested LDAP attribute [{}] could not be found on LDAP entry for [{}]", (Object)key, (Object)ldapEntry.getDn());
        }
        return attributeMap;
    }

    @Generated
    public void setPrincipalAttributeMap(Map<String, Object> principalAttributeMap) {
        this.principalAttributeMap = principalAttributeMap;
    }

    @Generated
    public void setPrincipalIdAttribute(String principalIdAttribute) {
        this.principalIdAttribute = principalIdAttribute;
    }

    @Generated
    public void setAllowMultiplePrincipalAttributeValues(boolean allowMultiplePrincipalAttributeValues) {
        this.allowMultiplePrincipalAttributeValues = allowMultiplePrincipalAttributeValues;
    }

    @Generated
    public void setAllowMissingPrincipalAttributeValue(boolean allowMissingPrincipalAttributeValue) {
        this.allowMissingPrincipalAttributeValue = allowMissingPrincipalAttributeValue;
    }

    @Generated
    public void setAuthenticatedEntryAttributes(String[] authenticatedEntryAttributes) {
        this.authenticatedEntryAttributes = authenticatedEntryAttributes;
    }

    @Generated
    public void setCollectDnAttribute(boolean collectDnAttribute) {
        this.collectDnAttribute = collectDnAttribute;
    }

    @Generated
    public void setPrincipalDnAttributeName(String principalDnAttributeName) {
        this.principalDnAttributeName = principalDnAttributeName;
    }

    @Generated
    public Map<String, Object> getPrincipalAttributeMap() {
        return this.principalAttributeMap;
    }

    @Generated
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Generated
    public String getPrincipalIdAttribute() {
        return this.principalIdAttribute;
    }

    @Generated
    public boolean isAllowMultiplePrincipalAttributeValues() {
        return this.allowMultiplePrincipalAttributeValues;
    }

    @Generated
    public boolean isAllowMissingPrincipalAttributeValue() {
        return this.allowMissingPrincipalAttributeValue;
    }

    @Generated
    public String[] getAuthenticatedEntryAttributes() {
        return this.authenticatedEntryAttributes;
    }

    @Generated
    public boolean isCollectDnAttribute() {
        return this.collectDnAttribute;
    }

    @Generated
    public String getPrincipalDnAttributeName() {
        return this.principalDnAttributeName;
    }
}

