/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.beans.ExecQuery;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.common.rest.api.service.JAXRSService;

public interface ExecutableService
extends JAXRSService {
    @GET
    @Path(value="{key}/executions")
    @Produces(value={"application/json"})
    public PagedResult<ExecTO> listExecutions(@BeanParam ExecQuery var1);

    @GET
    @Path(value="executions/recent")
    @Produces(value={"application/json"})
    public List<ExecTO> listRecentExecutions(@Min(value=1L) @QueryParam(value="max") @DefaultValue(value="25") @Min(value=1L) int var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="executions/{executionKey}")
    @Produces(value={"application/json"})
    public void deleteExecution(@NotNull @PathParam(value="executionKey") String var1);

    @DELETE
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Batch results available, returned as Response entity")})
    @Path(value="{key}/executions")
    @Produces(value={"multipart/mixed"})
    public Response deleteExecutions(@BeanParam ExecQuery var1);

    @POST
    @Path(value="{key}/execute")
    @Produces(value={"application/json"})
    public ExecTO execute(@BeanParam ExecSpecs var1);

    @GET
    @Path(value="jobs/{key}")
    @Produces(value={"application/json"})
    public JobTO getJob(@PathParam(value="key") String var1);

    @GET
    @Path(value="jobs")
    @Produces(value={"application/json"})
    public List<JobTO> listJobs();

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="jobs/{key}")
    public void actionJob(@NotNull @PathParam(value="key") String var1, @QueryParam(value="action") JobAction var2);
}

