/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.to.PasswordManagementTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PasswordManagementDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.am.PasswordManagement;
import org.apache.syncope.core.provisioning.api.data.PasswordManagementDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class PasswordManagementLogic
extends AbstractTransactionalLogic<PasswordManagementTO> {
    protected final PasswordManagementDataBinder binder;
    protected final PasswordManagementDAO passwordManagementDAO;

    public PasswordManagementLogic(PasswordManagementDataBinder passwordManagementDataBinder, PasswordManagementDAO passwordManagementDAO) {
        this.binder = passwordManagementDataBinder;
        this.passwordManagementDAO = passwordManagementDAO;
    }

    @PreAuthorize(value="hasRole('PASSWORD_MANAGEMENT_CREATE')")
    public PasswordManagementTO create(PasswordManagementTO passwordManagementTO) {
        return this.binder.getPasswordManagementTO((PasswordManagement)this.passwordManagementDAO.save((Entity)this.binder.create(passwordManagementTO)));
    }

    @PreAuthorize(value="hasRole('PASSWORD_MANAGEMENT_UPDATE')")
    public PasswordManagementTO update(PasswordManagementTO passwordManagementTO) {
        PasswordManagement passwordManagement = (PasswordManagement)this.passwordManagementDAO.findById(passwordManagementTO.getKey()).orElseThrow(() -> new NotFoundException("PasswordManagement " + passwordManagementTO.getKey()));
        return this.binder.getPasswordManagementTO((PasswordManagement)this.passwordManagementDAO.save((Entity)this.binder.update(passwordManagement, passwordManagementTO)));
    }

    @PreAuthorize(value="hasRole('PASSWORD_MANAGEMENT_LIST') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<PasswordManagementTO> list() {
        return this.passwordManagementDAO.findAll().stream().map(arg_0 -> ((PasswordManagementDataBinder)this.binder).getPasswordManagementTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('PASSWORD_MANAGEMENT_READ')")
    @Transactional(readOnly=true)
    public PasswordManagementTO read(String key) {
        PasswordManagement passwordManagement = (PasswordManagement)this.passwordManagementDAO.findById(key).orElseThrow(() -> new NotFoundException("PasswordManagement " + key));
        return this.binder.getPasswordManagementTO(passwordManagement);
    }

    @PreAuthorize(value="hasRole('PASSWORD_MANAGEMENT_DELETE')")
    public PasswordManagementTO delete(String key) {
        PasswordManagement passwordManagement = (PasswordManagement)this.passwordManagementDAO.findById(key).orElseThrow(() -> new NotFoundException("PasswordManagement " + key));
        PasswordManagementTO deleted = this.binder.getPasswordManagementTO(passwordManagement);
        this.passwordManagementDAO.delete((Entity)passwordManagement);
        return deleted;
    }

    protected PasswordManagementTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key;
        if (ArrayUtils.isEmpty((Object[])args)) {
            throw new UnresolvedReferenceException();
        }
        Object object = args[0];
        if (object instanceof String) {
            String string;
            key = string = (String)object;
        } else {
            object = args[0];
            if (object instanceof AuthModuleTO) {
                AuthModuleTO authModuleTO = (AuthModuleTO)object;
                key = authModuleTO.getKey();
            } else {
                throw new UnresolvedReferenceException();
            }
        }
        try {
            return this.binder.getPasswordManagementTO((PasswordManagement)this.passwordManagementDAO.findById(key).orElseThrow());
        }
        catch (Throwable ignore) {
            LOG.debug("Unresolved reference", ignore);
            throw new UnresolvedReferenceException(ignore);
        }
    }
}

