/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.ActuatorEndpointProperties;
import org.apereo.cas.configuration.model.core.monitor.JaasSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.security.authentication.IpAddressAuthorizationManager;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.jaas.JaasAuthenticationProvider;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.www.BasicAuthenticationConverter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Order(value=1000)
public class CasWebSecurityConfigurerAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebSecurityConfigurerAdapter.class);
    private final ObjectPostProcessor<BasicAuthenticationFilter> basicAuthFilterPostProcessor = new ObjectPostProcessor<BasicAuthenticationFilter>(){

        public <O extends BasicAuthenticationFilter> O postProcess(O object) {
            final Set patternsToIgnore = CasWebSecurityConfigurerAdapter.this.getAllowedPatternsToIgnore().stream().map(url -> PathPatternRequestMatcher.withDefaults().matcher(url)).collect(Collectors.toSet());
            object.setAuthenticationConverter((AuthenticationConverter)new BasicAuthenticationConverter(this){

                public UsernamePasswordAuthenticationToken convert(HttpServletRequest request) {
                    boolean requestIsNotIgnored = patternsToIgnore.stream().noneMatch(requestMatcher -> requestMatcher.matches(request));
                    return requestIsNotIgnored ? super.convert(request) : null;
                }
            });
            return object;
        }
    };
    private final CasConfigurationProperties casProperties;
    private final WebEndpointProperties webEndpointProperties;
    private final ManagementServerProperties managementServerProperties;
    private final ObjectProvider<PathMappedEndpoints> pathMappedEndpoints;
    private final List<CasWebSecurityConfigurer> webSecurityConfigurers;
    private final SecurityContextRepository securityContextRepository;
    private final WebProperties webProperties;

    private static List<String> prepareProtocolEndpoint(String endpoint) {
        String baseEndpoint = Strings.CI.prependIfMissing(endpoint, (CharSequence)"/", new CharSequence[0]);
        return List.of(baseEndpoint.concat("**"), Strings.CI.appendIfMissing(endpoint, (CharSequence)"/", new CharSequence[0]).concat("**"));
    }

    private static void configureJaasAuthenticationProvider(HttpSecurity http, JaasSecurityActuatorEndpointsMonitorProperties jaas) throws Exception {
        JaasAuthenticationProvider provider = new JaasAuthenticationProvider();
        provider.setLoginConfig(jaas.getLoginConfig());
        provider.setLoginContextName(jaas.getLoginContextName());
        provider.setRefreshConfigurationOnStartup(jaas.isRefreshConfigurationOnStartup());
        provider.afterPropertiesSet();
        http.authenticationProvider((AuthenticationProvider)provider);
    }

    public void configureWebSecurity(WebSecurity web) {
    }

    public HttpSecurity configureHttpSecurity(HttpSecurity http, ApplicationContext applicationContext) throws Exception {
        http.cors(Customizer.withDefaults()).csrf(AbstractHttpConfigurer::disable).headers(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).redirectToHttps(https -> https.requestMatchers(new RequestMatcher[]{r -> r.getHeader("X-Forwarded-Proto") != null}));
        List<String> patterns = this.getAllowedPatternsToIgnore();
        LOGGER.debug("Configuring protocol endpoints [{}] to exclude/ignore from http security", patterns);
        HttpSecurity requests = http.authorizeHttpRequests(customizer -> {
            RequestMatcher[] matchers = patterns.stream().map(url -> PathPatternRequestMatcher.withDefaults().matcher(url)).toList().toArray(new RequestMatcher[0]);
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(matchers)).permitAll();
        });
        this.webSecurityConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(cfg -> cfg.configure((Object)http)));
        Map endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint();
        endpoints.forEach(Unchecked.biConsumer((key, endpointProps) -> {
            if (!Strings.CI.equals(key, "defaults")) {
                EndpointRequest.EndpointRequestMatcher endpoint = EndpointRequest.to((String[])new String[]{key});
                endpointProps.getAccess().forEach(Unchecked.consumer(access -> this.configureEndpointAccess(requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, (ActuatorEndpointProperties)endpointProps, endpoint)));
            }
        }));
        this.configureEndpointAccessToDenyUndefined(requests, applicationContext);
        this.configureEndpointAccessForStaticResources(requests);
        this.configureEndpointAccessByFormLogin(requests);
        JaasSecurityActuatorEndpointsMonitorProperties jaas = this.casProperties.getMonitor().getEndpoints().getJaas();
        FunctionUtils.doIfNotNull((Object)jaas.getLoginConfig(), __ -> CasWebSecurityConfigurerAdapter.configureJaasAuthenticationProvider(http, jaas));
        http.securityContext(securityContext -> securityContext.securityContextRepository(this.securityContextRepository));
        this.webSecurityConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(cfg -> cfg.finish((Object)http)));
        return http;
    }

    protected List<String> getAllowedPatternsToIgnore() {
        List<String> patterns = this.webSecurityConfigurers.stream().filter(BeanSupplier::isNotProxy).map(CasWebSecurityConfigurer::getIgnoredEndpoints).flatMap(Collection::stream).map(CasWebSecurityConfigurerAdapter::prepareProtocolEndpoint).flatMap(Collection::stream).collect(Collectors.toList());
        patterns.add("/webjars/**");
        patterns.add("/themes/**");
        patterns.add("/js/**");
        patterns.add("/css/**");
        patterns.add("/images/**");
        patterns.add("/static/**");
        patterns.add("/public/**");
        patterns.add("/error");
        patterns.add("/favicon.ico");
        patterns.add("/adminlogin");
        patterns.add("/");
        patterns.add(this.webEndpointProperties.getBasePath());
        FunctionUtils.doIfNotBlank((CharSequence)this.managementServerProperties.getBasePath(), patterns::add);
        patterns.addAll(this.casProperties.getMonitor().getEndpoints().getIgnoredEndpoints());
        return patterns;
    }

    protected void configureEndpointAccessToDenyUndefined(HttpSecurity http, ApplicationContext applicationContext) {
        Set endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint().keySet();
        PathMappedEndpoints mappedEndpoints = (PathMappedEndpoints)this.pathMappedEndpoints.getObject();
        mappedEndpoints.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(endpoint -> {
            String rootPath = endpoint.getRootPath();
            EndpointRequest.EndpointRequestMatcher endpointMatcher = EndpointRequest.to((String[])new String[]{rootPath}).excludingLinks();
            if (endpoints.contains(rootPath)) {
                LOGGER.trace("Endpoint security is defined for endpoint [{}]", (Object)rootPath);
            } else {
                String accessLevel = applicationContext.getEnvironment().getProperty("management.endpoint.%s.access".formatted(rootPath));
                if (StringUtils.isNotBlank((CharSequence)accessLevel)) {
                    Access access2 = Access.valueOf((String)accessLevel.toUpperCase(Locale.ENGLISH));
                    switch (access2) {
                        case UNRESTRICTED: 
                        case READ_ONLY: {
                            this.configureEndpointAccessPermitAll(http, endpointMatcher);
                            break;
                        }
                        case NONE: {
                            this.configureEndpointAccessToDenyAll(http, endpointMatcher);
                        }
                    }
                } else {
                    ActuatorEndpointProperties endpointDefaults = this.casProperties.getMonitor().getEndpoints().getDefaultEndpointProperties();
                    List defaultAccessRules = endpointDefaults.getAccess();
                    LOGGER.trace("Endpoint security is NOT defined for endpoint [{}]. Using default security rules [{}]", (Object)rootPath, (Object)endpointDefaults);
                    defaultAccessRules.forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, (ActuatorEndpointProperties.EndpointAccessLevel)access, endpointDefaults, endpointMatcher)));
                }
            }
        }));
    }

    protected void configureEndpointAccessForStaticResources(HttpSecurity requests) throws Exception {
        requests.authorizeHttpRequests(customizer -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/resources/**")})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/static/**")})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/public/**")})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/favicon**")})).permitAll();
            Arrays.stream(this.webProperties.getResources().getStaticLocations()).forEach(location -> {
                File file;
                if (location.startsWith("file:") && (file = new File(Strings.CI.remove(location, "file:"))).exists() && file.isDirectory()) {
                    List<File> directories = Arrays.stream(file.listFiles(File::isDirectory)).toList();
                    LOGGER.info("Directories to authorize for static public resources are [{}]", directories);
                    directories.forEach(directory -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/" + directory.getName() + "/**")})).permitAll());
                }
            });
        });
    }

    protected void configureEndpointAccessByFormLogin(HttpSecurity http) throws Exception {
        if (this.casProperties.getMonitor().getEndpoints().isFormLoginEnabled()) {
            http.formLogin(customize -> customize.loginPage("/adminlogin"));
        } else {
            http.formLogin(AbstractHttpConfigurer::disable);
        }
    }

    protected void configureEndpointAccess(HttpSecurity httpSecurity, ActuatorEndpointProperties.EndpointAccessLevel access, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        switch (access) {
            case AUTHORITY: {
                this.configureEndpointAccessByAuthority(httpSecurity, properties, endpoint);
                break;
            }
            case ROLE: {
                this.configureEndpointAccessByRole(httpSecurity, properties, endpoint);
                break;
            }
            case AUTHENTICATED: {
                this.configureEndpointAccessAuthenticated(httpSecurity, endpoint);
                break;
            }
            case IP_ADDRESS: {
                this.configureEndpointAccessByIpAddress(httpSecurity, properties, endpoint);
                break;
            }
            case PERMIT: {
                this.configureEndpointAccessPermitAll(httpSecurity, endpoint);
                break;
            }
            case ANONYMOUS: {
                this.configureEndpointAccessAnonymously(httpSecurity, endpoint);
                break;
            }
            default: {
                this.configureEndpointAccessToDenyAll(httpSecurity, endpoint);
            }
        }
    }

    protected void configureEndpointAccessPermitAll(HttpSecurity requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).permitAll());
    }

    protected void configureEndpointAccessToDenyAll(HttpSecurity requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).denyAll());
    }

    protected void configureEndpointAccessAnonymously(HttpSecurity requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).permitAll());
    }

    protected void configureEndpointAccessByIpAddress(HttpSecurity requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        requests.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).access((AuthorizationManager)new IpAddressAuthorizationManager(this.casProperties, properties)));
    }

    protected void configureEndpointAccessAuthenticated(HttpSecurity http, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).authenticated()).httpBasic(customizer -> customizer.addObjectPostProcessor(this.basicAuthFilterPostProcessor));
    }

    protected void configureEndpointAccessByRole(HttpSecurity http, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyRole(properties.getRequiredRoles().toArray(ArrayUtils.EMPTY_STRING_ARRAY))).httpBasic(customizer -> customizer.addObjectPostProcessor(this.basicAuthFilterPostProcessor));
    }

    protected void configureEndpointAccessByAuthority(HttpSecurity http, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyAuthority(properties.getRequiredAuthorities().toArray(ArrayUtils.EMPTY_STRING_ARRAY))).httpBasic(customizer -> customizer.addObjectPostProcessor(this.basicAuthFilterPostProcessor));
    }

    @Generated
    public CasWebSecurityConfigurerAdapter(CasConfigurationProperties casProperties, WebEndpointProperties webEndpointProperties, ManagementServerProperties managementServerProperties, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<CasWebSecurityConfigurer> webSecurityConfigurers, SecurityContextRepository securityContextRepository, WebProperties webProperties) {
        this.casProperties = casProperties;
        this.webEndpointProperties = webEndpointProperties;
        this.managementServerProperties = managementServerProperties;
        this.pathMappedEndpoints = pathMappedEndpoints;
        this.webSecurityConfigurers = webSecurityConfigurers;
        this.securityContextRepository = securityContextRepository;
        this.webProperties = webProperties;
    }
}

