/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.search.AnySelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.panels.search.UserSelectionDirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Management
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 855618618337931784L;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private GroupRestClient groupRestClient;
    private final Pattern manager = Pattern.compile("\\[\\(\\d+\\)\\] .*");
    private final AnyWrapper<? extends AnyTO> wrapper;
    private final WebMarkupContainer managerContainer;
    private final GroupSearchPanel groupSearchPanel;
    private final Fragment groupSearchFragment;
    private final GroupSelectionDirectoryPanel groupDirectoryPanel;
    private final UserSearchPanel userSearchPanel;
    private final Fragment userSearchFragment;
    private final UserSelectionDirectoryPanel userDirectoryPanel;
    private final Model<Boolean> isGManager;

    public Management(final AnyWrapper<? extends AnyTO> anyWrapper, PageReference pageRef) {
        ActionPermissions permissions = new ActionPermissions();
        this.setMetaData(MetaDataRoleAuthorizationStrategy.ACTION_PERMISSIONS, (Serializable)permissions);
        permissions.authorize(RENDER, new Roles("USER_SEARCH"));
        this.setTitleModel((IModel)new ResourceModel("manager"));
        this.wrapper = anyWrapper;
        this.isGManager = Model.of((Serializable)Boolean.valueOf(((AnyTO)anyWrapper.getInnerObject()).getGManager() != null));
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.info).withOffStyle(BootstrapToggleConfig.Style.warning).withSize(BootstrapToggleConfig.Size.mini);
        this.add(new Component[]{new BootstrapToggle("management", (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = 6062041315055645807L;

            public Boolean getObject() {
                return (Boolean)Management.this.isGManager.getObject();
            }
        }, config){
            private static final long serialVersionUID = 2969634208049189343L;

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)AnyTypeKind.USER.name()));
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)AnyTypeKind.GROUP.name()));
            }

            protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = 18235445704320L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        Management.this.isGManager.setObject((Serializable)Boolean.valueOf((Boolean)Management.this.isGManager.getObject() == false));
                        if (((Boolean)Management.this.isGManager.getObject()).booleanValue()) {
                            Management.this.managerContainer.addOrReplace(new Component[]{Management.this.groupSearchFragment});
                            Management.this.groupDirectoryPanel.search(null, target);
                        } else {
                            Management.this.managerContainer.addOrReplace(new Component[]{Management.this.userSearchFragment});
                            Management.this.userDirectoryPanel.search(null, target);
                        }
                        target.add(new Component[]{Management.this.managerContainer});
                    }
                }});
                return checkBox;
            }
        }});
        this.managerContainer = new WebMarkupContainer("managerContainer");
        this.managerContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.managerContainer});
        this.groupSearchFragment = new Fragment("search", "groupSearchFragment", (MarkupContainer)this);
        this.groupSearchPanel = (GroupSearchPanel)((Object)new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(new ArrayList()), pageRef).required(false).enableSearch((IEventSink)this).build("groupsearch"));
        this.groupSearchFragment.add(new Component[]{this.groupSearchPanel.setRenderBodyOnly(true)});
        AnyTypeTO anyTypeTO = this.anyTypeRestClient.read(AnyTypeKind.GROUP.name());
        this.groupDirectoryPanel = (GroupSelectionDirectoryPanel)((Object)GroupSelectionDirectoryPanel.class.cast((Object)new GroupSelectionDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), this.groupRestClient, anyTypeTO.getKey(), pageRef).build("searchResult")));
        this.groupSearchFragment.add(new Component[]{this.groupDirectoryPanel});
        this.userSearchFragment = new Fragment("search", "userSearchFragment", (MarkupContainer)this);
        this.userSearchPanel = (UserSearchPanel)((Object)UserSearchPanel.class.cast(new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(new ArrayList()), pageRef).required(false).enableSearch((IEventSink)this).build("usersearch")));
        this.userSearchFragment.add(new Component[]{this.userSearchPanel.setRenderBodyOnly(true)});
        anyTypeTO = this.anyTypeRestClient.read(AnyTypeKind.USER.name());
        this.userDirectoryPanel = (UserSelectionDirectoryPanel)((Object)UserSelectionDirectoryPanel.class.cast((Object)new UserSelectionDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), this.userRestClient, anyTypeTO.getKey(), pageRef).build("searchResult")));
        this.userSearchFragment.add(new Component[]{this.userDirectoryPanel});
        if (((Boolean)this.isGManager.getObject()).booleanValue()) {
            this.managerContainer.add(new Component[]{this.groupSearchFragment});
        } else {
            this.managerContainer.add(new Component[]{this.userSearchFragment});
        }
        AjaxTextFieldPanel uManager = new AjaxTextFieldPanel("uManager", "uManager", (IModel)new PropertyModel<String>(this, (Object)anyWrapper.getInnerObject(), "uManager"){
            private static final long serialVersionUID = -3743432456095828573L;
            final /* synthetic */ Management this$0;
            {
                this.this$0 = this$0;
                super(modelObject, expression);
            }

            public String getObject() {
                if (((AnyTO)anyWrapper.getInnerObject()).getUManager() == null) {
                    return "";
                }
                UserTO userTO = (UserTO)this.this$0.userRestClient.read(((AnyTO)anyWrapper.getInnerObject()).getUManager());
                if (userTO == null) {
                    return "";
                }
                return String.format("[%s] %s", userTO.getKey(), userTO.getUsername());
            }

            public void setObject(String object) {
                if (StringUtils.isBlank((CharSequence)object)) {
                    ((AnyTO)anyWrapper.getInnerObject()).setUManager(null);
                } else {
                    Matcher matcher = this.this$0.manager.matcher(object);
                    if (matcher.matches()) {
                        ((AnyTO)anyWrapper.getInnerObject()).setUManager(matcher.group(1));
                    }
                }
            }
        }, false);
        uManager.setPlaceholder("uManager");
        uManager.hideLabel();
        uManager.setReadOnly(true).setOutputMarkupId(true);
        this.userSearchFragment.add(new Component[]{uManager});
        IndicatingAjaxLink<Void> uManagerReset = new IndicatingAjaxLink<Void>("uManagerReset"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)Management.this, Broadcast.EXACT, new AnySelectionDirectoryPanel.ItemSelection<Object>(target, null));
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        this.userSearchFragment.add(new Component[]{uManagerReset});
        AjaxTextFieldPanel gManager = new AjaxTextFieldPanel("gManager", "gManager", (IModel)new PropertyModel<String>(this, (Object)anyWrapper.getInnerObject(), "gManager"){
            private static final long serialVersionUID = -3743432456095828573L;
            final /* synthetic */ Management this$0;
            {
                this.this$0 = this$0;
                super(modelObject, expression);
            }

            public String getObject() {
                if (((AnyTO)anyWrapper.getInnerObject()).getGManager() == null) {
                    return "";
                }
                GroupTO groupTO = (GroupTO)this.this$0.groupRestClient.read(((AnyTO)anyWrapper.getInnerObject()).getGManager());
                if (groupTO == null) {
                    return "";
                }
                return String.format("[%s] %s", groupTO.getKey(), groupTO.getName());
            }

            public void setObject(String object) {
                if (StringUtils.isBlank((CharSequence)object)) {
                    ((AnyTO)anyWrapper.getInnerObject()).setGManager(null);
                } else {
                    Matcher matcher = this.this$0.manager.matcher(object);
                    if (matcher.matches()) {
                        ((AnyTO)anyWrapper.getInnerObject()).setGManager(matcher.group(1));
                    }
                }
            }
        }, false);
        gManager.setPlaceholder("gManager");
        gManager.hideLabel();
        gManager.setReadOnly(true).setOutputMarkupId(true);
        this.groupSearchFragment.add(new Component[]{gManager});
        IndicatingAjaxLink<Void> gManagerReset = new IndicatingAjaxLink<Void>("gManagerReset"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)Management.this, Broadcast.EXACT, new AnySelectionDirectoryPanel.ItemSelection<Object>(target, null));
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        this.groupSearchFragment.add(new Component[]{gManagerReset});
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof SearchClausePanel.SearchEvent) {
            SearchClausePanel.SearchEvent payload = (SearchClausePanel.SearchEvent)object;
            target = payload.getTarget();
            if (((Boolean)this.isGManager.getObject()).booleanValue()) {
                String fiql = SearchUtils.buildFIQL((List)this.groupSearchPanel.getModel().getObject(), SyncopeClient.getGroupSearchConditionBuilder());
                this.groupDirectoryPanel.search(fiql, (AjaxRequestTarget)target);
            } else {
                String fiql = SearchUtils.buildFIQL((List)this.userSearchPanel.getModel().getObject(), SyncopeClient.getUserSearchConditionBuilder());
                this.userDirectoryPanel.search(fiql, (AjaxRequestTarget)target);
            }
        } else {
            target = event.getPayload();
            if (target instanceof AnySelectionDirectoryPanel.ItemSelection) {
                AnySelectionDirectoryPanel.ItemSelection itemSelection = (AnySelectionDirectoryPanel.ItemSelection)target;
                Object sel = itemSelection.getSelection();
                if (sel == null) {
                    ((AnyTO)this.wrapper.getInnerObject()).setUManager(null);
                    ((AnyTO)this.wrapper.getInnerObject()).setGManager(null);
                } else if (sel instanceof UserTO) {
                    ((AnyTO)this.wrapper.getInnerObject()).setUManager(sel.getKey());
                    ((AnyTO)this.wrapper.getInnerObject()).setGManager(null);
                } else if (sel instanceof GroupTO) {
                    ((AnyTO)this.wrapper.getInnerObject()).setUManager(null);
                    ((AnyTO)this.wrapper.getInnerObject()).setGManager(sel.getKey());
                }
                itemSelection.getTarget().add(new Component[]{this.managerContainer});
            } else {
                super.onEvent(event);
            }
        }
    }

    public boolean evaluate() {
        return SyncopeWebApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
    }
}

