/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.junit;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import kafka.test.ClusterConfig;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.junit.ClusterTestExtensions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;

public class ClusterTestExtensionsUnitTest {
    static List<ClusterConfig> cfgEmpty() {
        return Collections.emptyList();
    }

    private ExtensionContext buildExtensionContext(String methodName) throws Exception {
        ExtensionContext extensionContext = (ExtensionContext)Mockito.mock(ExtensionContext.class);
        Class<ClusterTestExtensionsUnitTest> clazz = ClusterTestExtensionsUnitTest.class;
        Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
        Mockito.when((Object)extensionContext.getRequiredTestClass()).thenReturn(clazz);
        Mockito.when((Object)extensionContext.getRequiredTestMethod()).thenReturn((Object)method);
        return extensionContext;
    }

    @Test
    void testProcessClusterTemplate() throws Exception {
        ClusterTestExtensions ext = new ClusterTestExtensions();
        ExtensionContext context = this.buildExtensionContext("cfgEmpty");
        ClusterTemplate annot = (ClusterTemplate)Mockito.mock(ClusterTemplate.class);
        Mockito.when((Object)annot.value()).thenReturn((Object)"").thenReturn((Object)" ").thenReturn((Object)"cfgEmpty");
        Assertions.assertEquals((Object)"ClusterTemplate value can't be empty string.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ext.processClusterTemplate(context, annot))).getMessage());
        Assertions.assertEquals((Object)"ClusterTemplate value can't be empty string.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ext.processClusterTemplate(context, annot))).getMessage());
        Assertions.assertEquals((Object)"ClusterConfig generator method should provide at least one config", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ext.processClusterTemplate(context, annot))).getMessage());
    }
}

