/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.sync;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Uid;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.SingleConnectionFactory;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.SyncStateControl;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.DefaultCookieManager;
import org.ldaptive.control.util.SyncReplClient;
import org.ldaptive.extended.SyncInfoMessage;
import org.ldaptive.handler.ResultPredicate;

abstract class AbstractLdUpSyncOp {
    protected static final Log LOG = Log.getLog(AbstractLdUpSyncOp.class);
    protected final LdUpUtils ldUpUtils;

    protected AbstractLdUpSyncOp(LdUpUtils ldUpUtils) {
        this.ldUpUtils = ldUpUtils;
    }

    protected <T> List<T> dosync(ObjectClass objectClass, Function<ConnectorObjectBuilder, T> createOrUpdate, Function<ConnectorObjectBuilder, T> delete, BiConsumer<T, String> outCookieReporter, byte[] cookie, OperationOptions options) {
        ArrayList objects = new ArrayList();
        SingleConnectionFactory scf = new SingleConnectionFactory(this.ldUpUtils.getConnectionConfig());
        SyncReplClient client = new SyncReplClient((ConnectionFactory)scf, false);
        try {
            scf.initialize();
            client.setOnEntry(entry -> {
                LOG.ok("SyncRepl entry received: {0}", new Object[]{entry});
                SyncStateControl ssc = (SyncStateControl)entry.getControl("1.3.6.1.4.1.4203.1.9.1.2");
                switch (ssc.getSyncState()) {
                    case ADD: 
                    case MODIFY: {
                        objects.add(createOrUpdate.apply(this.ldUpUtils.connectorObjectBuilder(objectClass, new Uid(ssc.getEntryUuid().toString()), (LdapEntry)entry, options)));
                        break;
                    }
                    default: {
                        LOG.warn("Unsupported condition: SyncStateControl {0}", new Object[]{ssc});
                    }
                }
            });
            client.setOnMessage(message -> {
                LOG.ok("SyncRepl message received: {0}", new Object[]{message});
                if (message.getMessageType() == SyncInfoMessage.Type.SYNC_ID_SET) {
                    message.getEntryUuids().forEach(entryUUID -> {
                        try {
                            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((SearchRequest)SearchRequest.builder().dn(this.ldUpUtils.getConfiguration().getBaseDn()).scope(SearchScope.SUBTREE).filter("entryUUID=" + entryUUID.toString()).returnAttributes(ReturnAttributes.NONE.value()).build());
                            if (response.getEntries().isEmpty()) {
                                LOG.ok("No match while searching for entryUUID={0}: it was a DELETE", new Object[]{entryUUID});
                                ConnectorObjectBuilder object = new ConnectorObjectBuilder().setObjectClass(objectClass).setUid(new Uid(entryUUID.toString())).setName(entryUUID.toString());
                                objects.add(delete.apply(object));
                            } else {
                                LOG.ok("Match found while searching for entryUUID={0}: discard", new Object[]{entryUUID});
                            }
                        }
                        catch (LdapException e) {
                            LOG.warn((Throwable)e, "Error while searching for entryUUID={0}", new Object[]{entryUUID});
                        }
                    });
                }
            });
            client.setOnResult(result -> {
                LOG.ok("SyncRepl result received: {0}", new Object[]{result});
                SyncDoneControl syncDoneControl = (SyncDoneControl)result.getControl("1.3.6.1.4.1.4203.1.9.1.3");
                objects.forEach(object -> outCookieReporter.accept(object, Base64.getEncoder().encodeToString(syncDoneControl.getCookie())));
            });
            client.setOnException(e -> LOG.error((Throwable)e, "SyncRepl exception thrown", new Object[0]));
            SearchRequest.Builder searchRequestBuilder = SearchRequest.builder().dn(this.ldUpUtils.getConfiguration().getBaseDn()).scope(SearchScope.SUBTREE).filter("objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass));
            this.ldUpUtils.returnAttributes(options).ifPresent(arg_0 -> ((SearchRequest.Builder)searchRequestBuilder).returnAttributes(arg_0));
            DefaultCookieManager cookieManager = new DefaultCookieManager();
            Optional.ofNullable(cookie).ifPresent(arg_0 -> ((DefaultCookieManager)cookieManager).writeCookie(arg_0));
            client.send((SearchRequest)searchRequestBuilder.build(), (CookieManager)cookieManager).await();
        }
        catch (LdapException e2) {
            throw new ConnectorException("While managing SyncRepl events for " + objectClass, (Throwable)e2);
        }
        finally {
            client.close();
            scf.close();
        }
        return objects;
    }
}

