/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.controller.KafkaController;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteLogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.StopPartition;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u0007\u000f\u0001MA\u0001\u0002\n\u0001\u0003\u0006\u0004%I!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005M!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0011!q\u0004A!A!\u0002\u0013\u0001\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b%\u0003A\u0011\u0001&\t\u000bA\u0003A\u0011B)\t\r%\u0004A\u0011\u0001\bk\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\"\u0001!I!a\t\u0003%Q{\u0007/[2D_:4\u0017n\u001a%b]\u0012dWM\u001d\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0006\u000e\u001f!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004H\u0007\u0002\u001d%\u0011QD\u0004\u0002\u000e\u0007>tg-[4IC:$G.\u001a:\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u0002\u0012!B;uS2\u001c\u0018BA\u0012!\u0005\u001daunZ4j]\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001'!\tYr%\u0003\u0002)\u001d\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0017-\fgm[1D_:4\u0017n\u001a\t\u000371J!!\f\b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0007cV|G/Y:\u0016\u0003A\u0002\"!M\u001e\u000f\u0005IJdBA\u001a9\u001d\t!t'D\u00016\u0015\t1$#\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003u9\tA\"U;pi\u00064\u0015m\u0019;pefL!\u0001P\u001f\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\tQd\"A\u0004rk>$\u0018m\u001d\u0011\u0002\u001f-\fgm[1D_:$(o\u001c7mKJ\u00042!F!D\u0013\t\u0011eC\u0001\u0004PaRLwN\u001c\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rB\t!bY8oiJ|G\u000e\\3s\u0013\tAUIA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003\u0019a\u0014N\\5u}Q)1\nT'O\u001fB\u00111\u0004\u0001\u0005\u0006I\u001d\u0001\rA\n\u0005\u0006U\u001d\u0001\ra\u000b\u0005\u0006]\u001d\u0001\r\u0001\r\u0005\u0006\u007f\u001d\u0001\r\u0001Q\u0001\u0010kB$\u0017\r^3M_\u001e\u001cuN\u001c4jOR\u0019!+V0\u0011\u0005U\u0019\u0016B\u0001+\u0017\u0005\u0011)f.\u001b;\t\u000bYC\u0001\u0019A,\u0002\u000bQ|\u0007/[2\u0011\u0005acfBA-[!\t!d#\u0003\u0002\\-\u00051\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tYf\u0003C\u0003a\u0011\u0001\u0007\u0011-A\u0006u_BL7mQ8oM&<\u0007C\u00012h\u001b\u0005\u0019'B\u00013f\u0003\u0011)H/\u001b7\u000b\u0003\u0019\fAA[1wC&\u0011\u0001n\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018AH7bs\n,W\u000b\u001d3bi\u0016\u0014V-\\8uK2{wmQ8na>tWM\u001c;t)\u0015\u00116\u000e\u001c>\u0000\u0011\u00151\u0016\u00021\u0001X\u0011\u0015i\u0017\u00021\u0001o\u0003\u0011awnZ:\u0011\u0007=\u0014H/D\u0001q\u0015\t\th#\u0001\u0006d_2dWm\u0019;j_:L!a\u001d9\u0003\u0007M+\u0017\u000f\u0005\u0002vq6\taO\u0003\u0002x!\u0005\u0019An\\4\n\u0005e4(AC+oS\u001aLW\r\u001a'pO\")10\u0003a\u0001y\u0006\u0019r/Y:SK6|G/\u001a'pO\u0016s\u0017M\u00197fIB\u0011Q#`\u0005\u0003}Z\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u0002%\u0001\r\u0001`\u0001\u0010o\u0006\u001c8i\u001c9z\t&\u001c\u0018M\u00197fI\u0006!\u0002O]8dKN\u001c8i\u001c8gS\u001e\u001c\u0005.\u00198hKN$RAUA\u0004\u0003\u0013AQA\u0016\u0006A\u0002]CQ\u0001\u0019\u0006A\u0002\u0005\f\u0001\u0004]1sg\u0016$\u0006N]8ui2,G\rU1si&$\u0018n\u001c8t)!\ty!a\u0006\u0002\u001a\u0005u\u0001\u0003B8s\u0003#\u00012!FA\n\u0013\r\t)B\u0006\u0002\u0004\u0013:$\b\"\u00021\f\u0001\u0004\t\u0007bBA\u000e\u0017\u0001\u0007\u0011\u0011C\u0001\tEJ|7.\u001a:JI\"1\u0011qD\u0006A\u0002]\u000bA\u0001\u001d:pa\u0006yQ\r_2mk\u0012,GmQ8oM&<7\u000f\u0006\u0004\u0002&\u0005-\u0012Q\u0006\t\u00051\u0006\u001dr+C\u0002\u0002*y\u00131aU3u\u0011\u00151F\u00021\u0001X\u0011\u0015\u0001G\u00021\u0001b\u0001")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final Option<KafkaController> kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private void updateLogConfig(String topic, Properties topicConfig) {
        LogManager logManager = this.replicaManager().logManager();
        scala.collection.immutable.Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Properties props = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfig).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
            if (!configNamesToExclude.contains(key)) {
                return props.put(key, value);
            }
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        Seq<UnifiedLog> logs = logManager.logsByTopic(topic);
        boolean wasRemoteLogEnabled = logs.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.remoteLogEnabled()));
        boolean wasCopyDisabled = logs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$2.config().remoteLogCopyDisable())));
        logManager.updateTopicConfig(topic, props, this.kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), wasRemoteLogEnabled, this.kafkaController.isDefined());
        this.maybeUpdateRemoteLogComponents(topic, logs, wasRemoteLogEnabled, wasCopyDisabled);
    }

    /*
     * WARNING - void declaration
     */
    public void maybeUpdateRemoteLogComponents(String topic, Seq<UnifiedLog> logs, boolean wasRemoteLogEnabled, boolean wasCopyDisabled) {
        void var10_10;
        void var9_9;
        boolean isRemoteLogEnabled = logs.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.remoteLogEnabled()));
        boolean isCopyDisabled = logs.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$4.config().remoteLogCopyDisable())));
        boolean isDeleteOnDisable = logs.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$5.config().remoteLogDeleteOnDisable())));
        Tuple2 tuple2 = ((IterableOps)logs.flatMap((Function1 & Serializable)log -> this.replicaManager().onlinePartition(log.topicPartition()))).partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isLeader()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq leaderPartitions = (Seq)tuple2._1();
        Seq followerPartitions = (Seq)tuple2._2();
        if (isRemoteLogEnabled && (!wasRemoteLogEnabled || wasCopyDisabled && !isCopyDisabled)) {
            Map<String, Uuid> topicIds = Collections.singletonMap(topic, this.replicaManager().metadataCache().getTopicId(topic));
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$6$adapted((Seq)var9_9, (Seq)var10_10, topicIds, arg_0));
        }
        if (isRemoteLogEnabled && !wasCopyDisabled && isCopyDisabled) {
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$7$adapted((Seq)var9_9, arg_0));
        }
        if (wasRemoteLogEnabled && !isRemoteLogEnabled && isDeleteOnDisable) {
            HashSet stopPartitions = new HashSet();
            var9_9.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)stopPartitions.add(new StopPartition(partition.topicPartition(), false, true, true))));
            var10_10.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)stopPartitions.add(new StopPartition(partition.topicPartition(), false, false, true))));
            ((IterableOnceOps)logs.filter(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$10$adapted((Seq)var9_9, arg_0))).foreach((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)log.maybeIncrementLogStartOffset(log.localLogStartOffset(), LogStartOffsetIncrementReason.SegmentDeletion)));
            this.replicaManager().remoteLogManager().foreach((Function1 & Serializable)rlm -> {
                rlm.stopPartitions(stopPartitions, (x$8, x$9) -> {});
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        this.updateLogConfig(topic, topicConfig);
        this.updateThrottledList$1("leader.replication.throttled.replicas", this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1("follower.replication.throttled.replicas", this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig.getProperty(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            this.kafkaController.foreach((Function1 & Serializable)x$10 -> {
                x$10.enableTopicUncleanLeaderElection(topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator.ensureValidString((String)prop, (String)configValue);
        switch (configValue == null ? 0 : configValue.hashCode()) {
            case 0: {
                if (!"".equals(configValue)) break;
                return Nil$.MODULE$;
            }
            case 42: {
                if (!"*".equals(configValue)) break;
                return Constants$.MODULE$.AllReplicas();
            }
        }
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$11 -> x$11.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$12)))), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$13[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
    }

    private scala.collection.immutable.Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty("message.format.version")).flatMap((Function1 & Serializable)versionString -> {
            LogConfig.MessageFormatVersion messageFormatVersion = new LogConfig.MessageFormatVersion(versionString, $this.kafkaConfig.interBrokerProtocolVersion().version());
            if (messageFormatVersion.shouldIgnore()) {
                if (messageFormatVersion.shouldWarn()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> messageFormatVersion.topicWarningMessage(topic));
                }
                return new Some((Object)"message.format.version");
            }
            if ($this.kafkaConfig.interBrokerProtocolVersion().isLessThan(messageFormatVersion.messageFormatVersion())) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(142).append("Topic configuration ").append("message.format.version").append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append("is higher than what is allowed by the inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
                return new Some((Object)"message.format.version");
            }
            return None$.MODULE$;
        })).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateRemoteLogComponents$11(UnifiedLog log$1, Partition p) {
        return p.topicPartition().equals((Object)log$1.topicPartition());
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop)))) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$12) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$12[1])) == brokerId$1;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, Option<KafkaController> kafkaController) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$6$adapted(Seq leaderPartitions$1, Seq followerPartitions$1, Map topicIds$1, RemoteLogManager rlm) {
        rlm.onLeadershipChange(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)followerPartitions$1.toSet()).asJava(), topicIds$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$7$adapted(Seq leaderPartitions$1, RemoteLogManager rlm) {
        rlm.stopLeaderCopyRLMTasks(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$10$adapted(Seq leaderPartitions$1, UnifiedLog log) {
        return BoxesRunTime.boxToBoolean((boolean)leaderPartitions$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$11(log, p))));
    }
}

