/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorRedirectFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Collection<ErrorHolder> errors = new ArrayList<ErrorHolder>();
    private String defaultErrorRedirectPage;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.defaultErrorRedirectPage = filterConfig.getInitParameter("defaultErrorRedirectPage");
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String className = (String)enumeration.nextElement();
            try {
                if (className.equals("defaultErrorRedirectPage")) continue;
                this.errors.add(new ErrorHolder(className, filterConfig.getInitParameter(className)));
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("Class [{}] cannot be found in ClassLoader.  Ignoring.", (Object)className);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            filterChain.doFilter(request, response);
        }
        catch (Exception e) {
            Throwable t = ErrorRedirectFilter.extractErrorToCompare(e);
            ErrorHolder currentMatch = null;
            for (ErrorHolder errorHolder : this.errors) {
                if (errorHolder.exactMatch(t)) {
                    currentMatch = errorHolder;
                    break;
                }
                if (!errorHolder.inheritanceMatch(t)) continue;
                currentMatch = errorHolder;
            }
            if (currentMatch != null) {
                httpResponse.sendRedirect(currentMatch.getUrl());
            }
            httpResponse.sendRedirect(this.defaultErrorRedirectPage);
        }
    }

    public void destroy() {
    }

    private static Throwable extractErrorToCompare(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            return cause;
        }
        return throwable;
    }

    protected final class ErrorHolder {
        private Class<?> className;
        private String url;

        private ErrorHolder(String className, String url) throws ClassNotFoundException {
            this.className = Class.forName(className);
            this.url = url;
        }

        public boolean exactMatch(Throwable e) {
            return this.className.equals(e.getClass());
        }

        public boolean inheritanceMatch(Throwable e) {
            return this.className.isAssignableFrom(e.getClass());
        }

        public String getUrl() {
            return this.url;
        }
    }
}

