/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.TypeExtensionHolderTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@Schema(allOf={AnyTO.class})
public class GroupTO
extends AnyTO
implements TypeExtensionHolderTO {
    private static final long serialVersionUID = -7785920258290147542L;
    private String name;
    private long userMembershipCount;
    private long anyObjectMembershipCount;
    private final List<TypeExtensionTO> typeExtensions = new ArrayList<TypeExtensionTO>();

    @Override
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.to.GroupTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @Override
    public String getType() {
        return AnyTypeKind.GROUP.name();
    }

    @Override
    public void setType(String type) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getUserMembershipCount() {
        return this.userMembershipCount;
    }

    public void setUserMembershipCount(long userMembershipCount) {
        this.userMembershipCount = userMembershipCount;
    }

    public long getAnyObjectMembershipCount() {
        return this.anyObjectMembershipCount;
    }

    public void setAnyObjectMembershipCount(long anyObjectMembershipCount) {
        this.anyObjectMembershipCount = anyObjectMembershipCount;
    }

    @Override
    @JsonIgnore
    public Optional<TypeExtensionTO> getTypeExtension(String anyType) {
        return this.typeExtensions.stream().filter(typeExtension -> anyType != null && anyType.equals(typeExtension.getAnyType())).findFirst();
    }

    @Override
    public List<TypeExtensionTO> getTypeExtensions() {
        return this.typeExtensions;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.name).append(this.typeExtensions).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupTO other = (GroupTO)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.name, (Object)other.name).append(this.typeExtensions, other.typeExtensions).build();
    }
}

