/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.ValidationResponseType;
import org.apereo.cas.web.ServiceValidationViewTypes;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ServiceValidationViewFactory {
    public static final String BEAN_NAME = "serviceValidationViewFactory";
    private final Map<String, Pair<View, View>> registeredViews = new HashMap<String, Pair<View, View>>();

    public void registerView(Class ownerClass, Pair<View, View> view) {
        this.registerView(ownerClass.getSimpleName(), view);
    }

    public void registerView(ServiceValidationViewTypes type, View view) {
        this.registerView(type.getType(), (Pair<View, View>)Pair.of((Object)view, (Object)view));
    }

    public void registerView(String type, Pair<View, View> view) {
        this.registeredViews.put(type, view);
    }

    public Pair<View, View> getView(String type) {
        return this.registeredViews.get(type);
    }

    public View getView(HttpServletRequest request, boolean isSuccess, WebApplicationService service, Class ownerClass) {
        ValidationResponseType type = ServiceValidationViewFactory.getValidationResponseType(request, service);
        if (type == ValidationResponseType.JSON) {
            return this.getSingleInstanceView(ServiceValidationViewTypes.JSON);
        }
        return isSuccess ? this.getSuccessView(ownerClass.getSimpleName()) : this.getFailureView(ownerClass.getSimpleName());
    }

    public View getSingleInstanceView(ServiceValidationViewTypes type) {
        return (View)this.getView(type.getType()).getKey();
    }

    public View getSuccessView(String type) {
        return (View)this.getView(type).getKey();
    }

    public View getSuccessView(Class type) {
        return (View)this.getView(type.getSimpleName()).getKey();
    }

    public View getFailureView(String type) {
        return (View)this.getView(type).getValue();
    }

    public View getFailureView(Class type) {
        return (View)this.getView(type.getSimpleName()).getValue();
    }

    public ModelAndView getModelAndView(HttpServletRequest request, boolean isSuccess, WebApplicationService service, Class ownerClass) {
        View view = this.getView(request, isSuccess, service, ownerClass);
        return new ModelAndView(view);
    }

    private static ValidationResponseType getValidationResponseType(HttpServletRequest request, WebApplicationService service) {
        String format = request.getParameter("format");
        Function func = FunctionUtils.doIf(StringUtils::isNotBlank, t -> ValidationResponseType.valueOf((String)t.toUpperCase(Locale.ENGLISH)), __ -> service != null ? service.getFormat() : ValidationResponseType.XML);
        return (ValidationResponseType)func.apply(format);
    }
}

