/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.AbstractHeaderGeneratingMessageHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.wsaddressing.Action;
import org.opensaml.soap.wsaddressing.WSAddressingConstants;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.slf4j.Logger;

public class AddActionHandler
extends AbstractHeaderGeneratingMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddActionHandler.class);
    @Nullable
    private String actionURI;
    @Nullable
    private String faultActionURI;
    @Nullable
    private String sendURI;

    @Nullable
    public String getActionURI() {
        return this.actionURI;
    }

    public void setActionURI(@Nullable String uri) {
        this.checkSetterPreconditions();
        this.actionURI = StringSupport.trimOrNull((String)uri);
    }

    @Nullable
    public String getFaultActionURI() {
        return this.faultActionURI;
    }

    public void setFaultActionURI(@Nullable String uri) {
        this.checkSetterPreconditions();
        this.faultActionURI = StringSupport.trimOrNull((String)uri);
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        WSAddressingContext addressingContext = (WSAddressingContext)messageContext.getSubcontext(WSAddressingContext.class);
        Fault fault = SOAPMessagingSupport.getSOAP11Fault((MessageContext)messageContext);
        if (fault != null) {
            this.log.debug("Saw SOAP Fault registered in message context, selecting Fault Action URI");
            this.sendURI = addressingContext != null && addressingContext.getFaultActionURI() != null ? addressingContext.getFaultActionURI() : (this.faultActionURI != null ? this.faultActionURI : this.selectActionURIForFault(fault));
        } else {
            this.sendURI = addressingContext != null && addressingContext.getActionURI() != null ? addressingContext.getActionURI() : this.actionURI;
        }
        if (this.sendURI == null) {
            this.log.debug("No WS-Addressing Action URI found locally or in message context, skipping further processing");
            return false;
        }
        return true;
    }

    @Nonnull
    protected String selectActionURIForFault(@Nonnull Fault fault) {
        QName faultCode = null;
        FaultCode fcode = fault.getCode();
        if (fcode != null) {
            faultCode = fcode.getValue();
        }
        if (faultCode != null && WSAddressingConstants.WS_ADDRESSING_FAULTS.contains(faultCode)) {
            return "http://www.w3.org/2005/08/addressing/fault";
        }
        return "http://www.w3.org/2005/08/addressing/soap/fault";
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("Issuing WS-Addressing Action header with URI value: {}", (Object)this.sendURI);
        Action action = (Action)XMLObjectSupport.buildXMLObject((QName)Action.ELEMENT_NAME);
        action.setURI(this.sendURI);
        this.decorateGeneratedHeader(messageContext, (XMLObject)action);
        SOAPMessagingSupport.addHeaderBlock((MessageContext)messageContext, (XMLObject)action);
    }
}

