/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.composite;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ChainingMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderSelectionProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.core.Ordered;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrepareMultifactorProviderSelectionAction
extends BaseCasWebflowAction {
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) {
        AttributeMap attributes = requestContext.getCurrentEvent().getAttributes();
        RegisteredService registeredService = (RegisteredService)attributes.get(RegisteredService.class.getName(), RegisteredService.class);
        Service service = (Service)attributes.get(Service.class.getName(), Service.class);
        WebUtils.putRegisteredService((RequestContext)requestContext, (RegisteredService)registeredService);
        this.prepareSelectableMultifactorProviders(requestContext, registeredService, service);
        this.determineMultifactorProviderOptional(requestContext, registeredService, service);
        return null;
    }

    protected void determineMultifactorProviderOptional(RequestContext requestContext, RegisteredService registeredService, Service service) {
        MultifactorAuthenticationProviderSelectionProperties providerSelection = this.casProperties.getAuthn().getMfa().getCore().getProviderSelection();
        MultifactorAuthenticationWebflowUtils.putMultifactorAuthenticationOptional(requestContext, providerSelection.isProviderSelectionEnabled() && providerSelection.isProviderSelectionOptional());
    }

    protected void prepareSelectableMultifactorProviders(RequestContext requestContext, RegisteredService registeredService, Service service) {
        ChainingMultifactorAuthenticationProvider mfaProvider = (ChainingMultifactorAuthenticationProvider)requestContext.getCurrentEvent().getAttributes().get(MultifactorAuthenticationProvider.class.getName());
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        List<String> mfaProviders = mfaProvider.getMultifactorAuthenticationProviders().stream().filter(provider -> provider.isAvailable(registeredService) && provider.getBypassEvaluator().shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, provider, request, service)).sorted(Comparator.comparing(Ordered::getOrder)).map(MultifactorAuthenticationProvider::getId).collect(Collectors.toList());
        MultifactorAuthenticationWebflowUtils.putSelectableMultifactorAuthenticationProviders(requestContext, mfaProviders);
    }

    @Generated
    public PrepareMultifactorProviderSelectionAction(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

