/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.PrincipalAttributeRepositoryFilter;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalAttributeRepositoryFetcher {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalAttributeRepositoryFetcher.class);
    private final PersonAttributeDao attributeRepository;
    private final String principalId;
    private final Set<String> activeAttributeRepositoryIdentifiers;
    private final Map<String, List<Object>> queryAttributes;
    private final Principal currentPrincipal;
    private final Service service;

    public Map<String, List<Object>> retrieve() {
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>();
        if (this.currentPrincipal != null) {
            query.put("principal", this.currentPrincipal.getId());
            query.putAll(this.currentPrincipal.getAttributes());
        }
        query.putAll(this.queryAttributes);
        query.put("username", this.principalId.trim());
        if (this.service != null) {
            query.put("service", this.service.getId());
        }
        LOGGER.debug("Fetching person attributes for query [{}]", query);
        Set people = this.attributeRepository.getPeople(query, (PersonAttributeDaoFilter)PrincipalAttributeRepositoryFilter.of(this));
        if (people == null || people.isEmpty()) {
            LOGGER.warn("No person records were fetched from attribute repositories for [{}]", query);
            return new HashMap<String, List<Object>>();
        }
        if (people.size() > 1) {
            LOGGER.warn("Multiple records were found for [{}] from attribute repositories for query [{}]. The records are [{}], and CAS will only pick the first person record from the results.", new Object[]{this.principalId, query, people});
        }
        PersonAttributes person = (PersonAttributes)people.iterator().next();
        LOGGER.debug("Retrieved person [{}] from attribute repositories for query [{}]", (Object)person, query);
        return person.getAttributes();
    }

    @CanIgnoreReturnValue
    public PrincipalAttributeRepositoryFetcher fromAllAttributeRepositories() {
        this.activeAttributeRepositoryIdentifiers.add("*");
        return this;
    }

    @Generated
    private static Set<String> $default$activeAttributeRepositoryIdentifiers() {
        return new HashSet<String>();
    }

    @Generated
    private static Map<String, List<Object>> $default$queryAttributes() {
        return new HashMap<String, List<Object>>();
    }

    @Generated
    protected PrincipalAttributeRepositoryFetcher(PrincipalAttributeRepositoryFetcherBuilder<?, ?> b) {
        this.attributeRepository = b.attributeRepository;
        this.principalId = b.principalId;
        this.activeAttributeRepositoryIdentifiers = b.activeAttributeRepositoryIdentifiers$set ? b.activeAttributeRepositoryIdentifiers$value : PrincipalAttributeRepositoryFetcher.$default$activeAttributeRepositoryIdentifiers();
        this.queryAttributes = b.queryAttributes$set ? b.queryAttributes$value : PrincipalAttributeRepositoryFetcher.$default$queryAttributes();
        this.currentPrincipal = b.currentPrincipal;
        this.service = b.service;
    }

    @Generated
    public static PrincipalAttributeRepositoryFetcherBuilder<?, ?> builder() {
        return new PrincipalAttributeRepositoryFetcherBuilderImpl();
    }

    @Generated
    public PersonAttributeDao getAttributeRepository() {
        return this.attributeRepository;
    }

    @Generated
    public String getPrincipalId() {
        return this.principalId;
    }

    @Generated
    public Set<String> getActiveAttributeRepositoryIdentifiers() {
        return this.activeAttributeRepositoryIdentifiers;
    }

    @Generated
    public Map<String, List<Object>> getQueryAttributes() {
        return this.queryAttributes;
    }

    @Generated
    public Principal getCurrentPrincipal() {
        return this.currentPrincipal;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public static abstract class PrincipalAttributeRepositoryFetcherBuilder<C extends PrincipalAttributeRepositoryFetcher, B extends PrincipalAttributeRepositoryFetcherBuilder<C, B>> {
        @Generated
        private PersonAttributeDao attributeRepository;
        @Generated
        private String principalId;
        @Generated
        private boolean activeAttributeRepositoryIdentifiers$set;
        @Generated
        private Set<String> activeAttributeRepositoryIdentifiers$value;
        @Generated
        private boolean queryAttributes$set;
        @Generated
        private Map<String, List<Object>> queryAttributes$value;
        @Generated
        private Principal currentPrincipal;
        @Generated
        private Service service;

        @Generated
        public B attributeRepository(PersonAttributeDao attributeRepository) {
            this.attributeRepository = attributeRepository;
            return this.self();
        }

        @Generated
        public B principalId(String principalId) {
            this.principalId = principalId;
            return this.self();
        }

        @Generated
        public B activeAttributeRepositoryIdentifiers(Set<String> activeAttributeRepositoryIdentifiers) {
            this.activeAttributeRepositoryIdentifiers$value = activeAttributeRepositoryIdentifiers;
            this.activeAttributeRepositoryIdentifiers$set = true;
            return this.self();
        }

        @Generated
        public B queryAttributes(Map<String, List<Object>> queryAttributes) {
            this.queryAttributes$value = queryAttributes;
            this.queryAttributes$set = true;
            return this.self();
        }

        @Generated
        public B currentPrincipal(Principal currentPrincipal) {
            this.currentPrincipal = currentPrincipal;
            return this.self();
        }

        @Generated
        public B service(Service service) {
            this.service = service;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PrincipalAttributeRepositoryFetcher.PrincipalAttributeRepositoryFetcherBuilder(attributeRepository=" + String.valueOf(this.attributeRepository) + ", principalId=" + this.principalId + ", activeAttributeRepositoryIdentifiers$value=" + String.valueOf(this.activeAttributeRepositoryIdentifiers$value) + ", queryAttributes$value=" + String.valueOf(this.queryAttributes$value) + ", currentPrincipal=" + String.valueOf(this.currentPrincipal) + ", service=" + String.valueOf(this.service) + ")";
        }
    }

    @Generated
    private static final class PrincipalAttributeRepositoryFetcherBuilderImpl
    extends PrincipalAttributeRepositoryFetcherBuilder<PrincipalAttributeRepositoryFetcher, PrincipalAttributeRepositoryFetcherBuilderImpl> {
        @Generated
        private PrincipalAttributeRepositoryFetcherBuilderImpl() {
        }

        @Override
        @Generated
        protected PrincipalAttributeRepositoryFetcherBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PrincipalAttributeRepositoryFetcher build() {
            return new PrincipalAttributeRepositoryFetcher(this);
        }
    }
}

