/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.attribute.StubPersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.springframework.util.StringUtils;

public final class PersonAttributeUtils {
    public static PersonAttributeDao newStubAttributeRepository(StubPrincipalAttributesProperties stub) {
        StubPersonAttributeDao dao = new StubPersonAttributeDao();
        LinkedHashMap<String, List<Object>> backingMap = new LinkedHashMap<String, List<Object>>();
        stub.getAttributes().forEach((key, value) -> {
            String[] vals = StringUtils.commaDelimitedListToStringArray((String)value);
            backingMap.put((String)key, Arrays.stream(vals).map(v -> {
                Boolean result = BooleanUtils.toBooleanObject((String)v);
                if (result != null) {
                    return result;
                }
                return v;
            }).collect(Collectors.toList()));
        });
        dao.setBackingMap(backingMap);
        dao.setOrder(stub.getOrder());
        dao.setEnabled(stub.getState() != AttributeRepositoryStates.DISABLED);
        dao.putTag("state", stub.getState());
        if (StringUtils.hasText((String)stub.getId())) {
            dao.setId(stub.getId());
        }
        return dao;
    }

    @Generated
    private PersonAttributeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

